/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartZonalShiftRequest extends ArcZonalShiftRequest implements
        ToCopyableBuilder<StartZonalShiftRequest.Builder, StartZonalShiftRequest> {
    private static final SdkField<String> AWAY_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awayFrom").getter(getter(StartZonalShiftRequest::awayFrom)).setter(setter(Builder::awayFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awayFrom").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(StartZonalShiftRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<String> EXPIRES_IN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expiresIn").getter(getter(StartZonalShiftRequest::expiresIn)).setter(setter(Builder::expiresIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(StartZonalShiftRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWAY_FROM_FIELD,
            COMMENT_FIELD, EXPIRES_IN_FIELD, RESOURCE_IDENTIFIER_FIELD));

    private final String awayFrom;

    private final String comment;

    private final String expiresIn;

    private final String resourceIdentifier;

    private StartZonalShiftRequest(BuilderImpl builder) {
        super(builder);
        this.awayFrom = builder.awayFrom;
        this.comment = builder.comment;
        this.expiresIn = builder.expiresIn;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    /**
     * <p>
     * The Availability Zone that traffic is moved away from for a resource when you start a zonal shift. Until the
     * zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in
     * the Amazon Web Services Region.
     * </p>
     * 
     * @return The Availability Zone that traffic is moved away from for a resource when you start a zonal shift. Until
     *         the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability
     *         Zones in the Amazon Web Services Region.
     */
    public final String awayFrom() {
        return awayFrom;
    }

    /**
     * <p>
     * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is
     * maintained. A new comment overwrites any existing comment string.
     * </p>
     * 
     * @return A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history
     *         is maintained. A new comment overwrites any existing comment string.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The length of time that you want a zonal shift to be active, which Route 53 ARC converts to an expiry time
     * (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to three
     * days (72 hours).
     * </p>
     * <p>
     * If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set a new
     * expiration. You can also cancel a zonal shift, before it expires, for example, if you're ready to restore traffic
     * to the Availability Zone.
     * </p>
     * <p>
     * To set a length of time for a zonal shift to be active, specify a whole number, and then one of the following,
     * with no space:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>A lowercase letter m:</b> To specify that the value is in minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>A lowercase letter h:</b> To specify that the value is in hours.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example: <code>20h</code> means the zonal shift expires in 20 hours. <code>120m</code> means the zonal shift
     * expires in 120 minutes (2 hours).
     * </p>
     * 
     * @return The length of time that you want a zonal shift to be active, which Route 53 ARC converts to an expiry
     *         time (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for
     *         up to three days (72 hours).</p>
     *         <p>
     *         If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set
     *         a new expiration. You can also cancel a zonal shift, before it expires, for example, if you're ready to
     *         restore traffic to the Availability Zone.
     *         </p>
     *         <p>
     *         To set a length of time for a zonal shift to be active, specify a whole number, and then one of the
     *         following, with no space:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>A lowercase letter m:</b> To specify that the value is in minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>A lowercase letter h:</b> To specify that the value is in hours.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example: <code>20h</code> means the zonal shift expires in 20 hours. <code>120m</code> means the
     *         zonal shift expires in 120 minutes (2 hours).
     */
    public final String expiresIn() {
        return expiresIn;
    }

    /**
     * <p>
     * The identifier for the resource to shift away traffic for. The identifier is the Amazon Resource Name (ARN) for
     * the resource.
     * </p>
     * <p>
     * At this time, supported resources are Network Load Balancers and Application Load Balancers with cross-zone load
     * balancing turned off.
     * </p>
     * 
     * @return The identifier for the resource to shift away traffic for. The identifier is the Amazon Resource Name
     *         (ARN) for the resource.</p>
     *         <p>
     *         At this time, supported resources are Network Load Balancers and Application Load Balancers with
     *         cross-zone load balancing turned off.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awayFrom());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartZonalShiftRequest)) {
            return false;
        }
        StartZonalShiftRequest other = (StartZonalShiftRequest) obj;
        return Objects.equals(awayFrom(), other.awayFrom()) && Objects.equals(comment(), other.comment())
                && Objects.equals(expiresIn(), other.expiresIn())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartZonalShiftRequest").add("AwayFrom", awayFrom()).add("Comment", comment())
                .add("ExpiresIn", expiresIn()).add("ResourceIdentifier", resourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awayFrom":
            return Optional.ofNullable(clazz.cast(awayFrom()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "expiresIn":
            return Optional.ofNullable(clazz.cast(expiresIn()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartZonalShiftRequest, T> g) {
        return obj -> g.apply((StartZonalShiftRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ArcZonalShiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartZonalShiftRequest> {
        /**
         * <p>
         * The Availability Zone that traffic is moved away from for a resource when you start a zonal shift. Until the
         * zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones
         * in the Amazon Web Services Region.
         * </p>
         * 
         * @param awayFrom
         *        The Availability Zone that traffic is moved away from for a resource when you start a zonal shift.
         *        Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other
         *        Availability Zones in the Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awayFrom(String awayFrom);

        /**
         * <p>
         * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is
         * maintained. A new comment overwrites any existing comment string.
         * </p>
         * 
         * @param comment
         *        A comment that you enter about the zonal shift. Only the latest comment is retained; no comment
         *        history is maintained. A new comment overwrites any existing comment string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The length of time that you want a zonal shift to be active, which Route 53 ARC converts to an expiry time
         * (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to
         * three days (72 hours).
         * </p>
         * <p>
         * If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set a
         * new expiration. You can also cancel a zonal shift, before it expires, for example, if you're ready to restore
         * traffic to the Availability Zone.
         * </p>
         * <p>
         * To set a length of time for a zonal shift to be active, specify a whole number, and then one of the
         * following, with no space:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>A lowercase letter m:</b> To specify that the value is in minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>A lowercase letter h:</b> To specify that the value is in hours.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example: <code>20h</code> means the zonal shift expires in 20 hours. <code>120m</code> means the zonal
         * shift expires in 120 minutes (2 hours).
         * </p>
         * 
         * @param expiresIn
         *        The length of time that you want a zonal shift to be active, which Route 53 ARC converts to an expiry
         *        time (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially
         *        for up to three days (72 hours).</p>
         *        <p>
         *        If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and
         *        set a new expiration. You can also cancel a zonal shift, before it expires, for example, if you're
         *        ready to restore traffic to the Availability Zone.
         *        </p>
         *        <p>
         *        To set a length of time for a zonal shift to be active, specify a whole number, and then one of the
         *        following, with no space:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>A lowercase letter m:</b> To specify that the value is in minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>A lowercase letter h:</b> To specify that the value is in hours.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example: <code>20h</code> means the zonal shift expires in 20 hours. <code>120m</code> means the
         *        zonal shift expires in 120 minutes (2 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresIn(String expiresIn);

        /**
         * <p>
         * The identifier for the resource to shift away traffic for. The identifier is the Amazon Resource Name (ARN)
         * for the resource.
         * </p>
         * <p>
         * At this time, supported resources are Network Load Balancers and Application Load Balancers with cross-zone
         * load balancing turned off.
         * </p>
         * 
         * @param resourceIdentifier
         *        The identifier for the resource to shift away traffic for. The identifier is the Amazon Resource Name
         *        (ARN) for the resource.</p>
         *        <p>
         *        At this time, supported resources are Network Load Balancers and Application Load Balancers with
         *        cross-zone load balancing turned off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcZonalShiftRequest.BuilderImpl implements Builder {
        private String awayFrom;

        private String comment;

        private String expiresIn;

        private String resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StartZonalShiftRequest model) {
            super(model);
            awayFrom(model.awayFrom);
            comment(model.comment);
            expiresIn(model.expiresIn);
            resourceIdentifier(model.resourceIdentifier);
        }

        public final String getAwayFrom() {
            return awayFrom;
        }

        public final void setAwayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
        }

        @Override
        public final Builder awayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getExpiresIn() {
            return expiresIn;
        }

        public final void setExpiresIn(String expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(String expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartZonalShiftRequest build() {
            return new StartZonalShiftRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
