/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control condition is an alarm that you specify for a practice run. When you configure practice runs with zonal
 * autoshift for a resource, you specify Amazon CloudWatch alarms, which you create in CloudWatch to use with the
 * practice run. The alarms that you specify are an <i>outcome alarm</i>, to monitor application health during practice
 * runs and, optionally, a <i>blocking alarm</i>, to block practice runs from starting or to interrupt a practice run in
 * progress.
 * </p>
 * <p>
 * Control condition alarms do not apply for autoshifts.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html"> Considerations when
 * you configure zonal autoshift</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<ControlCondition.Builder, ControlCondition> {
    private static final SdkField<String> ALARM_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmIdentifier").getter(getter(ControlCondition::alarmIdentifier))
            .setter(setter(Builder::alarmIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmIdentifier").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ControlCondition::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_IDENTIFIER_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alarmIdentifier;

    private final String type;

    private ControlCondition(BuilderImpl builder) {
        this.alarmIdentifier = builder.alarmIdentifier;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for a
     * practice run.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for
     *         a practice run.
     */
    public final String alarmIdentifier() {
        return alarmIdentifier;
    }

    /**
     * <p>
     * The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for practice runs,
     * so the only valid value is <code>CLOUDWATCH</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ControlConditionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for
     *         practice runs, so the only valid value is <code>CLOUDWATCH</code>.
     * @see ControlConditionType
     */
    public final ControlConditionType type() {
        return ControlConditionType.fromValue(type);
    }

    /**
     * <p>
     * The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for practice runs,
     * so the only valid value is <code>CLOUDWATCH</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ControlConditionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for
     *         practice runs, so the only valid value is <code>CLOUDWATCH</code>.
     * @see ControlConditionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlCondition)) {
            return false;
        }
        ControlCondition other = (ControlCondition) obj;
        return Objects.equals(alarmIdentifier(), other.alarmIdentifier()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlCondition").add("AlarmIdentifier", alarmIdentifier()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmIdentifier":
            return Optional.ofNullable(clazz.cast(alarmIdentifier()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlCondition, T> g) {
        return obj -> g.apply((ControlCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlCondition> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for a
         * practice run.
         * </p>
         * 
         * @param alarmIdentifier
         *        The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition
         *        for a practice run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmIdentifier(String alarmIdentifier);

        /**
         * <p>
         * The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for practice
         * runs, so the only valid value is <code>CLOUDWATCH</code>.
         * </p>
         * 
         * @param type
         *        The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for
         *        practice runs, so the only valid value is <code>CLOUDWATCH</code>.
         * @see ControlConditionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlConditionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for practice
         * runs, so the only valid value is <code>CLOUDWATCH</code>.
         * </p>
         * 
         * @param type
         *        The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for
         *        practice runs, so the only valid value is <code>CLOUDWATCH</code>.
         * @see ControlConditionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlConditionType
         */
        Builder type(ControlConditionType type);
    }

    static final class BuilderImpl implements Builder {
        private String alarmIdentifier;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlCondition model) {
            alarmIdentifier(model.alarmIdentifier);
            type(model.type);
        }

        public final String getAlarmIdentifier() {
            return alarmIdentifier;
        }

        public final void setAlarmIdentifier(String alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier;
        }

        @Override
        public final Builder alarmIdentifier(String alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ControlConditionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public ControlCondition build() {
            return new ControlCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
