/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex structure for a managed resource in an Amazon Web Services account with information about zonal shifts and
 * autoshifts.
 * </p>
 * <p>
 * A managed resource is a load balancer that has been registered with Route 53 ARC by Elastic Load Balancing. You can
 * start a zonal shift in Route 53 ARC for a managed resource to temporarily move traffic for the resource away from an
 * Availability Zone in an Amazon Web Services Region. You can also configure zonal autoshift for a managed resource.
 * </p>
 * <note>
 * <p>
 * At this time, managed resources are Network Load Balancers and Application Load Balancers with cross-zone load
 * balancing turned off.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedResourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedResourceSummary.Builder, ManagedResourceSummary> {
    private static final SdkField<Map<String, Float>> APPLIED_WEIGHTS_FIELD = SdkField
            .<Map<String, Float>> builder(MarshallingType.MAP)
            .memberName("appliedWeights")
            .getter(getter(ManagedResourceSummary::appliedWeights))
            .setter(setter(Builder::appliedWeights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedWeights").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Float> builder(MarshallingType.FLOAT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ManagedResourceSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<AutoshiftInResource>> AUTOSHIFTS_FIELD = SdkField
            .<List<AutoshiftInResource>> builder(MarshallingType.LIST)
            .memberName("autoshifts")
            .getter(getter(ManagedResourceSummary::autoshifts))
            .setter(setter(Builder::autoshifts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoshifts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoshiftInResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoshiftInResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("availabilityZones")
            .getter(getter(ManagedResourceSummary::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ManagedResourceSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PRACTICE_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("practiceRunStatus").getter(getter(ManagedResourceSummary::practiceRunStatusAsString))
            .setter(setter(Builder::practiceRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("practiceRunStatus").build()).build();

    private static final SdkField<String> ZONAL_AUTOSHIFT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("zonalAutoshiftStatus").getter(getter(ManagedResourceSummary::zonalAutoshiftStatusAsString))
            .setter(setter(Builder::zonalAutoshiftStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalAutoshiftStatus").build())
            .build();

    private static final SdkField<List<ZonalShiftInResource>> ZONAL_SHIFTS_FIELD = SdkField
            .<List<ZonalShiftInResource>> builder(MarshallingType.LIST)
            .memberName("zonalShifts")
            .getter(getter(ManagedResourceSummary::zonalShifts))
            .setter(setter(Builder::zonalShifts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShifts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ZonalShiftInResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ZonalShiftInResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLIED_WEIGHTS_FIELD,
            ARN_FIELD, AUTOSHIFTS_FIELD, AVAILABILITY_ZONES_FIELD, NAME_FIELD, PRACTICE_RUN_STATUS_FIELD,
            ZONAL_AUTOSHIFT_STATUS_FIELD, ZONAL_SHIFTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Float> appliedWeights;

    private final String arn;

    private final List<AutoshiftInResource> autoshifts;

    private final List<String> availabilityZones;

    private final String name;

    private final String practiceRunStatus;

    private final String zonalAutoshiftStatus;

    private final List<ZonalShiftInResource> zonalShifts;

    private ManagedResourceSummary(BuilderImpl builder) {
        this.appliedWeights = builder.appliedWeights;
        this.arn = builder.arn;
        this.autoshifts = builder.autoshifts;
        this.availabilityZones = builder.availabilityZones;
        this.name = builder.name;
        this.practiceRunStatus = builder.practiceRunStatus;
        this.zonalAutoshiftStatus = builder.zonalAutoshiftStatus;
        this.zonalShifts = builder.zonalShifts;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppliedWeights property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppliedWeights() {
        return appliedWeights != null && !(appliedWeights instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of key-value pairs that indicate whether resources are active in Availability Zones or not. The key
     * name is the Availability Zone where the resource is deployed. The value is 1 or 0.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppliedWeights} method.
     * </p>
     * 
     * @return A collection of key-value pairs that indicate whether resources are active in Availability Zones or not.
     *         The key name is the Availability Zone where the resource is deployed. The value is 1 or 0.
     */
    public final Map<String, Float> appliedWeights() {
        return appliedWeights;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the managed resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the managed resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Autoshifts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAutoshifts() {
        return autoshifts != null && !(autoshifts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the autoshifts that have been completed for a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoshifts} method.
     * </p>
     * 
     * @return An array of the autoshifts that have been completed for a resource.
     */
    public final List<AutoshiftInResource> autoshifts() {
        return autoshifts;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones that a resource is deployed in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return The Availability Zones that a resource is deployed in.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The name of the managed resource.
     * </p>
     * 
     * @return The name of the managed resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * This status tracks whether a practice run configuration exists for a resource. When you configure a practice run
     * for a resource so that a practice run configuration exists, Route 53 ARC sets this value to <code>ENABLED</code>.
     * If a you have not configured a practice run for the resource, or delete a practice run configuration, Route 53
     * ARC sets the value to <code>DISABLED</code>.
     * </p>
     * <p>
     * Route 53 ARC updates this status; you can't set a practice run status to <code>ENABLED</code> or
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #practiceRunStatus}
     * will return {@link ZonalAutoshiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #practiceRunStatusAsString}.
     * </p>
     * 
     * @return This status tracks whether a practice run configuration exists for a resource. When you configure a
     *         practice run for a resource so that a practice run configuration exists, Route 53 ARC sets this value to
     *         <code>ENABLED</code>. If a you have not configured a practice run for the resource, or delete a practice
     *         run configuration, Route 53 ARC sets the value to <code>DISABLED</code>.</p>
     *         <p>
     *         Route 53 ARC updates this status; you can't set a practice run status to <code>ENABLED</code> or
     *         <code>DISABLED</code>.
     * @see ZonalAutoshiftStatus
     */
    public final ZonalAutoshiftStatus practiceRunStatus() {
        return ZonalAutoshiftStatus.fromValue(practiceRunStatus);
    }

    /**
     * <p>
     * This status tracks whether a practice run configuration exists for a resource. When you configure a practice run
     * for a resource so that a practice run configuration exists, Route 53 ARC sets this value to <code>ENABLED</code>.
     * If a you have not configured a practice run for the resource, or delete a practice run configuration, Route 53
     * ARC sets the value to <code>DISABLED</code>.
     * </p>
     * <p>
     * Route 53 ARC updates this status; you can't set a practice run status to <code>ENABLED</code> or
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #practiceRunStatus}
     * will return {@link ZonalAutoshiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #practiceRunStatusAsString}.
     * </p>
     * 
     * @return This status tracks whether a practice run configuration exists for a resource. When you configure a
     *         practice run for a resource so that a practice run configuration exists, Route 53 ARC sets this value to
     *         <code>ENABLED</code>. If a you have not configured a practice run for the resource, or delete a practice
     *         run configuration, Route 53 ARC sets the value to <code>DISABLED</code>.</p>
     *         <p>
     *         Route 53 ARC updates this status; you can't set a practice run status to <code>ENABLED</code> or
     *         <code>DISABLED</code>.
     * @see ZonalAutoshiftStatus
     */
    public final String practiceRunStatusAsString() {
        return practiceRunStatus;
    }

    /**
     * <p>
     * The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set the value
     * of the status to <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #zonalAutoshiftStatus} will return {@link ZonalAutoshiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #zonalAutoshiftStatusAsString}.
     * </p>
     * 
     * @return The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set
     *         the value of the status to <code>ENABLED</code> or <code>DISABLED</code>.
     * @see ZonalAutoshiftStatus
     */
    public final ZonalAutoshiftStatus zonalAutoshiftStatus() {
        return ZonalAutoshiftStatus.fromValue(zonalAutoshiftStatus);
    }

    /**
     * <p>
     * The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set the value
     * of the status to <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #zonalAutoshiftStatus} will return {@link ZonalAutoshiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #zonalAutoshiftStatusAsString}.
     * </p>
     * 
     * @return The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set
     *         the value of the status to <code>ENABLED</code> or <code>DISABLED</code>.
     * @see ZonalAutoshiftStatus
     */
    public final String zonalAutoshiftStatusAsString() {
        return zonalAutoshiftStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the ZonalShifts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasZonalShifts() {
        return zonalShifts != null && !(zonalShifts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the zonal shifts for a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasZonalShifts} method.
     * </p>
     * 
     * @return An array of the zonal shifts for a resource.
     */
    public final List<ZonalShiftInResource> zonalShifts() {
        return zonalShifts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAppliedWeights() ? appliedWeights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoshifts() ? autoshifts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(practiceRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(zonalAutoshiftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasZonalShifts() ? zonalShifts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedResourceSummary)) {
            return false;
        }
        ManagedResourceSummary other = (ManagedResourceSummary) obj;
        return hasAppliedWeights() == other.hasAppliedWeights() && Objects.equals(appliedWeights(), other.appliedWeights())
                && Objects.equals(arn(), other.arn()) && hasAutoshifts() == other.hasAutoshifts()
                && Objects.equals(autoshifts(), other.autoshifts()) && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones()) && Objects.equals(name(), other.name())
                && Objects.equals(practiceRunStatusAsString(), other.practiceRunStatusAsString())
                && Objects.equals(zonalAutoshiftStatusAsString(), other.zonalAutoshiftStatusAsString())
                && hasZonalShifts() == other.hasZonalShifts() && Objects.equals(zonalShifts(), other.zonalShifts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedResourceSummary").add("AppliedWeights", hasAppliedWeights() ? appliedWeights() : null)
                .add("Arn", arn()).add("Autoshifts", hasAutoshifts() ? autoshifts() : null)
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null).add("Name", name())
                .add("PracticeRunStatus", practiceRunStatusAsString())
                .add("ZonalAutoshiftStatus", zonalAutoshiftStatusAsString())
                .add("ZonalShifts", hasZonalShifts() ? zonalShifts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appliedWeights":
            return Optional.ofNullable(clazz.cast(appliedWeights()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "autoshifts":
            return Optional.ofNullable(clazz.cast(autoshifts()));
        case "availabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "practiceRunStatus":
            return Optional.ofNullable(clazz.cast(practiceRunStatusAsString()));
        case "zonalAutoshiftStatus":
            return Optional.ofNullable(clazz.cast(zonalAutoshiftStatusAsString()));
        case "zonalShifts":
            return Optional.ofNullable(clazz.cast(zonalShifts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedResourceSummary, T> g) {
        return obj -> g.apply((ManagedResourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedResourceSummary> {
        /**
         * <p>
         * A collection of key-value pairs that indicate whether resources are active in Availability Zones or not. The
         * key name is the Availability Zone where the resource is deployed. The value is 1 or 0.
         * </p>
         * 
         * @param appliedWeights
         *        A collection of key-value pairs that indicate whether resources are active in Availability Zones or
         *        not. The key name is the Availability Zone where the resource is deployed. The value is 1 or 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedWeights(Map<String, Float> appliedWeights);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the managed resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the managed resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An array of the autoshifts that have been completed for a resource.
         * </p>
         * 
         * @param autoshifts
         *        An array of the autoshifts that have been completed for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoshifts(Collection<AutoshiftInResource> autoshifts);

        /**
         * <p>
         * An array of the autoshifts that have been completed for a resource.
         * </p>
         * 
         * @param autoshifts
         *        An array of the autoshifts that have been completed for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoshifts(AutoshiftInResource... autoshifts);

        /**
         * <p>
         * An array of the autoshifts that have been completed for a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arczonalshift.model.AutoshiftInResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arczonalshift.model.AutoshiftInResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arczonalshift.model.AutoshiftInResource.Builder#build()} is called
         * immediately and its result is passed to {@link #autoshifts(List<AutoshiftInResource>)}.
         * 
         * @param autoshifts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arczonalshift.model.AutoshiftInResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoshifts(java.util.Collection<AutoshiftInResource>)
         */
        Builder autoshifts(Consumer<AutoshiftInResource.Builder>... autoshifts);

        /**
         * <p>
         * The Availability Zones that a resource is deployed in.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones that a resource is deployed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zones that a resource is deployed in.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones that a resource is deployed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The name of the managed resource.
         * </p>
         * 
         * @param name
         *        The name of the managed resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * This status tracks whether a practice run configuration exists for a resource. When you configure a practice
         * run for a resource so that a practice run configuration exists, Route 53 ARC sets this value to
         * <code>ENABLED</code>. If a you have not configured a practice run for the resource, or delete a practice run
         * configuration, Route 53 ARC sets the value to <code>DISABLED</code>.
         * </p>
         * <p>
         * Route 53 ARC updates this status; you can't set a practice run status to <code>ENABLED</code> or
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param practiceRunStatus
         *        This status tracks whether a practice run configuration exists for a resource. When you configure a
         *        practice run for a resource so that a practice run configuration exists, Route 53 ARC sets this value
         *        to <code>ENABLED</code>. If a you have not configured a practice run for the resource, or delete a
         *        practice run configuration, Route 53 ARC sets the value to <code>DISABLED</code>.</p>
         *        <p>
         *        Route 53 ARC updates this status; you can't set a practice run status to <code>ENABLED</code> or
         *        <code>DISABLED</code>.
         * @see ZonalAutoshiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalAutoshiftStatus
         */
        Builder practiceRunStatus(String practiceRunStatus);

        /**
         * <p>
         * This status tracks whether a practice run configuration exists for a resource. When you configure a practice
         * run for a resource so that a practice run configuration exists, Route 53 ARC sets this value to
         * <code>ENABLED</code>. If a you have not configured a practice run for the resource, or delete a practice run
         * configuration, Route 53 ARC sets the value to <code>DISABLED</code>.
         * </p>
         * <p>
         * Route 53 ARC updates this status; you can't set a practice run status to <code>ENABLED</code> or
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param practiceRunStatus
         *        This status tracks whether a practice run configuration exists for a resource. When you configure a
         *        practice run for a resource so that a practice run configuration exists, Route 53 ARC sets this value
         *        to <code>ENABLED</code>. If a you have not configured a practice run for the resource, or delete a
         *        practice run configuration, Route 53 ARC sets the value to <code>DISABLED</code>.</p>
         *        <p>
         *        Route 53 ARC updates this status; you can't set a practice run status to <code>ENABLED</code> or
         *        <code>DISABLED</code>.
         * @see ZonalAutoshiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalAutoshiftStatus
         */
        Builder practiceRunStatus(ZonalAutoshiftStatus practiceRunStatus);

        /**
         * <p>
         * The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set the
         * value of the status to <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * 
         * @param zonalAutoshiftStatus
         *        The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set
         *        the value of the status to <code>ENABLED</code> or <code>DISABLED</code>.
         * @see ZonalAutoshiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalAutoshiftStatus
         */
        Builder zonalAutoshiftStatus(String zonalAutoshiftStatus);

        /**
         * <p>
         * The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set the
         * value of the status to <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * 
         * @param zonalAutoshiftStatus
         *        The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set
         *        the value of the status to <code>ENABLED</code> or <code>DISABLED</code>.
         * @see ZonalAutoshiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalAutoshiftStatus
         */
        Builder zonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus);

        /**
         * <p>
         * An array of the zonal shifts for a resource.
         * </p>
         * 
         * @param zonalShifts
         *        An array of the zonal shifts for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalShifts(Collection<ZonalShiftInResource> zonalShifts);

        /**
         * <p>
         * An array of the zonal shifts for a resource.
         * </p>
         * 
         * @param zonalShifts
         *        An array of the zonal shifts for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalShifts(ZonalShiftInResource... zonalShifts);

        /**
         * <p>
         * An array of the zonal shifts for a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource.Builder#build()} is called
         * immediately and its result is passed to {@link #zonalShifts(List<ZonalShiftInResource>)}.
         * 
         * @param zonalShifts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zonalShifts(java.util.Collection<ZonalShiftInResource>)
         */
        Builder zonalShifts(Consumer<ZonalShiftInResource.Builder>... zonalShifts);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Float> appliedWeights = DefaultSdkAutoConstructMap.getInstance();

        private String arn;

        private List<AutoshiftInResource> autoshifts = DefaultSdkAutoConstructList.getInstance();

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String practiceRunStatus;

        private String zonalAutoshiftStatus;

        private List<ZonalShiftInResource> zonalShifts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedResourceSummary model) {
            appliedWeights(model.appliedWeights);
            arn(model.arn);
            autoshifts(model.autoshifts);
            availabilityZones(model.availabilityZones);
            name(model.name);
            practiceRunStatus(model.practiceRunStatus);
            zonalAutoshiftStatus(model.zonalAutoshiftStatus);
            zonalShifts(model.zonalShifts);
        }

        public final Map<String, Float> getAppliedWeights() {
            if (appliedWeights instanceof SdkAutoConstructMap) {
                return null;
            }
            return appliedWeights;
        }

        public final void setAppliedWeights(Map<String, Float> appliedWeights) {
            this.appliedWeights = AppliedWeightsCopier.copy(appliedWeights);
        }

        @Override
        public final Builder appliedWeights(Map<String, Float> appliedWeights) {
            this.appliedWeights = AppliedWeightsCopier.copy(appliedWeights);
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<AutoshiftInResource.Builder> getAutoshifts() {
            List<AutoshiftInResource.Builder> result = AutoshiftsInResourceCopier.copyToBuilder(this.autoshifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoshifts(Collection<AutoshiftInResource.BuilderImpl> autoshifts) {
            this.autoshifts = AutoshiftsInResourceCopier.copyFromBuilder(autoshifts);
        }

        @Override
        public final Builder autoshifts(Collection<AutoshiftInResource> autoshifts) {
            this.autoshifts = AutoshiftsInResourceCopier.copy(autoshifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoshifts(AutoshiftInResource... autoshifts) {
            autoshifts(Arrays.asList(autoshifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoshifts(Consumer<AutoshiftInResource.Builder>... autoshifts) {
            autoshifts(Stream.of(autoshifts).map(c -> AutoshiftInResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPracticeRunStatus() {
            return practiceRunStatus;
        }

        public final void setPracticeRunStatus(String practiceRunStatus) {
            this.practiceRunStatus = practiceRunStatus;
        }

        @Override
        public final Builder practiceRunStatus(String practiceRunStatus) {
            this.practiceRunStatus = practiceRunStatus;
            return this;
        }

        @Override
        public final Builder practiceRunStatus(ZonalAutoshiftStatus practiceRunStatus) {
            this.practiceRunStatus(practiceRunStatus == null ? null : practiceRunStatus.toString());
            return this;
        }

        public final String getZonalAutoshiftStatus() {
            return zonalAutoshiftStatus;
        }

        public final void setZonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
        }

        @Override
        public final Builder zonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
            return this;
        }

        @Override
        public final Builder zonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus(zonalAutoshiftStatus == null ? null : zonalAutoshiftStatus.toString());
            return this;
        }

        public final List<ZonalShiftInResource.Builder> getZonalShifts() {
            List<ZonalShiftInResource.Builder> result = ZonalShiftsInResourceCopier.copyToBuilder(this.zonalShifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setZonalShifts(Collection<ZonalShiftInResource.BuilderImpl> zonalShifts) {
            this.zonalShifts = ZonalShiftsInResourceCopier.copyFromBuilder(zonalShifts);
        }

        @Override
        public final Builder zonalShifts(Collection<ZonalShiftInResource> zonalShifts) {
            this.zonalShifts = ZonalShiftsInResourceCopier.copy(zonalShifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zonalShifts(ZonalShiftInResource... zonalShifts) {
            zonalShifts(Arrays.asList(zonalShifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zonalShifts(Consumer<ZonalShiftInResource.Builder>... zonalShifts) {
            zonalShifts(Stream.of(zonalShifts).map(c -> ZonalShiftInResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ManagedResourceSummary build() {
            return new ManagedResourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
