/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePracticeRunConfigurationRequest extends ArcZonalShiftRequest implements
        ToCopyableBuilder<CreatePracticeRunConfigurationRequest.Builder, CreatePracticeRunConfigurationRequest> {
    private static final SdkField<List<String>> BLOCKED_DATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedDates")
            .getter(getter(CreatePracticeRunConfigurationRequest::blockedDates))
            .setter(setter(Builder::blockedDates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedDates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BLOCKED_WINDOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedWindows")
            .getter(getter(CreatePracticeRunConfigurationRequest::blockedWindows))
            .setter(setter(Builder::blockedWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ControlCondition>> BLOCKING_ALARMS_FIELD = SdkField
            .<List<ControlCondition>> builder(MarshallingType.LIST)
            .memberName("blockingAlarms")
            .getter(getter(CreatePracticeRunConfigurationRequest::blockingAlarms))
            .setter(setter(Builder::blockingAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockingAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ControlCondition>> OUTCOME_ALARMS_FIELD = SdkField
            .<List<ControlCondition>> builder(MarshallingType.LIST)
            .memberName("outcomeAlarms")
            .getter(getter(CreatePracticeRunConfigurationRequest::outcomeAlarms))
            .setter(setter(Builder::outcomeAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomeAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(CreatePracticeRunConfigurationRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_DATES_FIELD,
            BLOCKED_WINDOWS_FIELD, BLOCKING_ALARMS_FIELD, OUTCOME_ALARMS_FIELD, RESOURCE_IDENTIFIER_FIELD));

    private final List<String> blockedDates;

    private final List<String> blockedWindows;

    private final List<ControlCondition> blockingAlarms;

    private final List<ControlCondition> outcomeAlarms;

    private final String resourceIdentifier;

    private CreatePracticeRunConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.blockedDates = builder.blockedDates;
        this.blockedWindows = builder.blockedWindows;
        this.blockingAlarms = builder.blockingAlarms;
        this.outcomeAlarms = builder.outcomeAlarms;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedDates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockedDates() {
        return blockedDates != null && !(blockedDates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optionally, you can block Route 53 ARC from starting practice runs for a resource on specific calendar dates.
     * </p>
     * <p>
     * The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for
     * practice runs are in UTC. Separate multiple blocked dates with spaces.
     * </p>
     * <p>
     * For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want practice
     * runs to shift traffic away at that time, you could set a blocked date for <code>2024-05-01</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedDates} method.
     * </p>
     * 
     * @return Optionally, you can block Route 53 ARC from starting practice runs for a resource on specific calendar
     *         dates.</p>
     *         <p>
     *         The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times
     *         for practice runs are in UTC. Separate multiple blocked dates with spaces.
     *         </p>
     *         <p>
     *         For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want
     *         practice runs to shift traffic away at that time, you could set a blocked date for
     *         <code>2024-05-01</code>.
     */
    public final List<String> blockedDates() {
        return blockedDates;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedWindows property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockedWindows() {
        return blockedWindows != null && !(blockedWindows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optionally, you can block Route 53 ARC from starting practice runs for specific windows of days and times.
     * </p>
     * <p>
     * The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and
     * times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for
     * daylight saving time differences. Separate multiple blocked windows with spaces.
     * </p>
     * <p>
     * For example, say you run business report summaries three days a week. For this scenario, you might set the
     * following recurring days and times as blocked windows, for example:
     * <code>MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedWindows} method.
     * </p>
     * 
     * @return Optionally, you can block Route 53 ARC from starting practice runs for specific windows of days and
     *         times. </p>
     *         <p>
     *         The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates
     *         and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be
     *         required for daylight saving time differences. Separate multiple blocked windows with spaces.
     *         </p>
     *         <p>
     *         For example, say you run business report summaries three days a week. For this scenario, you might set
     *         the following recurring days and times as blocked windows, for example:
     *         <code>MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30</code>.
     */
    public final List<String> blockedWindows() {
        return blockedWindows;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockingAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockingAlarms() {
        return blockingAlarms != null && !(blockingAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An Amazon CloudWatch alarm that you can specify for zonal autoshift practice runs. This alarm blocks Route 53 ARC
     * from starting practice run zonal shifts, and ends a practice run that's in progress, when the alarm is in an
     * <code>ALARM</code> state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockingAlarms} method.
     * </p>
     * 
     * @return An Amazon CloudWatch alarm that you can specify for zonal autoshift practice runs. This alarm blocks
     *         Route 53 ARC from starting practice run zonal shifts, and ends a practice run that's in progress, when
     *         the alarm is in an <code>ALARM</code> state.
     */
    public final List<ControlCondition> blockingAlarms() {
        return blockingAlarms;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutcomeAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutcomeAlarms() {
        return outcomeAlarms != null && !(outcomeAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <i>outcome alarm</i> for practice runs is a required Amazon CloudWatch alarm that you specify that ends a
     * practice run when the alarm is in an <code>ALARM</code> state.
     * </p>
     * <p>
     * Configure the alarm to monitor the health of your application when traffic is shifted away from an Availability
     * Zone during each weekly practice run. You should configure the alarm to go into an <code>ALARM</code> state if
     * your application is impacted by the zonal shift, and you want to stop the zonal shift, to let traffic for the
     * resource return to the Availability Zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutcomeAlarms} method.
     * </p>
     * 
     * @return The <i>outcome alarm</i> for practice runs is a required Amazon CloudWatch alarm that you specify that
     *         ends a practice run when the alarm is in an <code>ALARM</code> state.</p>
     *         <p>
     *         Configure the alarm to monitor the health of your application when traffic is shifted away from an
     *         Availability Zone during each weekly practice run. You should configure the alarm to go into an
     *         <code>ALARM</code> state if your application is impacted by the zonal shift, and you want to stop the
     *         zonal shift, to let traffic for the resource return to the Availability Zone.
     */
    public final List<ControlCondition> outcomeAlarms() {
        return outcomeAlarms;
    }

    /**
     * <p>
     * The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal shift. The
     * identifier is the Amazon Resource Name (ARN) for the resource.
     * </p>
     * <p>
     * At this time, supported resources are Network Load Balancers and Application Load Balancers with cross-zone load
     * balancing turned off.
     * </p>
     * 
     * @return The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal
     *         shift. The identifier is the Amazon Resource Name (ARN) for the resource.</p>
     *         <p>
     *         At this time, supported resources are Network Load Balancers and Application Load Balancers with
     *         cross-zone load balancing turned off.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedDates() ? blockedDates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedWindows() ? blockedWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockingAlarms() ? blockingAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutcomeAlarms() ? outcomeAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePracticeRunConfigurationRequest)) {
            return false;
        }
        CreatePracticeRunConfigurationRequest other = (CreatePracticeRunConfigurationRequest) obj;
        return hasBlockedDates() == other.hasBlockedDates() && Objects.equals(blockedDates(), other.blockedDates())
                && hasBlockedWindows() == other.hasBlockedWindows() && Objects.equals(blockedWindows(), other.blockedWindows())
                && hasBlockingAlarms() == other.hasBlockingAlarms() && Objects.equals(blockingAlarms(), other.blockingAlarms())
                && hasOutcomeAlarms() == other.hasOutcomeAlarms() && Objects.equals(outcomeAlarms(), other.outcomeAlarms())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePracticeRunConfigurationRequest")
                .add("BlockedDates", hasBlockedDates() ? blockedDates() : null)
                .add("BlockedWindows", hasBlockedWindows() ? blockedWindows() : null)
                .add("BlockingAlarms", hasBlockingAlarms() ? blockingAlarms() : null)
                .add("OutcomeAlarms", hasOutcomeAlarms() ? outcomeAlarms() : null)
                .add("ResourceIdentifier", resourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blockedDates":
            return Optional.ofNullable(clazz.cast(blockedDates()));
        case "blockedWindows":
            return Optional.ofNullable(clazz.cast(blockedWindows()));
        case "blockingAlarms":
            return Optional.ofNullable(clazz.cast(blockingAlarms()));
        case "outcomeAlarms":
            return Optional.ofNullable(clazz.cast(outcomeAlarms()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePracticeRunConfigurationRequest, T> g) {
        return obj -> g.apply((CreatePracticeRunConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ArcZonalShiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePracticeRunConfigurationRequest> {
        /**
         * <p>
         * Optionally, you can block Route 53 ARC from starting practice runs for a resource on specific calendar dates.
         * </p>
         * <p>
         * The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for
         * practice runs are in UTC. Separate multiple blocked dates with spaces.
         * </p>
         * <p>
         * For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want
         * practice runs to shift traffic away at that time, you could set a blocked date for <code>2024-05-01</code>.
         * </p>
         * 
         * @param blockedDates
         *        Optionally, you can block Route 53 ARC from starting practice runs for a resource on specific calendar
         *        dates.</p>
         *        <p>
         *        The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and
         *        times for practice runs are in UTC. Separate multiple blocked dates with spaces.
         *        </p>
         *        <p>
         *        For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want
         *        practice runs to shift traffic away at that time, you could set a blocked date for
         *        <code>2024-05-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedDates(Collection<String> blockedDates);

        /**
         * <p>
         * Optionally, you can block Route 53 ARC from starting practice runs for a resource on specific calendar dates.
         * </p>
         * <p>
         * The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for
         * practice runs are in UTC. Separate multiple blocked dates with spaces.
         * </p>
         * <p>
         * For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want
         * practice runs to shift traffic away at that time, you could set a blocked date for <code>2024-05-01</code>.
         * </p>
         * 
         * @param blockedDates
         *        Optionally, you can block Route 53 ARC from starting practice runs for a resource on specific calendar
         *        dates.</p>
         *        <p>
         *        The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and
         *        times for practice runs are in UTC. Separate multiple blocked dates with spaces.
         *        </p>
         *        <p>
         *        For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want
         *        practice runs to shift traffic away at that time, you could set a blocked date for
         *        <code>2024-05-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedDates(String... blockedDates);

        /**
         * <p>
         * Optionally, you can block Route 53 ARC from starting practice runs for specific windows of days and times.
         * </p>
         * <p>
         * The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and
         * times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for
         * daylight saving time differences. Separate multiple blocked windows with spaces.
         * </p>
         * <p>
         * For example, say you run business report summaries three days a week. For this scenario, you might set the
         * following recurring days and times as blocked windows, for example:
         * <code>MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30</code>.
         * </p>
         * 
         * @param blockedWindows
         *        Optionally, you can block Route 53 ARC from starting practice runs for specific windows of days and
         *        times. </p>
         *        <p>
         *        The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that
         *        dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might
         *        be required for daylight saving time differences. Separate multiple blocked windows with spaces.
         *        </p>
         *        <p>
         *        For example, say you run business report summaries three days a week. For this scenario, you might set
         *        the following recurring days and times as blocked windows, for example:
         *        <code>MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedWindows(Collection<String> blockedWindows);

        /**
         * <p>
         * Optionally, you can block Route 53 ARC from starting practice runs for specific windows of days and times.
         * </p>
         * <p>
         * The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and
         * times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for
         * daylight saving time differences. Separate multiple blocked windows with spaces.
         * </p>
         * <p>
         * For example, say you run business report summaries three days a week. For this scenario, you might set the
         * following recurring days and times as blocked windows, for example:
         * <code>MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30</code>.
         * </p>
         * 
         * @param blockedWindows
         *        Optionally, you can block Route 53 ARC from starting practice runs for specific windows of days and
         *        times. </p>
         *        <p>
         *        The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that
         *        dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might
         *        be required for daylight saving time differences. Separate multiple blocked windows with spaces.
         *        </p>
         *        <p>
         *        For example, say you run business report summaries three days a week. For this scenario, you might set
         *        the following recurring days and times as blocked windows, for example:
         *        <code>MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedWindows(String... blockedWindows);

        /**
         * <p>
         * An Amazon CloudWatch alarm that you can specify for zonal autoshift practice runs. This alarm blocks Route 53
         * ARC from starting practice run zonal shifts, and ends a practice run that's in progress, when the alarm is in
         * an <code>ALARM</code> state.
         * </p>
         * 
         * @param blockingAlarms
         *        An Amazon CloudWatch alarm that you can specify for zonal autoshift practice runs. This alarm blocks
         *        Route 53 ARC from starting practice run zonal shifts, and ends a practice run that's in progress, when
         *        the alarm is in an <code>ALARM</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockingAlarms(Collection<ControlCondition> blockingAlarms);

        /**
         * <p>
         * An Amazon CloudWatch alarm that you can specify for zonal autoshift practice runs. This alarm blocks Route 53
         * ARC from starting practice run zonal shifts, and ends a practice run that's in progress, when the alarm is in
         * an <code>ALARM</code> state.
         * </p>
         * 
         * @param blockingAlarms
         *        An Amazon CloudWatch alarm that you can specify for zonal autoshift practice runs. This alarm blocks
         *        Route 53 ARC from starting practice run zonal shifts, and ends a practice run that's in progress, when
         *        the alarm is in an <code>ALARM</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockingAlarms(ControlCondition... blockingAlarms);

        /**
         * <p>
         * An Amazon CloudWatch alarm that you can specify for zonal autoshift practice runs. This alarm blocks Route 53
         * ARC from starting practice run zonal shifts, and ends a practice run that's in progress, when the alarm is in
         * an <code>ALARM</code> state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #blockingAlarms(List<ControlCondition>)}.
         * 
         * @param blockingAlarms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockingAlarms(java.util.Collection<ControlCondition>)
         */
        Builder blockingAlarms(Consumer<ControlCondition.Builder>... blockingAlarms);

        /**
         * <p>
         * The <i>outcome alarm</i> for practice runs is a required Amazon CloudWatch alarm that you specify that ends a
         * practice run when the alarm is in an <code>ALARM</code> state.
         * </p>
         * <p>
         * Configure the alarm to monitor the health of your application when traffic is shifted away from an
         * Availability Zone during each weekly practice run. You should configure the alarm to go into an
         * <code>ALARM</code> state if your application is impacted by the zonal shift, and you want to stop the zonal
         * shift, to let traffic for the resource return to the Availability Zone.
         * </p>
         * 
         * @param outcomeAlarms
         *        The <i>outcome alarm</i> for practice runs is a required Amazon CloudWatch alarm that you specify that
         *        ends a practice run when the alarm is in an <code>ALARM</code> state.</p>
         *        <p>
         *        Configure the alarm to monitor the health of your application when traffic is shifted away from an
         *        Availability Zone during each weekly practice run. You should configure the alarm to go into an
         *        <code>ALARM</code> state if your application is impacted by the zonal shift, and you want to stop the
         *        zonal shift, to let traffic for the resource return to the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomeAlarms(Collection<ControlCondition> outcomeAlarms);

        /**
         * <p>
         * The <i>outcome alarm</i> for practice runs is a required Amazon CloudWatch alarm that you specify that ends a
         * practice run when the alarm is in an <code>ALARM</code> state.
         * </p>
         * <p>
         * Configure the alarm to monitor the health of your application when traffic is shifted away from an
         * Availability Zone during each weekly practice run. You should configure the alarm to go into an
         * <code>ALARM</code> state if your application is impacted by the zonal shift, and you want to stop the zonal
         * shift, to let traffic for the resource return to the Availability Zone.
         * </p>
         * 
         * @param outcomeAlarms
         *        The <i>outcome alarm</i> for practice runs is a required Amazon CloudWatch alarm that you specify that
         *        ends a practice run when the alarm is in an <code>ALARM</code> state.</p>
         *        <p>
         *        Configure the alarm to monitor the health of your application when traffic is shifted away from an
         *        Availability Zone during each weekly practice run. You should configure the alarm to go into an
         *        <code>ALARM</code> state if your application is impacted by the zonal shift, and you want to stop the
         *        zonal shift, to let traffic for the resource return to the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomeAlarms(ControlCondition... outcomeAlarms);

        /**
         * <p>
         * The <i>outcome alarm</i> for practice runs is a required Amazon CloudWatch alarm that you specify that ends a
         * practice run when the alarm is in an <code>ALARM</code> state.
         * </p>
         * <p>
         * Configure the alarm to monitor the health of your application when traffic is shifted away from an
         * Availability Zone during each weekly practice run. You should configure the alarm to go into an
         * <code>ALARM</code> state if your application is impacted by the zonal shift, and you want to stop the zonal
         * shift, to let traffic for the resource return to the Availability Zone.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #outcomeAlarms(List<ControlCondition>)}.
         * 
         * @param outcomeAlarms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outcomeAlarms(java.util.Collection<ControlCondition>)
         */
        Builder outcomeAlarms(Consumer<ControlCondition.Builder>... outcomeAlarms);

        /**
         * <p>
         * The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal shift.
         * The identifier is the Amazon Resource Name (ARN) for the resource.
         * </p>
         * <p>
         * At this time, supported resources are Network Load Balancers and Application Load Balancers with cross-zone
         * load balancing turned off.
         * </p>
         * 
         * @param resourceIdentifier
         *        The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal
         *        shift. The identifier is the Amazon Resource Name (ARN) for the resource.</p>
         *        <p>
         *        At this time, supported resources are Network Load Balancers and Application Load Balancers with
         *        cross-zone load balancing turned off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcZonalShiftRequest.BuilderImpl implements Builder {
        private List<String> blockedDates = DefaultSdkAutoConstructList.getInstance();

        private List<String> blockedWindows = DefaultSdkAutoConstructList.getInstance();

        private List<ControlCondition> blockingAlarms = DefaultSdkAutoConstructList.getInstance();

        private List<ControlCondition> outcomeAlarms = DefaultSdkAutoConstructList.getInstance();

        private String resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePracticeRunConfigurationRequest model) {
            super(model);
            blockedDates(model.blockedDates);
            blockedWindows(model.blockedWindows);
            blockingAlarms(model.blockingAlarms);
            outcomeAlarms(model.outcomeAlarms);
            resourceIdentifier(model.resourceIdentifier);
        }

        public final Collection<String> getBlockedDates() {
            if (blockedDates instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedDates;
        }

        public final void setBlockedDates(Collection<String> blockedDates) {
            this.blockedDates = BlockedDatesCopier.copy(blockedDates);
        }

        @Override
        public final Builder blockedDates(Collection<String> blockedDates) {
            this.blockedDates = BlockedDatesCopier.copy(blockedDates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedDates(String... blockedDates) {
            blockedDates(Arrays.asList(blockedDates));
            return this;
        }

        public final Collection<String> getBlockedWindows() {
            if (blockedWindows instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedWindows;
        }

        public final void setBlockedWindows(Collection<String> blockedWindows) {
            this.blockedWindows = BlockedWindowsCopier.copy(blockedWindows);
        }

        @Override
        public final Builder blockedWindows(Collection<String> blockedWindows) {
            this.blockedWindows = BlockedWindowsCopier.copy(blockedWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedWindows(String... blockedWindows) {
            blockedWindows(Arrays.asList(blockedWindows));
            return this;
        }

        public final List<ControlCondition.Builder> getBlockingAlarms() {
            List<ControlCondition.Builder> result = ControlConditionsCopier.copyToBuilder(this.blockingAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockingAlarms(Collection<ControlCondition.BuilderImpl> blockingAlarms) {
            this.blockingAlarms = ControlConditionsCopier.copyFromBuilder(blockingAlarms);
        }

        @Override
        public final Builder blockingAlarms(Collection<ControlCondition> blockingAlarms) {
            this.blockingAlarms = ControlConditionsCopier.copy(blockingAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingAlarms(ControlCondition... blockingAlarms) {
            blockingAlarms(Arrays.asList(blockingAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingAlarms(Consumer<ControlCondition.Builder>... blockingAlarms) {
            blockingAlarms(Stream.of(blockingAlarms).map(c -> ControlCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ControlCondition.Builder> getOutcomeAlarms() {
            List<ControlCondition.Builder> result = ControlConditionsCopier.copyToBuilder(this.outcomeAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutcomeAlarms(Collection<ControlCondition.BuilderImpl> outcomeAlarms) {
            this.outcomeAlarms = ControlConditionsCopier.copyFromBuilder(outcomeAlarms);
        }

        @Override
        public final Builder outcomeAlarms(Collection<ControlCondition> outcomeAlarms) {
            this.outcomeAlarms = ControlConditionsCopier.copy(outcomeAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomeAlarms(ControlCondition... outcomeAlarms) {
            outcomeAlarms(Arrays.asList(outcomeAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomeAlarms(Consumer<ControlCondition.Builder>... outcomeAlarms) {
            outcomeAlarms(Stream.of(outcomeAlarms).map(c -> ControlCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePracticeRunConfigurationRequest build() {
            return new CreatePracticeRunConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
