/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arczonalshift.model.ArcZonalShiftResponse;
import software.amazon.awssdk.services.arczonalshift.model.PracticeRunConfiguration;
import software.amazon.awssdk.services.arczonalshift.model.ZonalAutoshiftStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePracticeRunConfigurationResponse
extends ArcZonalShiftResponse
implements ToCopyableBuilder<Builder, UpdatePracticeRunConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdatePracticeRunConfigurationResponse.getter(UpdatePracticeRunConfigurationResponse::arn)).setter(UpdatePracticeRunConfigurationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdatePracticeRunConfigurationResponse.getter(UpdatePracticeRunConfigurationResponse::name)).setter(UpdatePracticeRunConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<PracticeRunConfiguration> PRACTICE_RUN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("practiceRunConfiguration").getter(UpdatePracticeRunConfigurationResponse.getter(UpdatePracticeRunConfigurationResponse::practiceRunConfiguration)).setter(UpdatePracticeRunConfigurationResponse.setter(Builder::practiceRunConfiguration)).constructor(PracticeRunConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("practiceRunConfiguration").build()}).build();
    private static final SdkField<String> ZONAL_AUTOSHIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("zonalAutoshiftStatus").getter(UpdatePracticeRunConfigurationResponse.getter(UpdatePracticeRunConfigurationResponse::zonalAutoshiftStatusAsString)).setter(UpdatePracticeRunConfigurationResponse.setter(Builder::zonalAutoshiftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalAutoshiftStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, PRACTICE_RUN_CONFIGURATION_FIELD, ZONAL_AUTOSHIFT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("practiceRunConfiguration", PRACTICE_RUN_CONFIGURATION_FIELD);
            this.put("zonalAutoshiftStatus", ZONAL_AUTOSHIFT_STATUS_FIELD);
        }
    });
    private final String arn;
    private final String name;
    private final PracticeRunConfiguration practiceRunConfiguration;
    private final String zonalAutoshiftStatus;

    private UpdatePracticeRunConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.practiceRunConfiguration = builder.practiceRunConfiguration;
        this.zonalAutoshiftStatus = builder.zonalAutoshiftStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final PracticeRunConfiguration practiceRunConfiguration() {
        return this.practiceRunConfiguration;
    }

    public final ZonalAutoshiftStatus zonalAutoshiftStatus() {
        return ZonalAutoshiftStatus.fromValue(this.zonalAutoshiftStatus);
    }

    public final String zonalAutoshiftStatusAsString() {
        return this.zonalAutoshiftStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.practiceRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalAutoshiftStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePracticeRunConfigurationResponse)) {
            return false;
        }
        UpdatePracticeRunConfigurationResponse other = (UpdatePracticeRunConfigurationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.practiceRunConfiguration(), other.practiceRunConfiguration()) && Objects.equals(this.zonalAutoshiftStatusAsString(), other.zonalAutoshiftStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePracticeRunConfigurationResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("PracticeRunConfiguration", (Object)this.practiceRunConfiguration()).add("ZonalAutoshiftStatus", (Object)this.zonalAutoshiftStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "practiceRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.practiceRunConfiguration()));
            }
            case "zonalAutoshiftStatus": {
                return Optional.ofNullable(clazz.cast(this.zonalAutoshiftStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePracticeRunConfigurationResponse, T> g) {
        return obj -> g.apply((UpdatePracticeRunConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcZonalShiftResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private PracticeRunConfiguration practiceRunConfiguration;
        private String zonalAutoshiftStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePracticeRunConfigurationResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.practiceRunConfiguration(model.practiceRunConfiguration);
            this.zonalAutoshiftStatus(model.zonalAutoshiftStatus);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PracticeRunConfiguration.Builder getPracticeRunConfiguration() {
            return this.practiceRunConfiguration != null ? this.practiceRunConfiguration.toBuilder() : null;
        }

        public final void setPracticeRunConfiguration(PracticeRunConfiguration.BuilderImpl practiceRunConfiguration) {
            this.practiceRunConfiguration = practiceRunConfiguration != null ? practiceRunConfiguration.build() : null;
        }

        @Override
        public final Builder practiceRunConfiguration(PracticeRunConfiguration practiceRunConfiguration) {
            this.practiceRunConfiguration = practiceRunConfiguration;
            return this;
        }

        public final String getZonalAutoshiftStatus() {
            return this.zonalAutoshiftStatus;
        }

        public final void setZonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
        }

        @Override
        public final Builder zonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
            return this;
        }

        @Override
        public final Builder zonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus(zonalAutoshiftStatus == null ? null : zonalAutoshiftStatus.toString());
            return this;
        }

        @Override
        public UpdatePracticeRunConfigurationResponse build() {
            return new UpdatePracticeRunConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ArcZonalShiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePracticeRunConfigurationResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder practiceRunConfiguration(PracticeRunConfiguration var1);

        default public Builder practiceRunConfiguration(Consumer<PracticeRunConfiguration.Builder> practiceRunConfiguration) {
            return this.practiceRunConfiguration((PracticeRunConfiguration)((PracticeRunConfiguration.Builder)PracticeRunConfiguration.builder().applyMutation(practiceRunConfiguration)).build());
        }

        public Builder zonalAutoshiftStatus(String var1);

        public Builder zonalAutoshiftStatus(ZonalAutoshiftStatus var1);
    }
}

