/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftClient;
import software.amazon.awssdk.services.arczonalshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.arczonalshift.model.AutoshiftSummary;
import software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsResponse;

public class ListAutoshiftsIterable
implements SdkIterable<ListAutoshiftsResponse> {
    private final ArcZonalShiftClient client;
    private final ListAutoshiftsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutoshiftsIterable(ArcZonalShiftClient client, ListAutoshiftsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutoshiftsResponseFetcher();
    }

    public Iterator<ListAutoshiftsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutoshiftSummary> items() {
        Function<ListAutoshiftsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutoshiftsResponseFetcher
    implements SyncPageFetcher<ListAutoshiftsResponse> {
        private ListAutoshiftsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutoshiftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutoshiftsResponse nextPage(ListAutoshiftsResponse previousPage) {
            if (previousPage == null) {
                return ListAutoshiftsIterable.this.client.listAutoshifts(ListAutoshiftsIterable.this.firstRequest);
            }
            return ListAutoshiftsIterable.this.client.listAutoshifts((ListAutoshiftsRequest)((Object)ListAutoshiftsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

