/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.arczonalshift.model.AppliedWeightsCopier;
import software.amazon.awssdk.services.arczonalshift.model.ArcZonalShiftResponse;
import software.amazon.awssdk.services.arczonalshift.model.AutoshiftInResource;
import software.amazon.awssdk.services.arczonalshift.model.AutoshiftsInResourceCopier;
import software.amazon.awssdk.services.arczonalshift.model.PracticeRunConfiguration;
import software.amazon.awssdk.services.arczonalshift.model.ZonalAutoshiftStatus;
import software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource;
import software.amazon.awssdk.services.arczonalshift.model.ZonalShiftsInResourceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetManagedResourceResponse
extends ArcZonalShiftResponse
implements ToCopyableBuilder<Builder, GetManagedResourceResponse> {
    private static final SdkField<Map<String, Float>> APPLIED_WEIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("appliedWeights").getter(GetManagedResourceResponse.getter(GetManagedResourceResponse::appliedWeights)).setter(GetManagedResourceResponse.setter(Builder::appliedWeights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedWeights").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.FLOAT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetManagedResourceResponse.getter(GetManagedResourceResponse::arn)).setter(GetManagedResourceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<AutoshiftInResource>> AUTOSHIFTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoshifts").getter(GetManagedResourceResponse.getter(GetManagedResourceResponse::autoshifts)).setter(GetManagedResourceResponse.setter(Builder::autoshifts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoshifts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoshiftInResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetManagedResourceResponse.getter(GetManagedResourceResponse::name)).setter(GetManagedResourceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<PracticeRunConfiguration> PRACTICE_RUN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("practiceRunConfiguration").getter(GetManagedResourceResponse.getter(GetManagedResourceResponse::practiceRunConfiguration)).setter(GetManagedResourceResponse.setter(Builder::practiceRunConfiguration)).constructor(PracticeRunConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("practiceRunConfiguration").build()}).build();
    private static final SdkField<String> ZONAL_AUTOSHIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("zonalAutoshiftStatus").getter(GetManagedResourceResponse.getter(GetManagedResourceResponse::zonalAutoshiftStatusAsString)).setter(GetManagedResourceResponse.setter(Builder::zonalAutoshiftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalAutoshiftStatus").build()}).build();
    private static final SdkField<List<ZonalShiftInResource>> ZONAL_SHIFTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("zonalShifts").getter(GetManagedResourceResponse.getter(GetManagedResourceResponse::zonalShifts)).setter(GetManagedResourceResponse.setter(Builder::zonalShifts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShifts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ZonalShiftInResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLIED_WEIGHTS_FIELD, ARN_FIELD, AUTOSHIFTS_FIELD, NAME_FIELD, PRACTICE_RUN_CONFIGURATION_FIELD, ZONAL_AUTOSHIFT_STATUS_FIELD, ZONAL_SHIFTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetManagedResourceResponse.memberNameToFieldInitializer();
    private final Map<String, Float> appliedWeights;
    private final String arn;
    private final List<AutoshiftInResource> autoshifts;
    private final String name;
    private final PracticeRunConfiguration practiceRunConfiguration;
    private final String zonalAutoshiftStatus;
    private final List<ZonalShiftInResource> zonalShifts;

    private GetManagedResourceResponse(BuilderImpl builder) {
        super(builder);
        this.appliedWeights = builder.appliedWeights;
        this.arn = builder.arn;
        this.autoshifts = builder.autoshifts;
        this.name = builder.name;
        this.practiceRunConfiguration = builder.practiceRunConfiguration;
        this.zonalAutoshiftStatus = builder.zonalAutoshiftStatus;
        this.zonalShifts = builder.zonalShifts;
    }

    public final boolean hasAppliedWeights() {
        return this.appliedWeights != null && !(this.appliedWeights instanceof SdkAutoConstructMap);
    }

    public final Map<String, Float> appliedWeights() {
        return this.appliedWeights;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAutoshifts() {
        return this.autoshifts != null && !(this.autoshifts instanceof SdkAutoConstructList);
    }

    public final List<AutoshiftInResource> autoshifts() {
        return this.autoshifts;
    }

    public final String name() {
        return this.name;
    }

    public final PracticeRunConfiguration practiceRunConfiguration() {
        return this.practiceRunConfiguration;
    }

    public final ZonalAutoshiftStatus zonalAutoshiftStatus() {
        return ZonalAutoshiftStatus.fromValue(this.zonalAutoshiftStatus);
    }

    public final String zonalAutoshiftStatusAsString() {
        return this.zonalAutoshiftStatus;
    }

    public final boolean hasZonalShifts() {
        return this.zonalShifts != null && !(this.zonalShifts instanceof SdkAutoConstructList);
    }

    public final List<ZonalShiftInResource> zonalShifts() {
        return this.zonalShifts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppliedWeights() ? this.appliedWeights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoshifts() ? this.autoshifts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.practiceRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalAutoshiftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasZonalShifts() ? this.zonalShifts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedResourceResponse)) {
            return false;
        }
        GetManagedResourceResponse other = (GetManagedResourceResponse)((Object)obj);
        return this.hasAppliedWeights() == other.hasAppliedWeights() && Objects.equals(this.appliedWeights(), other.appliedWeights()) && Objects.equals(this.arn(), other.arn()) && this.hasAutoshifts() == other.hasAutoshifts() && Objects.equals(this.autoshifts(), other.autoshifts()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.practiceRunConfiguration(), other.practiceRunConfiguration()) && Objects.equals(this.zonalAutoshiftStatusAsString(), other.zonalAutoshiftStatusAsString()) && this.hasZonalShifts() == other.hasZonalShifts() && Objects.equals(this.zonalShifts(), other.zonalShifts());
    }

    public final String toString() {
        return ToString.builder((String)"GetManagedResourceResponse").add("AppliedWeights", this.hasAppliedWeights() ? this.appliedWeights() : null).add("Arn", (Object)this.arn()).add("Autoshifts", this.hasAutoshifts() ? this.autoshifts() : null).add("Name", (Object)this.name()).add("PracticeRunConfiguration", (Object)this.practiceRunConfiguration()).add("ZonalAutoshiftStatus", (Object)this.zonalAutoshiftStatusAsString()).add("ZonalShifts", this.hasZonalShifts() ? this.zonalShifts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appliedWeights": {
                return Optional.ofNullable(clazz.cast(this.appliedWeights()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "autoshifts": {
                return Optional.ofNullable(clazz.cast(this.autoshifts()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "practiceRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.practiceRunConfiguration()));
            }
            case "zonalAutoshiftStatus": {
                return Optional.ofNullable(clazz.cast(this.zonalAutoshiftStatusAsString()));
            }
            case "zonalShifts": {
                return Optional.ofNullable(clazz.cast(this.zonalShifts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appliedWeights", APPLIED_WEIGHTS_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("autoshifts", AUTOSHIFTS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("practiceRunConfiguration", PRACTICE_RUN_CONFIGURATION_FIELD);
        map.put("zonalAutoshiftStatus", ZONAL_AUTOSHIFT_STATUS_FIELD);
        map.put("zonalShifts", ZONAL_SHIFTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedResourceResponse, T> g) {
        return obj -> g.apply((GetManagedResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcZonalShiftResponse.BuilderImpl
    implements Builder {
        private Map<String, Float> appliedWeights = DefaultSdkAutoConstructMap.getInstance();
        private String arn;
        private List<AutoshiftInResource> autoshifts = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private PracticeRunConfiguration practiceRunConfiguration;
        private String zonalAutoshiftStatus;
        private List<ZonalShiftInResource> zonalShifts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedResourceResponse model) {
            super(model);
            this.appliedWeights(model.appliedWeights);
            this.arn(model.arn);
            this.autoshifts(model.autoshifts);
            this.name(model.name);
            this.practiceRunConfiguration(model.practiceRunConfiguration);
            this.zonalAutoshiftStatus(model.zonalAutoshiftStatus);
            this.zonalShifts(model.zonalShifts);
        }

        public final Map<String, Float> getAppliedWeights() {
            if (this.appliedWeights instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.appliedWeights;
        }

        public final void setAppliedWeights(Map<String, Float> appliedWeights) {
            this.appliedWeights = AppliedWeightsCopier.copy(appliedWeights);
        }

        @Override
        public final Builder appliedWeights(Map<String, Float> appliedWeights) {
            this.appliedWeights = AppliedWeightsCopier.copy(appliedWeights);
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<AutoshiftInResource.Builder> getAutoshifts() {
            List<AutoshiftInResource.Builder> result = AutoshiftsInResourceCopier.copyToBuilder(this.autoshifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoshifts(Collection<AutoshiftInResource.BuilderImpl> autoshifts) {
            this.autoshifts = AutoshiftsInResourceCopier.copyFromBuilder(autoshifts);
        }

        @Override
        public final Builder autoshifts(Collection<AutoshiftInResource> autoshifts) {
            this.autoshifts = AutoshiftsInResourceCopier.copy(autoshifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoshifts(AutoshiftInResource ... autoshifts) {
            this.autoshifts(Arrays.asList(autoshifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoshifts(Consumer<AutoshiftInResource.Builder> ... autoshifts) {
            this.autoshifts(Stream.of(autoshifts).map(c -> (AutoshiftInResource)((AutoshiftInResource.Builder)AutoshiftInResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PracticeRunConfiguration.Builder getPracticeRunConfiguration() {
            return this.practiceRunConfiguration != null ? this.practiceRunConfiguration.toBuilder() : null;
        }

        public final void setPracticeRunConfiguration(PracticeRunConfiguration.BuilderImpl practiceRunConfiguration) {
            this.practiceRunConfiguration = practiceRunConfiguration != null ? practiceRunConfiguration.build() : null;
        }

        @Override
        public final Builder practiceRunConfiguration(PracticeRunConfiguration practiceRunConfiguration) {
            this.practiceRunConfiguration = practiceRunConfiguration;
            return this;
        }

        public final String getZonalAutoshiftStatus() {
            return this.zonalAutoshiftStatus;
        }

        public final void setZonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
        }

        @Override
        public final Builder zonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
            return this;
        }

        @Override
        public final Builder zonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus(zonalAutoshiftStatus == null ? null : zonalAutoshiftStatus.toString());
            return this;
        }

        public final List<ZonalShiftInResource.Builder> getZonalShifts() {
            List<ZonalShiftInResource.Builder> result = ZonalShiftsInResourceCopier.copyToBuilder(this.zonalShifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setZonalShifts(Collection<ZonalShiftInResource.BuilderImpl> zonalShifts) {
            this.zonalShifts = ZonalShiftsInResourceCopier.copyFromBuilder(zonalShifts);
        }

        @Override
        public final Builder zonalShifts(Collection<ZonalShiftInResource> zonalShifts) {
            this.zonalShifts = ZonalShiftsInResourceCopier.copy(zonalShifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zonalShifts(ZonalShiftInResource ... zonalShifts) {
            this.zonalShifts(Arrays.asList(zonalShifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zonalShifts(Consumer<ZonalShiftInResource.Builder> ... zonalShifts) {
            this.zonalShifts(Stream.of(zonalShifts).map(c -> (ZonalShiftInResource)((ZonalShiftInResource.Builder)ZonalShiftInResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetManagedResourceResponse build() {
            return new GetManagedResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcZonalShiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetManagedResourceResponse> {
        public Builder appliedWeights(Map<String, Float> var1);

        public Builder arn(String var1);

        public Builder autoshifts(Collection<AutoshiftInResource> var1);

        public Builder autoshifts(AutoshiftInResource ... var1);

        public Builder autoshifts(Consumer<AutoshiftInResource.Builder> ... var1);

        public Builder name(String var1);

        public Builder practiceRunConfiguration(PracticeRunConfiguration var1);

        default public Builder practiceRunConfiguration(Consumer<PracticeRunConfiguration.Builder> practiceRunConfiguration) {
            return this.practiceRunConfiguration((PracticeRunConfiguration)((PracticeRunConfiguration.Builder)PracticeRunConfiguration.builder().applyMutation(practiceRunConfiguration)).build());
        }

        public Builder zonalAutoshiftStatus(String var1);

        public Builder zonalAutoshiftStatus(ZonalAutoshiftStatus var1);

        public Builder zonalShifts(Collection<ZonalShiftInResource> var1);

        public Builder zonalShifts(ZonalShiftInResource ... var1);

        public Builder zonalShifts(Consumer<ZonalShiftInResource.Builder> ... var1);
    }
}

