/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConflictExceptionReason {
    ZONAL_SHIFT_ALREADY_EXISTS("ZonalShiftAlreadyExists"),
    ZONAL_SHIFT_STATUS_NOT_ACTIVE("ZonalShiftStatusNotActive"),
    SIMULTANEOUS_ZONAL_SHIFTS_CONFLICT("SimultaneousZonalShiftsConflict"),
    PRACTICE_CONFIGURATION_ALREADY_EXISTS("PracticeConfigurationAlreadyExists"),
    AUTO_SHIFT_ENABLED("AutoShiftEnabled"),
    PRACTICE_CONFIGURATION_DOES_NOT_EXIST("PracticeConfigurationDoesNotExist"),
    ZONAL_AUTOSHIFT_ACTIVE("ZonalAutoshiftActive"),
    PRACTICE_OUTCOME_ALARMS_RED("PracticeOutcomeAlarmsRed"),
    PRACTICE_BLOCKING_ALARMS_RED("PracticeBlockingAlarmsRed"),
    PRACTICE_IN_BLOCKED_DATES("PracticeInBlockedDates"),
    PRACTICE_IN_BLOCKED_WINDOWS("PracticeInBlockedWindows"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConflictExceptionReason> VALUE_MAP;
    private final String value;

    private ConflictExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConflictExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConflictExceptionReason> knownValues() {
        EnumSet<ConflictExceptionReason> knownValues = EnumSet.allOf(ConflictExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConflictExceptionReason.class, ConflictExceptionReason::toString);
    }
}

