/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionReason {
    INVALID_EXPIRES_IN("InvalidExpiresIn"),
    INVALID_STATUS("InvalidStatus"),
    MISSING_VALUE("MissingValue"),
    INVALID_TOKEN("InvalidToken"),
    INVALID_RESOURCE_IDENTIFIER("InvalidResourceIdentifier"),
    INVALID_AZ("InvalidAz"),
    UNSUPPORTED_AZ("UnsupportedAz"),
    INVALID_ALARM_CONDITION("InvalidAlarmCondition"),
    INVALID_CONDITION_TYPE("InvalidConditionType"),
    INVALID_PRACTICE_BLOCKER("InvalidPracticeBlocker"),
    FIS_EXPERIMENT_UPDATE_NOT_ALLOWED("FISExperimentUpdateNotAllowed"),
    AUTOSHIFT_UPDATE_NOT_ALLOWED("AutoshiftUpdateNotAllowed"),
    UNSUPPORTED_PRACTICE_CANCEL_SHIFT_TYPE("UnsupportedPracticeCancelShiftType"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionReason> VALUE_MAP;
    private final String value;

    private ValidationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionReason> knownValues() {
        EnumSet<ValidationExceptionReason> knownValues = EnumSet.allOf(ValidationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionReason.class, ValidationExceptionReason::toString);
    }
}

