/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.arczonalshift.model.CancelPracticeRunRequest;
import software.amazon.awssdk.services.arczonalshift.model.CancelPracticeRunResponse;
import software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftRequest;
import software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftResponse;
import software.amazon.awssdk.services.arczonalshift.model.CreatePracticeRunConfigurationRequest;
import software.amazon.awssdk.services.arczonalshift.model.CreatePracticeRunConfigurationResponse;
import software.amazon.awssdk.services.arczonalshift.model.DeletePracticeRunConfigurationRequest;
import software.amazon.awssdk.services.arczonalshift.model.DeletePracticeRunConfigurationResponse;
import software.amazon.awssdk.services.arczonalshift.model.GetAutoshiftObserverNotificationStatusRequest;
import software.amazon.awssdk.services.arczonalshift.model.GetAutoshiftObserverNotificationStatusResponse;
import software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceRequest;
import software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceResponse;
import software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsResponse;
import software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse;
import software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse;
import software.amazon.awssdk.services.arczonalshift.model.StartPracticeRunRequest;
import software.amazon.awssdk.services.arczonalshift.model.StartPracticeRunResponse;
import software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftRequest;
import software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftResponse;
import software.amazon.awssdk.services.arczonalshift.model.UpdateAutoshiftObserverNotificationStatusRequest;
import software.amazon.awssdk.services.arczonalshift.model.UpdateAutoshiftObserverNotificationStatusResponse;
import software.amazon.awssdk.services.arczonalshift.model.UpdatePracticeRunConfigurationRequest;
import software.amazon.awssdk.services.arczonalshift.model.UpdatePracticeRunConfigurationResponse;
import software.amazon.awssdk.services.arczonalshift.model.UpdateZonalAutoshiftConfigurationRequest;
import software.amazon.awssdk.services.arczonalshift.model.UpdateZonalAutoshiftConfigurationResponse;
import software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftRequest;
import software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftResponse;
import software.amazon.awssdk.services.arczonalshift.paginators.ListAutoshiftsPublisher;
import software.amazon.awssdk.services.arczonalshift.paginators.ListManagedResourcesPublisher;
import software.amazon.awssdk.services.arczonalshift.paginators.ListZonalShiftsPublisher;

/**
 * Service client for accessing AWS ARC - Zonal Shift asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Welcome to the API Reference Guide for zonal shift and zonal autoshift in Amazon Application Recovery Controller
 * (ARC).
 * </p>
 * <p>
 * You can start a zonal shift to move traffic for a load balancer resource away from an Availability Zone to help your
 * application recover quickly from an impairment in an Availability Zone. For example, you can recover your application
 * from a developer's bad code deployment or from an Amazon Web Services infrastructure failure in a single Availability
 * Zone.
 * </p>
 * <p>
 * You can also configure zonal autoshift for supported load balancer resources. Zonal autoshift is a capability in ARC
 * where you authorize Amazon Web Services to shift away application resource traffic from an Availability Zone during
 * events, on your behalf, to help reduce your time to recovery. Amazon Web Services starts an autoshift when internal
 * telemetry indicates that there is an Availability Zone impairment that could potentially impact customers.
 * </p>
 * <p>
 * For more information about using zonal shift and zonal autoshift, see the <a
 * href="https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route53-recovery.html">Amazon Application Recovery
 * Controller Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ArcZonalShiftAsyncClient extends AwsClient {
    String SERVICE_NAME = "arc-zonal-shift";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "arc-zonal-shift";

    /**
     * <p>
     * Cancel an in-progress practice run zonal shift in Amazon Application Recovery Controller.
     * </p>
     *
     * @param cancelPracticeRunRequest
     * @return A Java Future containing the result of the CancelPracticeRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.CancelPracticeRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CancelPracticeRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelPracticeRunResponse> cancelPracticeRun(CancelPracticeRunRequest cancelPracticeRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancel an in-progress practice run zonal shift in Amazon Application Recovery Controller.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelPracticeRunRequest.Builder} avoiding the need
     * to create one manually via {@link CancelPracticeRunRequest#builder()}
     * </p>
     *
     * @param cancelPracticeRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.CancelPracticeRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelPracticeRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.CancelPracticeRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CancelPracticeRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelPracticeRunResponse> cancelPracticeRun(
            Consumer<CancelPracticeRunRequest.Builder> cancelPracticeRunRequest) {
        return cancelPracticeRun(CancelPracticeRunRequest.builder().applyMutation(cancelPracticeRunRequest).build());
    }

    /**
     * <p>
     * Cancel a zonal shift in Amazon Application Recovery Controller. To cancel the zonal shift, specify the zonal
     * shift ID.
     * </p>
     * <p>
     * A zonal shift can be one that you've started for a resource in your Amazon Web Services account in an Amazon Web
     * Services Region, or it can be a zonal shift started by a practice run with zonal autoshift.
     * </p>
     *
     * @param cancelZonalShiftRequest
     * @return A Java Future containing the result of the CancelZonalShift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.CancelZonalShift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CancelZonalShift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelZonalShiftResponse> cancelZonalShift(CancelZonalShiftRequest cancelZonalShiftRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancel a zonal shift in Amazon Application Recovery Controller. To cancel the zonal shift, specify the zonal
     * shift ID.
     * </p>
     * <p>
     * A zonal shift can be one that you've started for a resource in your Amazon Web Services account in an Amazon Web
     * Services Region, or it can be a zonal shift started by a practice run with zonal autoshift.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelZonalShiftRequest.Builder} avoiding the need
     * to create one manually via {@link CancelZonalShiftRequest#builder()}
     * </p>
     *
     * @param cancelZonalShiftRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelZonalShift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.CancelZonalShift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CancelZonalShift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelZonalShiftResponse> cancelZonalShift(
            Consumer<CancelZonalShiftRequest.Builder> cancelZonalShiftRequest) {
        return cancelZonalShift(CancelZonalShiftRequest.builder().applyMutation(cancelZonalShiftRequest).build());
    }

    /**
     * <p>
     * A practice run configuration for zonal autoshift is required when you enable zonal autoshift. A practice run
     * configuration includes specifications for blocked dates and blocked time windows, and for Amazon CloudWatch
     * alarms that you create to use with practice runs. The alarms that you specify are an <i>outcome alarm</i>, to
     * monitor application health during practice runs and, optionally, a <i>blocking alarm</i>, to block practice runs
     * from starting.
     * </p>
     * <p>
     * When a resource has a practice run configuration, ARC starts zonal shifts for the resource weekly, to shift
     * traffic for practice runs. Practice runs help you to ensure that shifting away traffic from an Availability Zone
     * during an autoshift is safe for your application.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html"> Considerations
     * when you configure zonal autoshift</a> in the Amazon Application Recovery Controller Developer Guide.
     * </p>
     *
     * @param createPracticeRunConfigurationRequest
     * @return A Java Future containing the result of the CreatePracticeRunConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.CreatePracticeRunConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CreatePracticeRunConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePracticeRunConfigurationResponse> createPracticeRunConfiguration(
            CreatePracticeRunConfigurationRequest createPracticeRunConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A practice run configuration for zonal autoshift is required when you enable zonal autoshift. A practice run
     * configuration includes specifications for blocked dates and blocked time windows, and for Amazon CloudWatch
     * alarms that you create to use with practice runs. The alarms that you specify are an <i>outcome alarm</i>, to
     * monitor application health during practice runs and, optionally, a <i>blocking alarm</i>, to block practice runs
     * from starting.
     * </p>
     * <p>
     * When a resource has a practice run configuration, ARC starts zonal shifts for the resource weekly, to shift
     * traffic for practice runs. Practice runs help you to ensure that shifting away traffic from an Availability Zone
     * during an autoshift is safe for your application.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html"> Considerations
     * when you configure zonal autoshift</a> in the Amazon Application Recovery Controller Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePracticeRunConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePracticeRunConfigurationRequest#builder()}
     * </p>
     *
     * @param createPracticeRunConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.CreatePracticeRunConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreatePracticeRunConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.CreatePracticeRunConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CreatePracticeRunConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePracticeRunConfigurationResponse> createPracticeRunConfiguration(
            Consumer<CreatePracticeRunConfigurationRequest.Builder> createPracticeRunConfigurationRequest) {
        return createPracticeRunConfiguration(CreatePracticeRunConfigurationRequest.builder()
                .applyMutation(createPracticeRunConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the practice run configuration for a resource. Before you can delete a practice run configuration for a
     * resource., you must disable zonal autoshift for the resource. Practice runs must be configured for zonal
     * autoshift to be enabled.
     * </p>
     *
     * @param deletePracticeRunConfigurationRequest
     * @return A Java Future containing the result of the DeletePracticeRunConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.DeletePracticeRunConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/DeletePracticeRunConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePracticeRunConfigurationResponse> deletePracticeRunConfiguration(
            DeletePracticeRunConfigurationRequest deletePracticeRunConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the practice run configuration for a resource. Before you can delete a practice run configuration for a
     * resource., you must disable zonal autoshift for the resource. Practice runs must be configured for zonal
     * autoshift to be enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePracticeRunConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePracticeRunConfigurationRequest#builder()}
     * </p>
     *
     * @param deletePracticeRunConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.DeletePracticeRunConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeletePracticeRunConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.DeletePracticeRunConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/DeletePracticeRunConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePracticeRunConfigurationResponse> deletePracticeRunConfiguration(
            Consumer<DeletePracticeRunConfigurationRequest.Builder> deletePracticeRunConfigurationRequest) {
        return deletePracticeRunConfiguration(DeletePracticeRunConfigurationRequest.builder()
                .applyMutation(deletePracticeRunConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the status of the autoshift observer notification. Autoshift observer notifications notify you through
     * Amazon EventBridge when there is an autoshift event for zonal autoshift. The status can be <code>ENABLED</code>
     * or <code>DISABLED</code>. When <code>ENABLED</code>, a notification is sent when an autoshift is triggered. When
     * <code>DISABLED</code>, notifications are not sent.
     * </p>
     *
     * @param getAutoshiftObserverNotificationStatusRequest
     * @return A Java Future containing the result of the GetAutoshiftObserverNotificationStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.GetAutoshiftObserverNotificationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/GetAutoshiftObserverNotificationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutoshiftObserverNotificationStatusResponse> getAutoshiftObserverNotificationStatus(
            GetAutoshiftObserverNotificationStatusRequest getAutoshiftObserverNotificationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of the autoshift observer notification. Autoshift observer notifications notify you through
     * Amazon EventBridge when there is an autoshift event for zonal autoshift. The status can be <code>ENABLED</code>
     * or <code>DISABLED</code>. When <code>ENABLED</code>, a notification is sent when an autoshift is triggered. When
     * <code>DISABLED</code>, notifications are not sent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAutoshiftObserverNotificationStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetAutoshiftObserverNotificationStatusRequest#builder()}
     * </p>
     *
     * @param getAutoshiftObserverNotificationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.GetAutoshiftObserverNotificationStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAutoshiftObserverNotificationStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.GetAutoshiftObserverNotificationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/GetAutoshiftObserverNotificationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutoshiftObserverNotificationStatusResponse> getAutoshiftObserverNotificationStatus(
            Consumer<GetAutoshiftObserverNotificationStatusRequest.Builder> getAutoshiftObserverNotificationStatusRequest) {
        return getAutoshiftObserverNotificationStatus(GetAutoshiftObserverNotificationStatusRequest.builder()
                .applyMutation(getAutoshiftObserverNotificationStatusRequest).build());
    }

    /**
     * <p>
     * Get information about a resource that's been registered for zonal shifts with Amazon Application Recovery
     * Controller in this Amazon Web Services Region. Resources that are registered for zonal shifts are managed
     * resources in ARC. You can start zonal shifts and configure zonal autoshift for managed resources.
     * </p>
     *
     * @param getManagedResourceRequest
     * @return A Java Future containing the result of the GetManagedResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.GetManagedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/GetManagedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedResourceResponse> getManagedResource(GetManagedResourceRequest getManagedResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a resource that's been registered for zonal shifts with Amazon Application Recovery
     * Controller in this Amazon Web Services Region. Resources that are registered for zonal shifts are managed
     * resources in ARC. You can start zonal shifts and configure zonal autoshift for managed resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedResourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetManagedResourceRequest#builder()}
     * </p>
     *
     * @param getManagedResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetManagedResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.GetManagedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/GetManagedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedResourceResponse> getManagedResource(
            Consumer<GetManagedResourceRequest.Builder> getManagedResourceRequest) {
        return getManagedResource(GetManagedResourceRequest.builder().applyMutation(getManagedResourceRequest).build());
    }

    /**
     * <p>
     * Returns the autoshifts for an Amazon Web Services Region. By default, the call returns only <code>ACTIVE</code>
     * autoshifts. Optionally, you can specify the <code>status</code> parameter to return <code>COMPLETED</code>
     * autoshifts.
     * </p>
     *
     * @param listAutoshiftsRequest
     * @return A Java Future containing the result of the ListAutoshifts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListAutoshifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListAutoshifts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutoshiftsResponse> listAutoshifts(ListAutoshiftsRequest listAutoshiftsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the autoshifts for an Amazon Web Services Region. By default, the call returns only <code>ACTIVE</code>
     * autoshifts. Optionally, you can specify the <code>status</code> parameter to return <code>COMPLETED</code>
     * autoshifts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutoshiftsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAutoshiftsRequest#builder()}
     * </p>
     *
     * @param listAutoshiftsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAutoshifts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListAutoshifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListAutoshifts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutoshiftsResponse> listAutoshifts(Consumer<ListAutoshiftsRequest.Builder> listAutoshiftsRequest) {
        return listAutoshifts(ListAutoshiftsRequest.builder().applyMutation(listAutoshiftsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutoshifts(software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListAutoshiftsPublisher publisher = client.listAutoshiftsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListAutoshiftsPublisher publisher = client.listAutoshiftsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutoshifts(software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsRequest)} operation.</b>
     * </p>
     *
     * @param listAutoshiftsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListAutoshifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListAutoshifts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutoshiftsPublisher listAutoshiftsPaginator(ListAutoshiftsRequest listAutoshiftsRequest) {
        return new ListAutoshiftsPublisher(this, listAutoshiftsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutoshifts(software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListAutoshiftsPublisher publisher = client.listAutoshiftsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListAutoshiftsPublisher publisher = client.listAutoshiftsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutoshifts(software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutoshiftsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAutoshiftsRequest#builder()}
     * </p>
     *
     * @param listAutoshiftsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListAutoshifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListAutoshifts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutoshiftsPublisher listAutoshiftsPaginator(Consumer<ListAutoshiftsRequest.Builder> listAutoshiftsRequest) {
        return listAutoshiftsPaginator(ListAutoshiftsRequest.builder().applyMutation(listAutoshiftsRequest).build());
    }

    /**
     * <p>
     * Lists all the resources in your Amazon Web Services account in this Amazon Web Services Region that are managed
     * for zonal shifts in Amazon Application Recovery Controller, and information about them. The information includes
     * the zonal autoshift status for the resource, as well as the Amazon Resource Name (ARN), the Availability Zones
     * that each resource is deployed in, and the resource name.
     * </p>
     *
     * @param listManagedResourcesRequest
     * @return A Java Future containing the result of the ListManagedResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListManagedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListManagedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedResourcesResponse> listManagedResources(
            ListManagedResourcesRequest listManagedResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the resources in your Amazon Web Services account in this Amazon Web Services Region that are managed
     * for zonal shifts in Amazon Application Recovery Controller, and information about them. The information includes
     * the zonal autoshift status for the resource, as well as the Amazon Resource Name (ARN), the Availability Zones
     * that each resource is deployed in, and the resource name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedResourcesRequest#builder()}
     * </p>
     *
     * @param listManagedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListManagedResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListManagedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListManagedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedResourcesResponse> listManagedResources(
            Consumer<ListManagedResourcesRequest.Builder> listManagedResourcesRequest) {
        return listManagedResources(ListManagedResourcesRequest.builder().applyMutation(listManagedResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedResources(software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListManagedResourcesPublisher publisher = client.listManagedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListManagedResourcesPublisher publisher = client.listManagedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedResources(software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListManagedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListManagedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedResourcesPublisher listManagedResourcesPaginator(ListManagedResourcesRequest listManagedResourcesRequest) {
        return new ListManagedResourcesPublisher(this, listManagedResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedResources(software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListManagedResourcesPublisher publisher = client.listManagedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListManagedResourcesPublisher publisher = client.listManagedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedResources(software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedResourcesRequest#builder()}
     * </p>
     *
     * @param listManagedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListManagedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListManagedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedResourcesPublisher listManagedResourcesPaginator(
            Consumer<ListManagedResourcesRequest.Builder> listManagedResourcesRequest) {
        return listManagedResourcesPaginator(ListManagedResourcesRequest.builder().applyMutation(listManagedResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all active and completed zonal shifts in Amazon Application Recovery Controller in your Amazon Web Services
     * account in this Amazon Web Services Region. <code>ListZonalShifts</code> returns customer-initiated zonal shifts,
     * as well as practice run zonal shifts that ARC started on your behalf for zonal autoshift.
     * </p>
     * <p>
     * For more information about listing autoshifts, see <a
     * href="https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListAutoshifts.html">"&gt;ListAutoshifts</a>.
     * </p>
     *
     * @param listZonalShiftsRequest
     * @return A Java Future containing the result of the ListZonalShifts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListZonalShifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListZonalShifts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListZonalShiftsResponse> listZonalShifts(ListZonalShiftsRequest listZonalShiftsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all active and completed zonal shifts in Amazon Application Recovery Controller in your Amazon Web Services
     * account in this Amazon Web Services Region. <code>ListZonalShifts</code> returns customer-initiated zonal shifts,
     * as well as practice run zonal shifts that ARC started on your behalf for zonal autoshift.
     * </p>
     * <p>
     * For more information about listing autoshifts, see <a
     * href="https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListAutoshifts.html">"&gt;ListAutoshifts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListZonalShiftsRequest.Builder} avoiding the need
     * to create one manually via {@link ListZonalShiftsRequest#builder()}
     * </p>
     *
     * @param listZonalShiftsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListZonalShifts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListZonalShifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListZonalShifts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListZonalShiftsResponse> listZonalShifts(
            Consumer<ListZonalShiftsRequest.Builder> listZonalShiftsRequest) {
        return listZonalShifts(ListZonalShiftsRequest.builder().applyMutation(listZonalShiftsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listZonalShifts(software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListZonalShiftsPublisher publisher = client.listZonalShiftsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListZonalShiftsPublisher publisher = client.listZonalShiftsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listZonalShifts(software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listZonalShiftsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListZonalShifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListZonalShifts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListZonalShiftsPublisher listZonalShiftsPaginator(ListZonalShiftsRequest listZonalShiftsRequest) {
        return new ListZonalShiftsPublisher(this, listZonalShiftsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listZonalShifts(software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListZonalShiftsPublisher publisher = client.listZonalShiftsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.arczonalshift.paginators.ListZonalShiftsPublisher publisher = client.listZonalShiftsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listZonalShifts(software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListZonalShiftsRequest.Builder} avoiding the need
     * to create one manually via {@link ListZonalShiftsRequest#builder()}
     * </p>
     *
     * @param listZonalShiftsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.ListZonalShifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListZonalShifts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListZonalShiftsPublisher listZonalShiftsPaginator(Consumer<ListZonalShiftsRequest.Builder> listZonalShiftsRequest) {
        return listZonalShiftsPaginator(ListZonalShiftsRequest.builder().applyMutation(listZonalShiftsRequest).build());
    }

    /**
     * <p>
     * Start an on-demand practice run zonal shift in Amazon Application Recovery Controller. With zonal autoshift
     * enabled, you can start an on-demand practice run to verify preparedness at any time. Amazon Web Services also
     * runs automated practice runs about weekly when you have enabled zonal autoshift.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html"> Considerations
     * when you configure zonal autoshift</a> in the Amazon Application Recovery Controller Developer Guide.
     * </p>
     *
     * @param startPracticeRunRequest
     * @return A Java Future containing the result of the StartPracticeRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.StartPracticeRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/StartPracticeRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPracticeRunResponse> startPracticeRun(StartPracticeRunRequest startPracticeRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start an on-demand practice run zonal shift in Amazon Application Recovery Controller. With zonal autoshift
     * enabled, you can start an on-demand practice run to verify preparedness at any time. Amazon Web Services also
     * runs automated practice runs about weekly when you have enabled zonal autoshift.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html"> Considerations
     * when you configure zonal autoshift</a> in the Amazon Application Recovery Controller Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPracticeRunRequest.Builder} avoiding the need
     * to create one manually via {@link StartPracticeRunRequest#builder()}
     * </p>
     *
     * @param startPracticeRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.StartPracticeRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartPracticeRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.StartPracticeRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/StartPracticeRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPracticeRunResponse> startPracticeRun(
            Consumer<StartPracticeRunRequest.Builder> startPracticeRunRequest) {
        return startPracticeRun(StartPracticeRunRequest.builder().applyMutation(startPracticeRunRequest).build());
    }

    /**
     * <p>
     * You start a zonal shift to temporarily move load balancer traffic away from an Availability Zone in an Amazon Web
     * Services Region, to help your application recover immediately, for example, from a developer's bad code
     * deployment or from an Amazon Web Services infrastructure failure in a single Availability Zone. You can start a
     * zonal shift in ARC only for managed resources in your Amazon Web Services account in an Amazon Web Services
     * Region. Resources are automatically registered with ARC by Amazon Web Services services.
     * </p>
     * <p>
     * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and
     * zonal autoshift:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html"
     * >Amazon EC2 Auto Scaling groups</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html">Amazon
     * Elastic Kubernetes Service</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html"
     * >Application Load Balancer</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html"
     * >Network Load Balancer</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you start a zonal shift, traffic for the resource is no longer routed to the Availability Zone. The zonal
     * shift is created immediately in ARC. However, it can take a short time, typically up to a few minutes, for
     * existing, in-progress connections in the Availability Zone to complete.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.html">Zonal
     * shift</a> in the Amazon Application Recovery Controller Developer Guide.
     * </p>
     *
     * @param startZonalShiftRequest
     * @return A Java Future containing the result of the StartZonalShift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.StartZonalShift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/StartZonalShift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartZonalShiftResponse> startZonalShift(StartZonalShiftRequest startZonalShiftRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You start a zonal shift to temporarily move load balancer traffic away from an Availability Zone in an Amazon Web
     * Services Region, to help your application recover immediately, for example, from a developer's bad code
     * deployment or from an Amazon Web Services infrastructure failure in a single Availability Zone. You can start a
     * zonal shift in ARC only for managed resources in your Amazon Web Services account in an Amazon Web Services
     * Region. Resources are automatically registered with ARC by Amazon Web Services services.
     * </p>
     * <p>
     * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and
     * zonal autoshift:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html"
     * >Amazon EC2 Auto Scaling groups</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html">Amazon
     * Elastic Kubernetes Service</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html"
     * >Application Load Balancer</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html"
     * >Network Load Balancer</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you start a zonal shift, traffic for the resource is no longer routed to the Availability Zone. The zonal
     * shift is created immediately in ARC. However, it can take a short time, typically up to a few minutes, for
     * existing, in-progress connections in the Availability Zone to complete.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.html">Zonal
     * shift</a> in the Amazon Application Recovery Controller Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartZonalShiftRequest.Builder} avoiding the need
     * to create one manually via {@link StartZonalShiftRequest#builder()}
     * </p>
     *
     * @param startZonalShiftRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartZonalShift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.StartZonalShift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/StartZonalShift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartZonalShiftResponse> startZonalShift(
            Consumer<StartZonalShiftRequest.Builder> startZonalShiftRequest) {
        return startZonalShift(StartZonalShiftRequest.builder().applyMutation(startZonalShiftRequest).build());
    }

    /**
     * <p>
     * Update the status of autoshift observer notification. Autoshift observer notification enables you to be notified,
     * through Amazon EventBridge, when there is an autoshift event for zonal autoshift.
     * </p>
     * <p>
     * If the status is <code>ENABLED</code>, ARC includes all autoshift events when you use the EventBridge pattern
     * <code>Autoshift In Progress</code>. When the status is <code>DISABLED</code>, ARC includes only autoshift events
     * for autoshifts when one or more of your resources is included in the autoshift.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html#ZAShiftNotification">
     * Notifications for practice runs and autoshifts</a> in the Amazon Application Recovery Controller Developer Guide.
     * </p>
     *
     * @param updateAutoshiftObserverNotificationStatusRequest
     * @return A Java Future containing the result of the UpdateAutoshiftObserverNotificationStatus operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.UpdateAutoshiftObserverNotificationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateAutoshiftObserverNotificationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAutoshiftObserverNotificationStatusResponse> updateAutoshiftObserverNotificationStatus(
            UpdateAutoshiftObserverNotificationStatusRequest updateAutoshiftObserverNotificationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the status of autoshift observer notification. Autoshift observer notification enables you to be notified,
     * through Amazon EventBridge, when there is an autoshift event for zonal autoshift.
     * </p>
     * <p>
     * If the status is <code>ENABLED</code>, ARC includes all autoshift events when you use the EventBridge pattern
     * <code>Autoshift In Progress</code>. When the status is <code>DISABLED</code>, ARC includes only autoshift events
     * for autoshifts when one or more of your resources is included in the autoshift.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html#ZAShiftNotification">
     * Notifications for practice runs and autoshifts</a> in the Amazon Application Recovery Controller Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateAutoshiftObserverNotificationStatusRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateAutoshiftObserverNotificationStatusRequest#builder()}
     * </p>
     *
     * @param updateAutoshiftObserverNotificationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.UpdateAutoshiftObserverNotificationStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateAutoshiftObserverNotificationStatus operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.UpdateAutoshiftObserverNotificationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateAutoshiftObserverNotificationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAutoshiftObserverNotificationStatusResponse> updateAutoshiftObserverNotificationStatus(
            Consumer<UpdateAutoshiftObserverNotificationStatusRequest.Builder> updateAutoshiftObserverNotificationStatusRequest) {
        return updateAutoshiftObserverNotificationStatus(UpdateAutoshiftObserverNotificationStatusRequest.builder()
                .applyMutation(updateAutoshiftObserverNotificationStatusRequest).build());
    }

    /**
     * <p>
     * Update a practice run configuration to change one or more of the following: add, change, or remove the blocking
     * alarm; change the outcome alarm; or add, change, or remove blocking dates or time windows.
     * </p>
     *
     * @param updatePracticeRunConfigurationRequest
     * @return A Java Future containing the result of the UpdatePracticeRunConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.UpdatePracticeRunConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdatePracticeRunConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePracticeRunConfigurationResponse> updatePracticeRunConfiguration(
            UpdatePracticeRunConfigurationRequest updatePracticeRunConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a practice run configuration to change one or more of the following: add, change, or remove the blocking
     * alarm; change the outcome alarm; or add, change, or remove blocking dates or time windows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePracticeRunConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdatePracticeRunConfigurationRequest#builder()}
     * </p>
     *
     * @param updatePracticeRunConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.UpdatePracticeRunConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdatePracticeRunConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.UpdatePracticeRunConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdatePracticeRunConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePracticeRunConfigurationResponse> updatePracticeRunConfiguration(
            Consumer<UpdatePracticeRunConfigurationRequest.Builder> updatePracticeRunConfigurationRequest) {
        return updatePracticeRunConfiguration(UpdatePracticeRunConfigurationRequest.builder()
                .applyMutation(updatePracticeRunConfigurationRequest).build());
    }

    /**
     * <p>
     * The zonal autoshift configuration for a resource includes the practice run configuration and the status for
     * running autoshifts, zonal autoshift status. When a resource has a practice run configuration, ARC starts weekly
     * zonal shifts for the resource, to shift traffic away from an Availability Zone. Weekly practice runs help you to
     * make sure that your application can continue to operate normally with the loss of one Availability Zone.
     * </p>
     * <p>
     * You can update the zonal autoshift status to enable or disable zonal autoshift. When zonal autoshift is
     * <code>ENABLED</code>, you authorize Amazon Web Services to shift away resource traffic for an application from an
     * Availability Zone during events, on your behalf, to help reduce time to recovery. Traffic is also shifted away
     * for the required weekly practice runs.
     * </p>
     *
     * @param updateZonalAutoshiftConfigurationRequest
     * @return A Java Future containing the result of the UpdateZonalAutoshiftConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.UpdateZonalAutoshiftConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateZonalAutoshiftConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateZonalAutoshiftConfigurationResponse> updateZonalAutoshiftConfiguration(
            UpdateZonalAutoshiftConfigurationRequest updateZonalAutoshiftConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The zonal autoshift configuration for a resource includes the practice run configuration and the status for
     * running autoshifts, zonal autoshift status. When a resource has a practice run configuration, ARC starts weekly
     * zonal shifts for the resource, to shift traffic away from an Availability Zone. Weekly practice runs help you to
     * make sure that your application can continue to operate normally with the loss of one Availability Zone.
     * </p>
     * <p>
     * You can update the zonal autoshift status to enable or disable zonal autoshift. When zonal autoshift is
     * <code>ENABLED</code>, you authorize Amazon Web Services to shift away resource traffic for an application from an
     * Availability Zone during events, on your behalf, to help reduce time to recovery. Traffic is also shifted away
     * for the required weekly practice runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateZonalAutoshiftConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateZonalAutoshiftConfigurationRequest#builder()}
     * </p>
     *
     * @param updateZonalAutoshiftConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.UpdateZonalAutoshiftConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateZonalAutoshiftConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.UpdateZonalAutoshiftConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateZonalAutoshiftConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateZonalAutoshiftConfigurationResponse> updateZonalAutoshiftConfiguration(
            Consumer<UpdateZonalAutoshiftConfigurationRequest.Builder> updateZonalAutoshiftConfigurationRequest) {
        return updateZonalAutoshiftConfiguration(UpdateZonalAutoshiftConfigurationRequest.builder()
                .applyMutation(updateZonalAutoshiftConfigurationRequest).build());
    }

    /**
     * <p>
     * Update an active zonal shift in Amazon Application Recovery Controller in your Amazon Web Services account. You
     * can update a zonal shift to set a new expiration, or edit or replace the comment for the zonal shift.
     * </p>
     *
     * @param updateZonalShiftRequest
     * @return A Java Future containing the result of the UpdateZonalShift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.UpdateZonalShift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateZonalShift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateZonalShiftResponse> updateZonalShift(UpdateZonalShiftRequest updateZonalShiftRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an active zonal shift in Amazon Application Recovery Controller in your Amazon Web Services account. You
     * can update a zonal shift to set a new expiration, or edit or replace the comment for the zonal shift.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateZonalShiftRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateZonalShiftRequest#builder()}
     * </p>
     *
     * @param updateZonalShiftRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateZonalShift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ResourceNotFoundException The input requested a resource that was not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArcZonalShiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArcZonalShiftAsyncClient.UpdateZonalShift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateZonalShift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateZonalShiftResponse> updateZonalShift(
            Consumer<UpdateZonalShiftRequest.Builder> updateZonalShiftRequest) {
        return updateZonalShift(UpdateZonalShiftRequest.builder().applyMutation(updateZonalShiftRequest).build());
    }

    @Override
    default ArcZonalShiftServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ArcZonalShiftAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ArcZonalShiftAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ArcZonalShiftAsyncClient}.
     */
    static ArcZonalShiftAsyncClientBuilder builder() {
        return new DefaultArcZonalShiftAsyncClientBuilder();
    }
}
