/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AutoshiftsInResourceCopier {
    static List<AutoshiftInResource> copy(Collection<? extends AutoshiftInResource> autoshiftsInResourceParam) {
        List<AutoshiftInResource> list;
        if (autoshiftsInResourceParam == null || autoshiftsInResourceParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutoshiftInResource> modifiableList = new ArrayList<>(autoshiftsInResourceParam.size());
            autoshiftsInResourceParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AutoshiftInResource> copyFromBuilder(Collection<? extends AutoshiftInResource.Builder> autoshiftsInResourceParam) {
        List<AutoshiftInResource> list;
        if (autoshiftsInResourceParam == null || autoshiftsInResourceParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutoshiftInResource> modifiableList = new ArrayList<>(autoshiftsInResourceParam.size());
            autoshiftsInResourceParam.forEach(entry -> {
                AutoshiftInResource member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AutoshiftInResource.Builder> copyToBuilder(Collection<? extends AutoshiftInResource> autoshiftsInResourceParam) {
        List<AutoshiftInResource.Builder> list;
        if (autoshiftsInResourceParam == null || autoshiftsInResourceParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutoshiftInResource.Builder> modifiableList = new ArrayList<>(autoshiftsInResourceParam.size());
            autoshiftsInResourceParam.forEach(entry -> {
                AutoshiftInResource.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
