/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelPracticeRunResponse extends ArcZonalShiftResponse implements
        ToCopyableBuilder<CancelPracticeRunResponse.Builder, CancelPracticeRunResponse> {
    private static final SdkField<String> ZONAL_SHIFT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("zonalShiftId").getter(getter(CancelPracticeRunResponse::zonalShiftId))
            .setter(setter(Builder::zonalShiftId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShiftId").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(CancelPracticeRunResponse::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final SdkField<String> AWAY_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awayFrom").getter(getter(CancelPracticeRunResponse::awayFrom)).setter(setter(Builder::awayFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awayFrom").build()).build();

    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiryTime").getter(getter(CancelPracticeRunResponse::expiryTime)).setter(setter(Builder::expiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiryTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(CancelPracticeRunResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CancelPracticeRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(CancelPracticeRunResponse::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONAL_SHIFT_ID_FIELD,
            RESOURCE_IDENTIFIER_FIELD, AWAY_FROM_FIELD, EXPIRY_TIME_FIELD, START_TIME_FIELD, STATUS_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String zonalShiftId;

    private final String resourceIdentifier;

    private final String awayFrom;

    private final Instant expiryTime;

    private final Instant startTime;

    private final String status;

    private final String comment;

    private CancelPracticeRunResponse(BuilderImpl builder) {
        super(builder);
        this.zonalShiftId = builder.zonalShiftId;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.awayFrom = builder.awayFrom;
        this.expiryTime = builder.expiryTime;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The identifier of the practice run zonal shift in Amazon Application Recovery Controller that was canceled.
     * </p>
     * 
     * @return The identifier of the practice run zonal shift in Amazon Application Recovery Controller that was
     *         canceled.
     */
    public final String zonalShiftId() {
        return zonalShiftId;
    }

    /**
     * <p>
     * The identifier for the resource that you canceled a practice run zonal shift for. The identifier is the Amazon
     * Resource Name (ARN) for the resource.
     * </p>
     * 
     * @return The identifier for the resource that you canceled a practice run zonal shift for. The identifier is the
     *         Amazon Resource Name (ARN) for the resource.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The Availability Zone (for example, <code>use1-az1</code>) that traffic was moved away from for a resource that
     * you specified for the practice run.
     * </p>
     * 
     * @return The Availability Zone (for example, <code>use1-az1</code>) that traffic was moved away from for a
     *         resource that you specified for the practice run.
     */
    public final String awayFrom() {
        return awayFrom;
    }

    /**
     * <p>
     * The expiry time (expiration time) for an on-demand practice run zonal shift is 30 minutes from the time when you
     * start the practice run, unless you cancel it before that time. However, be aware that the <code>expiryTime</code>
     * field for practice run zonal shifts always has a value of 1 minute.
     * </p>
     * 
     * @return The expiry time (expiration time) for an on-demand practice run zonal shift is 30 minutes from the time
     *         when you start the practice run, unless you cancel it before that time. However, be aware that the
     *         <code>expiryTime</code> field for practice run zonal shifts always has a value of 1 minute.
     */
    public final Instant expiryTime() {
        return expiryTime;
    }

    /**
     * <p>
     * The time (UTC) when the zonal shift starts.
     * </p>
     * 
     * @return The time (UTC) when the zonal shift starts.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * A status for the practice run that you canceled (expected status is <b>CANCELED</b>).
     * </p>
     * <p>
     * The <code>Status</code> for a practice run zonal shift can have one of the following values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ZonalShiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status for the practice run that you canceled (expected status is <b>CANCELED</b>).</p>
     *         <p>
     *         The <code>Status</code> for a practice run zonal shift can have one of the following values:
     * @see ZonalShiftStatus
     */
    public final ZonalShiftStatus status() {
        return ZonalShiftStatus.fromValue(status);
    }

    /**
     * <p>
     * A status for the practice run that you canceled (expected status is <b>CANCELED</b>).
     * </p>
     * <p>
     * The <code>Status</code> for a practice run zonal shift can have one of the following values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ZonalShiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status for the practice run that you canceled (expected status is <b>CANCELED</b>).</p>
     *         <p>
     *         The <code>Status</code> for a practice run zonal shift can have one of the following values:
     * @see ZonalShiftStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The initial comment that you entered about the practice run. Be aware that this comment can be overwritten by
     * Amazon Web Services if the automatic check for balanced capacity fails. For more information, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html">
     * Capacity checks for practice runs</a> in the Amazon Application Recovery Controller Developer Guide.
     * </p>
     * 
     * @return The initial comment that you entered about the practice run. Be aware that this comment can be
     *         overwritten by Amazon Web Services if the automatic check for balanced capacity fails. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html">
     *         Capacity checks for practice runs</a> in the Amazon Application Recovery Controller Developer Guide.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(zonalShiftId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(awayFrom());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelPracticeRunResponse)) {
            return false;
        }
        CancelPracticeRunResponse other = (CancelPracticeRunResponse) obj;
        return Objects.equals(zonalShiftId(), other.zonalShiftId())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(awayFrom(), other.awayFrom()) && Objects.equals(expiryTime(), other.expiryTime())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelPracticeRunResponse").add("ZonalShiftId", zonalShiftId())
                .add("ResourceIdentifier", resourceIdentifier()).add("AwayFrom", awayFrom()).add("ExpiryTime", expiryTime())
                .add("StartTime", startTime()).add("Status", statusAsString()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "zonalShiftId":
            return Optional.ofNullable(clazz.cast(zonalShiftId()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "awayFrom":
            return Optional.ofNullable(clazz.cast(awayFrom()));
        case "expiryTime":
            return Optional.ofNullable(clazz.cast(expiryTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("zonalShiftId", ZONAL_SHIFT_ID_FIELD);
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("awayFrom", AWAY_FROM_FIELD);
        map.put("expiryTime", EXPIRY_TIME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelPracticeRunResponse, T> g) {
        return obj -> g.apply((CancelPracticeRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcZonalShiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelPracticeRunResponse> {
        /**
         * <p>
         * The identifier of the practice run zonal shift in Amazon Application Recovery Controller that was canceled.
         * </p>
         * 
         * @param zonalShiftId
         *        The identifier of the practice run zonal shift in Amazon Application Recovery Controller that was
         *        canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalShiftId(String zonalShiftId);

        /**
         * <p>
         * The identifier for the resource that you canceled a practice run zonal shift for. The identifier is the
         * Amazon Resource Name (ARN) for the resource.
         * </p>
         * 
         * @param resourceIdentifier
         *        The identifier for the resource that you canceled a practice run zonal shift for. The identifier is
         *        the Amazon Resource Name (ARN) for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The Availability Zone (for example, <code>use1-az1</code>) that traffic was moved away from for a resource
         * that you specified for the practice run.
         * </p>
         * 
         * @param awayFrom
         *        The Availability Zone (for example, <code>use1-az1</code>) that traffic was moved away from for a
         *        resource that you specified for the practice run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awayFrom(String awayFrom);

        /**
         * <p>
         * The expiry time (expiration time) for an on-demand practice run zonal shift is 30 minutes from the time when
         * you start the practice run, unless you cancel it before that time. However, be aware that the
         * <code>expiryTime</code> field for practice run zonal shifts always has a value of 1 minute.
         * </p>
         * 
         * @param expiryTime
         *        The expiry time (expiration time) for an on-demand practice run zonal shift is 30 minutes from the
         *        time when you start the practice run, unless you cancel it before that time. However, be aware that
         *        the <code>expiryTime</code> field for practice run zonal shifts always has a value of 1 minute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTime(Instant expiryTime);

        /**
         * <p>
         * The time (UTC) when the zonal shift starts.
         * </p>
         * 
         * @param startTime
         *        The time (UTC) when the zonal shift starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * A status for the practice run that you canceled (expected status is <b>CANCELED</b>).
         * </p>
         * <p>
         * The <code>Status</code> for a practice run zonal shift can have one of the following values:
         * </p>
         * 
         * @param status
         *        A status for the practice run that you canceled (expected status is <b>CANCELED</b>).</p>
         *        <p>
         *        The <code>Status</code> for a practice run zonal shift can have one of the following values:
         * @see ZonalShiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalShiftStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status for the practice run that you canceled (expected status is <b>CANCELED</b>).
         * </p>
         * <p>
         * The <code>Status</code> for a practice run zonal shift can have one of the following values:
         * </p>
         * 
         * @param status
         *        A status for the practice run that you canceled (expected status is <b>CANCELED</b>).</p>
         *        <p>
         *        The <code>Status</code> for a practice run zonal shift can have one of the following values:
         * @see ZonalShiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalShiftStatus
         */
        Builder status(ZonalShiftStatus status);

        /**
         * <p>
         * The initial comment that you entered about the practice run. Be aware that this comment can be overwritten by
         * Amazon Web Services if the automatic check for balanced capacity fails. For more information, see <a href=
         * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html">
         * Capacity checks for practice runs</a> in the Amazon Application Recovery Controller Developer Guide.
         * </p>
         * 
         * @param comment
         *        The initial comment that you entered about the practice run. Be aware that this comment can be
         *        overwritten by Amazon Web Services if the automatic check for balanced capacity fails. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html"
         *        > Capacity checks for practice runs</a> in the Amazon Application Recovery Controller Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl extends ArcZonalShiftResponse.BuilderImpl implements Builder {
        private String zonalShiftId;

        private String resourceIdentifier;

        private String awayFrom;

        private Instant expiryTime;

        private Instant startTime;

        private String status;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelPracticeRunResponse model) {
            super(model);
            zonalShiftId(model.zonalShiftId);
            resourceIdentifier(model.resourceIdentifier);
            awayFrom(model.awayFrom);
            expiryTime(model.expiryTime);
            startTime(model.startTime);
            status(model.status);
            comment(model.comment);
        }

        public final String getZonalShiftId() {
            return zonalShiftId;
        }

        public final void setZonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
        }

        @Override
        public final Builder zonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getAwayFrom() {
            return awayFrom;
        }

        public final void setAwayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
        }

        @Override
        public final Builder awayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
            return this;
        }

        public final Instant getExpiryTime() {
            return expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ZonalShiftStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public CancelPracticeRunResponse build() {
            return new CancelPracticeRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
