/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelZonalShiftResponse extends ArcZonalShiftResponse implements
        ToCopyableBuilder<CancelZonalShiftResponse.Builder, CancelZonalShiftResponse> {
    private static final SdkField<String> ZONAL_SHIFT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("zonalShiftId").getter(getter(CancelZonalShiftResponse::zonalShiftId))
            .setter(setter(Builder::zonalShiftId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShiftId").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(CancelZonalShiftResponse::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final SdkField<String> AWAY_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awayFrom").getter(getter(CancelZonalShiftResponse::awayFrom)).setter(setter(Builder::awayFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awayFrom").build()).build();

    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiryTime").getter(getter(CancelZonalShiftResponse::expiryTime)).setter(setter(Builder::expiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiryTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(CancelZonalShiftResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CancelZonalShiftResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(CancelZonalShiftResponse::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONAL_SHIFT_ID_FIELD,
            RESOURCE_IDENTIFIER_FIELD, AWAY_FROM_FIELD, EXPIRY_TIME_FIELD, START_TIME_FIELD, STATUS_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String zonalShiftId;

    private final String resourceIdentifier;

    private final String awayFrom;

    private final Instant expiryTime;

    private final Instant startTime;

    private final String status;

    private final String comment;

    private CancelZonalShiftResponse(BuilderImpl builder) {
        super(builder);
        this.zonalShiftId = builder.zonalShiftId;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.awayFrom = builder.awayFrom;
        this.expiryTime = builder.expiryTime;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The identifier of a zonal shift.
     * </p>
     * 
     * @return The identifier of a zonal shift.
     */
    public final String zonalShiftId() {
        return zonalShiftId;
    }

    /**
     * <p>
     * The identifier for the resource that Amazon Web Services shifts traffic for. The identifier is the Amazon
     * Resource Name (ARN) for the resource.
     * </p>
     * <p>
     * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and
     * zonal autoshift:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html"
     * >Amazon EC2 Auto Scaling groups</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html">Amazon
     * Elastic Kubernetes Service</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html"
     * >Application Load Balancer</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html"
     * >Network Load Balancer</a>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the resource that Amazon Web Services shifts traffic for. The identifier is the Amazon
     *         Resource Name (ARN) for the resource.</p>
     *         <p>
     *         Amazon Application Recovery Controller currently supports enabling the following resources for zonal
     *         shift and zonal autoshift:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html"
     *         >Amazon EC2 Auto Scaling groups</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html">Amazon
     *         Elastic Kubernetes Service</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html"
     *         >Application Load Balancer</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html"
     *         >Network Load Balancer</a>
     *         </p>
     *         </li>
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The Availability Zone (for example, <code>use1-az1</code>) that traffic is moved away from for a resource when
     * you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead
     * moved to other Availability Zones in the Amazon Web Services Region.
     * </p>
     * 
     * @return The Availability Zone (for example, <code>use1-az1</code>) that traffic is moved away from for a resource
     *         when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is
     *         instead moved to other Availability Zones in the Amazon Web Services Region.
     */
    public final String awayFrom() {
        return awayFrom;
    }

    /**
     * <p>
     * The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and must be
     * set to expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of three
     * days (72 hours). However, you can update a zonal shift to set a new expiration at any time.
     * </p>
     * <p>
     * When you start a zonal shift, you specify how long you want it to be active, which ARC converts to an expiry time
     * (expiration time). You can cancel a zonal shift when you're ready to restore traffic to the Availability Zone, or
     * just wait for it to expire. Or you can update the zonal shift to specify another length of time to expire in.
     * </p>
     * 
     * @return The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and
     *         must be set to expire when you start the zonal shift. You can initially set a zonal shift to expire in a
     *         maximum of three days (72 hours). However, you can update a zonal shift to set a new expiration at any
     *         time. </p>
     *         <p>
     *         When you start a zonal shift, you specify how long you want it to be active, which ARC converts to an
     *         expiry time (expiration time). You can cancel a zonal shift when you're ready to restore traffic to the
     *         Availability Zone, or just wait for it to expire. Or you can update the zonal shift to specify another
     *         length of time to expire in.
     */
    public final Instant expiryTime() {
        return expiryTime;
    }

    /**
     * <p>
     * The time (UTC) when the zonal shift starts.
     * </p>
     * 
     * @return The time (UTC) when the zonal shift starts.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * A status for a zonal shift.
     * </p>
     * <p>
     * The <code>Status</code> for a zonal shift can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ACTIVE:</b> The zonal shift has been started and is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EXPIRED:</b> The zonal shift has expired (the expiry time was exceeded).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CANCELED:</b> The zonal shift was canceled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ZonalShiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status for a zonal shift.</p>
     *         <p>
     *         The <code>Status</code> for a zonal shift can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ACTIVE:</b> The zonal shift has been started and is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EXPIRED:</b> The zonal shift has expired (the expiry time was exceeded).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CANCELED:</b> The zonal shift was canceled.
     *         </p>
     *         </li>
     * @see ZonalShiftStatus
     */
    public final ZonalShiftStatus status() {
        return ZonalShiftStatus.fromValue(status);
    }

    /**
     * <p>
     * A status for a zonal shift.
     * </p>
     * <p>
     * The <code>Status</code> for a zonal shift can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ACTIVE:</b> The zonal shift has been started and is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EXPIRED:</b> The zonal shift has expired (the expiry time was exceeded).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CANCELED:</b> The zonal shift was canceled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ZonalShiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status for a zonal shift.</p>
     *         <p>
     *         The <code>Status</code> for a zonal shift can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ACTIVE:</b> The zonal shift has been started and is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EXPIRED:</b> The zonal shift has expired (the expiry time was exceeded).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CANCELED:</b> The zonal shift was canceled.
     *         </p>
     *         </li>
     * @see ZonalShiftStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is
     * maintained. A new comment overwrites any existing comment string.
     * </p>
     * 
     * @return A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history
     *         is maintained. A new comment overwrites any existing comment string.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(zonalShiftId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(awayFrom());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelZonalShiftResponse)) {
            return false;
        }
        CancelZonalShiftResponse other = (CancelZonalShiftResponse) obj;
        return Objects.equals(zonalShiftId(), other.zonalShiftId())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(awayFrom(), other.awayFrom()) && Objects.equals(expiryTime(), other.expiryTime())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelZonalShiftResponse").add("ZonalShiftId", zonalShiftId())
                .add("ResourceIdentifier", resourceIdentifier()).add("AwayFrom", awayFrom()).add("ExpiryTime", expiryTime())
                .add("StartTime", startTime()).add("Status", statusAsString()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "zonalShiftId":
            return Optional.ofNullable(clazz.cast(zonalShiftId()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "awayFrom":
            return Optional.ofNullable(clazz.cast(awayFrom()));
        case "expiryTime":
            return Optional.ofNullable(clazz.cast(expiryTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("zonalShiftId", ZONAL_SHIFT_ID_FIELD);
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("awayFrom", AWAY_FROM_FIELD);
        map.put("expiryTime", EXPIRY_TIME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelZonalShiftResponse, T> g) {
        return obj -> g.apply((CancelZonalShiftResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcZonalShiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelZonalShiftResponse> {
        /**
         * <p>
         * The identifier of a zonal shift.
         * </p>
         * 
         * @param zonalShiftId
         *        The identifier of a zonal shift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalShiftId(String zonalShiftId);

        /**
         * <p>
         * The identifier for the resource that Amazon Web Services shifts traffic for. The identifier is the Amazon
         * Resource Name (ARN) for the resource.
         * </p>
         * <p>
         * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift
         * and zonal autoshift:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html"
         * >Amazon EC2 Auto Scaling groups</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html">Amazon
         * Elastic Kubernetes Service</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html"
         * >Application Load Balancer</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html"
         * >Network Load Balancer</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceIdentifier
         *        The identifier for the resource that Amazon Web Services shifts traffic for. The identifier is the
         *        Amazon Resource Name (ARN) for the resource.</p>
         *        <p>
         *        Amazon Application Recovery Controller currently supports enabling the following resources for zonal
         *        shift and zonal autoshift:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html"
         *        >Amazon EC2 Auto Scaling groups</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html">
         *        Amazon Elastic Kubernetes Service</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html"
         *        >Application Load Balancer</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html"
         *        >Network Load Balancer</a>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The Availability Zone (for example, <code>use1-az1</code>) that traffic is moved away from for a resource
         * when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is
         * instead moved to other Availability Zones in the Amazon Web Services Region.
         * </p>
         * 
         * @param awayFrom
         *        The Availability Zone (for example, <code>use1-az1</code>) that traffic is moved away from for a
         *        resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the
         *        resource is instead moved to other Availability Zones in the Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awayFrom(String awayFrom);

        /**
         * <p>
         * The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and must
         * be set to expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum
         * of three days (72 hours). However, you can update a zonal shift to set a new expiration at any time.
         * </p>
         * <p>
         * When you start a zonal shift, you specify how long you want it to be active, which ARC converts to an expiry
         * time (expiration time). You can cancel a zonal shift when you're ready to restore traffic to the Availability
         * Zone, or just wait for it to expire. Or you can update the zonal shift to specify another length of time to
         * expire in.
         * </p>
         * 
         * @param expiryTime
         *        The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and
         *        must be set to expire when you start the zonal shift. You can initially set a zonal shift to expire in
         *        a maximum of three days (72 hours). However, you can update a zonal shift to set a new expiration at
         *        any time. </p>
         *        <p>
         *        When you start a zonal shift, you specify how long you want it to be active, which ARC converts to an
         *        expiry time (expiration time). You can cancel a zonal shift when you're ready to restore traffic to
         *        the Availability Zone, or just wait for it to expire. Or you can update the zonal shift to specify
         *        another length of time to expire in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTime(Instant expiryTime);

        /**
         * <p>
         * The time (UTC) when the zonal shift starts.
         * </p>
         * 
         * @param startTime
         *        The time (UTC) when the zonal shift starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * A status for a zonal shift.
         * </p>
         * <p>
         * The <code>Status</code> for a zonal shift can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ACTIVE:</b> The zonal shift has been started and is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EXPIRED:</b> The zonal shift has expired (the expiry time was exceeded).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CANCELED:</b> The zonal shift was canceled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A status for a zonal shift.</p>
         *        <p>
         *        The <code>Status</code> for a zonal shift can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ACTIVE:</b> The zonal shift has been started and is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EXPIRED:</b> The zonal shift has expired (the expiry time was exceeded).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CANCELED:</b> The zonal shift was canceled.
         *        </p>
         *        </li>
         * @see ZonalShiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalShiftStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status for a zonal shift.
         * </p>
         * <p>
         * The <code>Status</code> for a zonal shift can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ACTIVE:</b> The zonal shift has been started and is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EXPIRED:</b> The zonal shift has expired (the expiry time was exceeded).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CANCELED:</b> The zonal shift was canceled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A status for a zonal shift.</p>
         *        <p>
         *        The <code>Status</code> for a zonal shift can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ACTIVE:</b> The zonal shift has been started and is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EXPIRED:</b> The zonal shift has expired (the expiry time was exceeded).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CANCELED:</b> The zonal shift was canceled.
         *        </p>
         *        </li>
         * @see ZonalShiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalShiftStatus
         */
        Builder status(ZonalShiftStatus status);

        /**
         * <p>
         * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is
         * maintained. A new comment overwrites any existing comment string.
         * </p>
         * 
         * @param comment
         *        A comment that you enter about the zonal shift. Only the latest comment is retained; no comment
         *        history is maintained. A new comment overwrites any existing comment string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl extends ArcZonalShiftResponse.BuilderImpl implements Builder {
        private String zonalShiftId;

        private String resourceIdentifier;

        private String awayFrom;

        private Instant expiryTime;

        private Instant startTime;

        private String status;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelZonalShiftResponse model) {
            super(model);
            zonalShiftId(model.zonalShiftId);
            resourceIdentifier(model.resourceIdentifier);
            awayFrom(model.awayFrom);
            expiryTime(model.expiryTime);
            startTime(model.startTime);
            status(model.status);
            comment(model.comment);
        }

        public final String getZonalShiftId() {
            return zonalShiftId;
        }

        public final void setZonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
        }

        @Override
        public final Builder zonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getAwayFrom() {
            return awayFrom;
        }

        public final void setAwayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
        }

        @Override
        public final Builder awayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
            return this;
        }

        public final Instant getExpiryTime() {
            return expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ZonalShiftStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public CancelZonalShiftResponse build() {
            return new CancelZonalShiftResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
