/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePracticeRunConfigurationRequest extends ArcZonalShiftRequest implements
        ToCopyableBuilder<CreatePracticeRunConfigurationRequest.Builder, CreatePracticeRunConfigurationRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(CreatePracticeRunConfigurationRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final SdkField<List<String>> BLOCKED_WINDOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedWindows")
            .getter(getter(CreatePracticeRunConfigurationRequest::blockedWindows))
            .setter(setter(Builder::blockedWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BLOCKED_DATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedDates")
            .getter(getter(CreatePracticeRunConfigurationRequest::blockedDates))
            .setter(setter(Builder::blockedDates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedDates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ControlCondition>> BLOCKING_ALARMS_FIELD = SdkField
            .<List<ControlCondition>> builder(MarshallingType.LIST)
            .memberName("blockingAlarms")
            .getter(getter(CreatePracticeRunConfigurationRequest::blockingAlarms))
            .setter(setter(Builder::blockingAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockingAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_WINDOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedWindows")
            .getter(getter(CreatePracticeRunConfigurationRequest::allowedWindows))
            .setter(setter(Builder::allowedWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ControlCondition>> OUTCOME_ALARMS_FIELD = SdkField
            .<List<ControlCondition>> builder(MarshallingType.LIST)
            .memberName("outcomeAlarms")
            .getter(getter(CreatePracticeRunConfigurationRequest::outcomeAlarms))
            .setter(setter(Builder::outcomeAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomeAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD,
            BLOCKED_WINDOWS_FIELD, BLOCKED_DATES_FIELD, BLOCKING_ALARMS_FIELD, ALLOWED_WINDOWS_FIELD, OUTCOME_ALARMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceIdentifier;

    private final List<String> blockedWindows;

    private final List<String> blockedDates;

    private final List<ControlCondition> blockingAlarms;

    private final List<String> allowedWindows;

    private final List<ControlCondition> outcomeAlarms;

    private CreatePracticeRunConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.blockedWindows = builder.blockedWindows;
        this.blockedDates = builder.blockedDates;
        this.blockingAlarms = builder.blockingAlarms;
        this.allowedWindows = builder.allowedWindows;
        this.outcomeAlarms = builder.outcomeAlarms;
    }

    /**
     * <p>
     * The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal shift. The
     * identifier is the Amazon Resource Name (ARN) for the resource.
     * </p>
     * <p>
     * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and
     * zonal autoshift:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html"
     * >Amazon EC2 Auto Scaling groups</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html">Amazon
     * Elastic Kubernetes Service</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html"
     * >Application Load Balancer</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html"
     * >Network Load Balancer</a>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal
     *         shift. The identifier is the Amazon Resource Name (ARN) for the resource.</p>
     *         <p>
     *         Amazon Application Recovery Controller currently supports enabling the following resources for zonal
     *         shift and zonal autoshift:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html"
     *         >Amazon EC2 Auto Scaling groups</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html">Amazon
     *         Elastic Kubernetes Service</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html"
     *         >Application Load Balancer</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html"
     *         >Network Load Balancer</a>
     *         </p>
     *         </li>
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedWindows property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockedWindows() {
        return blockedWindows != null && !(blockedWindows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optionally, you can block ARC from starting practice runs for specific windows of days and times.
     * </p>
     * <p>
     * The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and
     * times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for
     * daylight saving time differences. Separate multiple blocked windows with spaces.
     * </p>
     * <p>
     * For example, say you run business report summaries three days a week. For this scenario, you could set the
     * following recurring days and times as blocked windows, for example:
     * <code>Mon:00:00-Mon:10:00 Wed-20:30-Wed:21:30 Fri-20:30-Fri:21:30</code>.
     * </p>
     * <important>
     * <p>
     * The <code>blockedWindows</code> have to start and end on the same day. Windows that span multiple days aren't
     * supported.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedWindows} method.
     * </p>
     * 
     * @return Optionally, you can block ARC from starting practice runs for specific windows of days and times. </p>
     *         <p>
     *         The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates
     *         and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be
     *         required for daylight saving time differences. Separate multiple blocked windows with spaces.
     *         </p>
     *         <p>
     *         For example, say you run business report summaries three days a week. For this scenario, you could set
     *         the following recurring days and times as blocked windows, for example:
     *         <code>Mon:00:00-Mon:10:00 Wed-20:30-Wed:21:30 Fri-20:30-Fri:21:30</code>.
     *         </p>
     *         <important>
     *         <p>
     *         The <code>blockedWindows</code> have to start and end on the same day. Windows that span multiple days
     *         aren't supported.
     *         </p>
     */
    public final List<String> blockedWindows() {
        return blockedWindows;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedDates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockedDates() {
        return blockedDates != null && !(blockedDates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optionally, you can block ARC from starting practice runs for a resource on specific calendar dates.
     * </p>
     * <p>
     * The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for
     * practice runs are in UTC. Separate multiple blocked dates with spaces.
     * </p>
     * <p>
     * For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want practice
     * runs to shift traffic away at that time, you could set a blocked date for <code>2024-05-01</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedDates} method.
     * </p>
     * 
     * @return Optionally, you can block ARC from starting practice runs for a resource on specific calendar dates.</p>
     *         <p>
     *         The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times
     *         for practice runs are in UTC. Separate multiple blocked dates with spaces.
     *         </p>
     *         <p>
     *         For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want
     *         practice runs to shift traffic away at that time, you could set a blocked date for
     *         <code>2024-05-01</code>.
     */
    public final List<String> blockedDates() {
        return blockedDates;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockingAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockingAlarms() {
        return blockingAlarms != null && !(blockingAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <i>Blocking alarms</i> for practice runs are optional alarms that you can specify that block practice runs when
     * one or more of the alarms is in an <code>ALARM</code> state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockingAlarms} method.
     * </p>
     * 
     * @return <i>Blocking alarms</i> for practice runs are optional alarms that you can specify that block practice
     *         runs when one or more of the alarms is in an <code>ALARM</code> state.
     */
    public final List<ControlCondition> blockingAlarms() {
        return blockingAlarms;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedWindows property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedWindows() {
        return allowedWindows != null && !(allowedWindows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optionally, you can allow ARC to start practice runs for specific windows of days and times.
     * </p>
     * <p>
     * The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and
     * times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for
     * daylight saving time differences. Separate multiple allowed windows with spaces.
     * </p>
     * <p>
     * For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m. For this
     * scenario, you could set the following recurring days and times as allowed windows, for example:
     * <code>Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00</code>.
     * </p>
     * <important>
     * <p>
     * The <code>allowedWindows</code> have to start and end on the same day. Windows that span multiple days aren't
     * supported.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedWindows} method.
     * </p>
     * 
     * @return Optionally, you can allow ARC to start practice runs for specific windows of days and times. </p>
     *         <p>
     *         The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates
     *         and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be
     *         required for daylight saving time differences. Separate multiple allowed windows with spaces.
     *         </p>
     *         <p>
     *         For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m. For
     *         this scenario, you could set the following recurring days and times as allowed windows, for example:
     *         <code>Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00</code>.
     *         </p>
     *         <important>
     *         <p>
     *         The <code>allowedWindows</code> have to start and end on the same day. Windows that span multiple days
     *         aren't supported.
     *         </p>
     */
    public final List<String> allowedWindows() {
        return allowedWindows;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutcomeAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutcomeAlarms() {
        return outcomeAlarms != null && !(outcomeAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <i>Outcome alarms</i> for practice runs are alarms that you specify that end a practice run when one or more of
     * the alarms is in an <code>ALARM</code> state.
     * </p>
     * <p>
     * Configure one or more of these alarms to monitor the health of your application when traffic is shifted away from
     * an Availability Zone during each practice run. You should configure these alarms to go into an <code>ALARM</code>
     * state if you want to stop a zonal shift, to let traffic for the resource return to the original Availability
     * Zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutcomeAlarms} method.
     * </p>
     * 
     * @return <i>Outcome alarms</i> for practice runs are alarms that you specify that end a practice run when one or
     *         more of the alarms is in an <code>ALARM</code> state.</p>
     *         <p>
     *         Configure one or more of these alarms to monitor the health of your application when traffic is shifted
     *         away from an Availability Zone during each practice run. You should configure these alarms to go into an
     *         <code>ALARM</code> state if you want to stop a zonal shift, to let traffic for the resource return to the
     *         original Availability Zone.
     */
    public final List<ControlCondition> outcomeAlarms() {
        return outcomeAlarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedWindows() ? blockedWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedDates() ? blockedDates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockingAlarms() ? blockingAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedWindows() ? allowedWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutcomeAlarms() ? outcomeAlarms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePracticeRunConfigurationRequest)) {
            return false;
        }
        CreatePracticeRunConfigurationRequest other = (CreatePracticeRunConfigurationRequest) obj;
        return Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && hasBlockedWindows() == other.hasBlockedWindows() && Objects.equals(blockedWindows(), other.blockedWindows())
                && hasBlockedDates() == other.hasBlockedDates() && Objects.equals(blockedDates(), other.blockedDates())
                && hasBlockingAlarms() == other.hasBlockingAlarms() && Objects.equals(blockingAlarms(), other.blockingAlarms())
                && hasAllowedWindows() == other.hasAllowedWindows() && Objects.equals(allowedWindows(), other.allowedWindows())
                && hasOutcomeAlarms() == other.hasOutcomeAlarms() && Objects.equals(outcomeAlarms(), other.outcomeAlarms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePracticeRunConfigurationRequest").add("ResourceIdentifier", resourceIdentifier())
                .add("BlockedWindows", hasBlockedWindows() ? blockedWindows() : null)
                .add("BlockedDates", hasBlockedDates() ? blockedDates() : null)
                .add("BlockingAlarms", hasBlockingAlarms() ? blockingAlarms() : null)
                .add("AllowedWindows", hasAllowedWindows() ? allowedWindows() : null)
                .add("OutcomeAlarms", hasOutcomeAlarms() ? outcomeAlarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "blockedWindows":
            return Optional.ofNullable(clazz.cast(blockedWindows()));
        case "blockedDates":
            return Optional.ofNullable(clazz.cast(blockedDates()));
        case "blockingAlarms":
            return Optional.ofNullable(clazz.cast(blockingAlarms()));
        case "allowedWindows":
            return Optional.ofNullable(clazz.cast(allowedWindows()));
        case "outcomeAlarms":
            return Optional.ofNullable(clazz.cast(outcomeAlarms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("blockedWindows", BLOCKED_WINDOWS_FIELD);
        map.put("blockedDates", BLOCKED_DATES_FIELD);
        map.put("blockingAlarms", BLOCKING_ALARMS_FIELD);
        map.put("allowedWindows", ALLOWED_WINDOWS_FIELD);
        map.put("outcomeAlarms", OUTCOME_ALARMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePracticeRunConfigurationRequest, T> g) {
        return obj -> g.apply((CreatePracticeRunConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcZonalShiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePracticeRunConfigurationRequest> {
        /**
         * <p>
         * The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal shift.
         * The identifier is the Amazon Resource Name (ARN) for the resource.
         * </p>
         * <p>
         * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift
         * and zonal autoshift:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html"
         * >Amazon EC2 Auto Scaling groups</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html">Amazon
         * Elastic Kubernetes Service</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html"
         * >Application Load Balancer</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html"
         * >Network Load Balancer</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceIdentifier
         *        The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal
         *        shift. The identifier is the Amazon Resource Name (ARN) for the resource.</p>
         *        <p>
         *        Amazon Application Recovery Controller currently supports enabling the following resources for zonal
         *        shift and zonal autoshift:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html"
         *        >Amazon EC2 Auto Scaling groups</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html">
         *        Amazon Elastic Kubernetes Service</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html"
         *        >Application Load Balancer</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html"
         *        >Network Load Balancer</a>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * Optionally, you can block ARC from starting practice runs for specific windows of days and times.
         * </p>
         * <p>
         * The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and
         * times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for
         * daylight saving time differences. Separate multiple blocked windows with spaces.
         * </p>
         * <p>
         * For example, say you run business report summaries three days a week. For this scenario, you could set the
         * following recurring days and times as blocked windows, for example:
         * <code>Mon:00:00-Mon:10:00 Wed-20:30-Wed:21:30 Fri-20:30-Fri:21:30</code>.
         * </p>
         * <important>
         * <p>
         * The <code>blockedWindows</code> have to start and end on the same day. Windows that span multiple days aren't
         * supported.
         * </p>
         * </important>
         * 
         * @param blockedWindows
         *        Optionally, you can block ARC from starting practice runs for specific windows of days and times. </p>
         *        <p>
         *        The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that
         *        dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might
         *        be required for daylight saving time differences. Separate multiple blocked windows with spaces.
         *        </p>
         *        <p>
         *        For example, say you run business report summaries three days a week. For this scenario, you could set
         *        the following recurring days and times as blocked windows, for example:
         *        <code>Mon:00:00-Mon:10:00 Wed-20:30-Wed:21:30 Fri-20:30-Fri:21:30</code>.
         *        </p>
         *        <important>
         *        <p>
         *        The <code>blockedWindows</code> have to start and end on the same day. Windows that span multiple days
         *        aren't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedWindows(Collection<String> blockedWindows);

        /**
         * <p>
         * Optionally, you can block ARC from starting practice runs for specific windows of days and times.
         * </p>
         * <p>
         * The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and
         * times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for
         * daylight saving time differences. Separate multiple blocked windows with spaces.
         * </p>
         * <p>
         * For example, say you run business report summaries three days a week. For this scenario, you could set the
         * following recurring days and times as blocked windows, for example:
         * <code>Mon:00:00-Mon:10:00 Wed-20:30-Wed:21:30 Fri-20:30-Fri:21:30</code>.
         * </p>
         * <important>
         * <p>
         * The <code>blockedWindows</code> have to start and end on the same day. Windows that span multiple days aren't
         * supported.
         * </p>
         * </important>
         * 
         * @param blockedWindows
         *        Optionally, you can block ARC from starting practice runs for specific windows of days and times. </p>
         *        <p>
         *        The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that
         *        dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might
         *        be required for daylight saving time differences. Separate multiple blocked windows with spaces.
         *        </p>
         *        <p>
         *        For example, say you run business report summaries three days a week. For this scenario, you could set
         *        the following recurring days and times as blocked windows, for example:
         *        <code>Mon:00:00-Mon:10:00 Wed-20:30-Wed:21:30 Fri-20:30-Fri:21:30</code>.
         *        </p>
         *        <important>
         *        <p>
         *        The <code>blockedWindows</code> have to start and end on the same day. Windows that span multiple days
         *        aren't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedWindows(String... blockedWindows);

        /**
         * <p>
         * Optionally, you can block ARC from starting practice runs for a resource on specific calendar dates.
         * </p>
         * <p>
         * The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for
         * practice runs are in UTC. Separate multiple blocked dates with spaces.
         * </p>
         * <p>
         * For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want
         * practice runs to shift traffic away at that time, you could set a blocked date for <code>2024-05-01</code>.
         * </p>
         * 
         * @param blockedDates
         *        Optionally, you can block ARC from starting practice runs for a resource on specific calendar
         *        dates.</p>
         *        <p>
         *        The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and
         *        times for practice runs are in UTC. Separate multiple blocked dates with spaces.
         *        </p>
         *        <p>
         *        For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want
         *        practice runs to shift traffic away at that time, you could set a blocked date for
         *        <code>2024-05-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedDates(Collection<String> blockedDates);

        /**
         * <p>
         * Optionally, you can block ARC from starting practice runs for a resource on specific calendar dates.
         * </p>
         * <p>
         * The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for
         * practice runs are in UTC. Separate multiple blocked dates with spaces.
         * </p>
         * <p>
         * For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want
         * practice runs to shift traffic away at that time, you could set a blocked date for <code>2024-05-01</code>.
         * </p>
         * 
         * @param blockedDates
         *        Optionally, you can block ARC from starting practice runs for a resource on specific calendar
         *        dates.</p>
         *        <p>
         *        The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and
         *        times for practice runs are in UTC. Separate multiple blocked dates with spaces.
         *        </p>
         *        <p>
         *        For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want
         *        practice runs to shift traffic away at that time, you could set a blocked date for
         *        <code>2024-05-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedDates(String... blockedDates);

        /**
         * <p>
         * <i>Blocking alarms</i> for practice runs are optional alarms that you can specify that block practice runs
         * when one or more of the alarms is in an <code>ALARM</code> state.
         * </p>
         * 
         * @param blockingAlarms
         *        <i>Blocking alarms</i> for practice runs are optional alarms that you can specify that block practice
         *        runs when one or more of the alarms is in an <code>ALARM</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockingAlarms(Collection<ControlCondition> blockingAlarms);

        /**
         * <p>
         * <i>Blocking alarms</i> for practice runs are optional alarms that you can specify that block practice runs
         * when one or more of the alarms is in an <code>ALARM</code> state.
         * </p>
         * 
         * @param blockingAlarms
         *        <i>Blocking alarms</i> for practice runs are optional alarms that you can specify that block practice
         *        runs when one or more of the alarms is in an <code>ALARM</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockingAlarms(ControlCondition... blockingAlarms);

        /**
         * <p>
         * <i>Blocking alarms</i> for practice runs are optional alarms that you can specify that block practice runs
         * when one or more of the alarms is in an <code>ALARM</code> state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #blockingAlarms(List<ControlCondition>)}.
         * 
         * @param blockingAlarms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockingAlarms(java.util.Collection<ControlCondition>)
         */
        Builder blockingAlarms(Consumer<ControlCondition.Builder>... blockingAlarms);

        /**
         * <p>
         * Optionally, you can allow ARC to start practice runs for specific windows of days and times.
         * </p>
         * <p>
         * The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and
         * times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for
         * daylight saving time differences. Separate multiple allowed windows with spaces.
         * </p>
         * <p>
         * For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m. For this
         * scenario, you could set the following recurring days and times as allowed windows, for example:
         * <code>Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00</code>.
         * </p>
         * <important>
         * <p>
         * The <code>allowedWindows</code> have to start and end on the same day. Windows that span multiple days aren't
         * supported.
         * </p>
         * </important>
         * 
         * @param allowedWindows
         *        Optionally, you can allow ARC to start practice runs for specific windows of days and times. </p>
         *        <p>
         *        The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that
         *        dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might
         *        be required for daylight saving time differences. Separate multiple allowed windows with spaces.
         *        </p>
         *        <p>
         *        For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m.
         *        For this scenario, you could set the following recurring days and times as allowed windows, for
         *        example: <code>Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00</code>.
         *        </p>
         *        <important>
         *        <p>
         *        The <code>allowedWindows</code> have to start and end on the same day. Windows that span multiple days
         *        aren't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedWindows(Collection<String> allowedWindows);

        /**
         * <p>
         * Optionally, you can allow ARC to start practice runs for specific windows of days and times.
         * </p>
         * <p>
         * The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and
         * times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for
         * daylight saving time differences. Separate multiple allowed windows with spaces.
         * </p>
         * <p>
         * For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m. For this
         * scenario, you could set the following recurring days and times as allowed windows, for example:
         * <code>Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00</code>.
         * </p>
         * <important>
         * <p>
         * The <code>allowedWindows</code> have to start and end on the same day. Windows that span multiple days aren't
         * supported.
         * </p>
         * </important>
         * 
         * @param allowedWindows
         *        Optionally, you can allow ARC to start practice runs for specific windows of days and times. </p>
         *        <p>
         *        The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that
         *        dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might
         *        be required for daylight saving time differences. Separate multiple allowed windows with spaces.
         *        </p>
         *        <p>
         *        For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m.
         *        For this scenario, you could set the following recurring days and times as allowed windows, for
         *        example: <code>Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00</code>.
         *        </p>
         *        <important>
         *        <p>
         *        The <code>allowedWindows</code> have to start and end on the same day. Windows that span multiple days
         *        aren't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedWindows(String... allowedWindows);

        /**
         * <p>
         * <i>Outcome alarms</i> for practice runs are alarms that you specify that end a practice run when one or more
         * of the alarms is in an <code>ALARM</code> state.
         * </p>
         * <p>
         * Configure one or more of these alarms to monitor the health of your application when traffic is shifted away
         * from an Availability Zone during each practice run. You should configure these alarms to go into an
         * <code>ALARM</code> state if you want to stop a zonal shift, to let traffic for the resource return to the
         * original Availability Zone.
         * </p>
         * 
         * @param outcomeAlarms
         *        <i>Outcome alarms</i> for practice runs are alarms that you specify that end a practice run when one
         *        or more of the alarms is in an <code>ALARM</code> state.</p>
         *        <p>
         *        Configure one or more of these alarms to monitor the health of your application when traffic is
         *        shifted away from an Availability Zone during each practice run. You should configure these alarms to
         *        go into an <code>ALARM</code> state if you want to stop a zonal shift, to let traffic for the resource
         *        return to the original Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomeAlarms(Collection<ControlCondition> outcomeAlarms);

        /**
         * <p>
         * <i>Outcome alarms</i> for practice runs are alarms that you specify that end a practice run when one or more
         * of the alarms is in an <code>ALARM</code> state.
         * </p>
         * <p>
         * Configure one or more of these alarms to monitor the health of your application when traffic is shifted away
         * from an Availability Zone during each practice run. You should configure these alarms to go into an
         * <code>ALARM</code> state if you want to stop a zonal shift, to let traffic for the resource return to the
         * original Availability Zone.
         * </p>
         * 
         * @param outcomeAlarms
         *        <i>Outcome alarms</i> for practice runs are alarms that you specify that end a practice run when one
         *        or more of the alarms is in an <code>ALARM</code> state.</p>
         *        <p>
         *        Configure one or more of these alarms to monitor the health of your application when traffic is
         *        shifted away from an Availability Zone during each practice run. You should configure these alarms to
         *        go into an <code>ALARM</code> state if you want to stop a zonal shift, to let traffic for the resource
         *        return to the original Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomeAlarms(ControlCondition... outcomeAlarms);

        /**
         * <p>
         * <i>Outcome alarms</i> for practice runs are alarms that you specify that end a practice run when one or more
         * of the alarms is in an <code>ALARM</code> state.
         * </p>
         * <p>
         * Configure one or more of these alarms to monitor the health of your application when traffic is shifted away
         * from an Availability Zone during each practice run. You should configure these alarms to go into an
         * <code>ALARM</code> state if you want to stop a zonal shift, to let traffic for the resource return to the
         * original Availability Zone.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #outcomeAlarms(List<ControlCondition>)}.
         * 
         * @param outcomeAlarms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outcomeAlarms(java.util.Collection<ControlCondition>)
         */
        Builder outcomeAlarms(Consumer<ControlCondition.Builder>... outcomeAlarms);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcZonalShiftRequest.BuilderImpl implements Builder {
        private String resourceIdentifier;

        private List<String> blockedWindows = DefaultSdkAutoConstructList.getInstance();

        private List<String> blockedDates = DefaultSdkAutoConstructList.getInstance();

        private List<ControlCondition> blockingAlarms = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedWindows = DefaultSdkAutoConstructList.getInstance();

        private List<ControlCondition> outcomeAlarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePracticeRunConfigurationRequest model) {
            super(model);
            resourceIdentifier(model.resourceIdentifier);
            blockedWindows(model.blockedWindows);
            blockedDates(model.blockedDates);
            blockingAlarms(model.blockingAlarms);
            allowedWindows(model.allowedWindows);
            outcomeAlarms(model.outcomeAlarms);
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Collection<String> getBlockedWindows() {
            if (blockedWindows instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedWindows;
        }

        public final void setBlockedWindows(Collection<String> blockedWindows) {
            this.blockedWindows = BlockedWindowsCopier.copy(blockedWindows);
        }

        @Override
        public final Builder blockedWindows(Collection<String> blockedWindows) {
            this.blockedWindows = BlockedWindowsCopier.copy(blockedWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedWindows(String... blockedWindows) {
            blockedWindows(Arrays.asList(blockedWindows));
            return this;
        }

        public final Collection<String> getBlockedDates() {
            if (blockedDates instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedDates;
        }

        public final void setBlockedDates(Collection<String> blockedDates) {
            this.blockedDates = BlockedDatesCopier.copy(blockedDates);
        }

        @Override
        public final Builder blockedDates(Collection<String> blockedDates) {
            this.blockedDates = BlockedDatesCopier.copy(blockedDates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedDates(String... blockedDates) {
            blockedDates(Arrays.asList(blockedDates));
            return this;
        }

        public final List<ControlCondition.Builder> getBlockingAlarms() {
            List<ControlCondition.Builder> result = BlockingAlarmsCopier.copyToBuilder(this.blockingAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockingAlarms(Collection<ControlCondition.BuilderImpl> blockingAlarms) {
            this.blockingAlarms = BlockingAlarmsCopier.copyFromBuilder(blockingAlarms);
        }

        @Override
        public final Builder blockingAlarms(Collection<ControlCondition> blockingAlarms) {
            this.blockingAlarms = BlockingAlarmsCopier.copy(blockingAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingAlarms(ControlCondition... blockingAlarms) {
            blockingAlarms(Arrays.asList(blockingAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingAlarms(Consumer<ControlCondition.Builder>... blockingAlarms) {
            blockingAlarms(Stream.of(blockingAlarms).map(c -> ControlCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAllowedWindows() {
            if (allowedWindows instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedWindows;
        }

        public final void setAllowedWindows(Collection<String> allowedWindows) {
            this.allowedWindows = AllowedWindowsCopier.copy(allowedWindows);
        }

        @Override
        public final Builder allowedWindows(Collection<String> allowedWindows) {
            this.allowedWindows = AllowedWindowsCopier.copy(allowedWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedWindows(String... allowedWindows) {
            allowedWindows(Arrays.asList(allowedWindows));
            return this;
        }

        public final List<ControlCondition.Builder> getOutcomeAlarms() {
            List<ControlCondition.Builder> result = OutcomeAlarmsCopier.copyToBuilder(this.outcomeAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutcomeAlarms(Collection<ControlCondition.BuilderImpl> outcomeAlarms) {
            this.outcomeAlarms = OutcomeAlarmsCopier.copyFromBuilder(outcomeAlarms);
        }

        @Override
        public final Builder outcomeAlarms(Collection<ControlCondition> outcomeAlarms) {
            this.outcomeAlarms = OutcomeAlarmsCopier.copy(outcomeAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomeAlarms(ControlCondition... outcomeAlarms) {
            outcomeAlarms(Arrays.asList(outcomeAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomeAlarms(Consumer<ControlCondition.Builder>... outcomeAlarms) {
            outcomeAlarms(Stream.of(outcomeAlarms).map(c -> ControlCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePracticeRunConfigurationRequest build() {
            return new CreatePracticeRunConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
