/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePracticeRunConfigurationResponse extends ArcZonalShiftResponse implements
        ToCopyableBuilder<UpdatePracticeRunConfigurationResponse.Builder, UpdatePracticeRunConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdatePracticeRunConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdatePracticeRunConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ZONAL_AUTOSHIFT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("zonalAutoshiftStatus")
            .getter(getter(UpdatePracticeRunConfigurationResponse::zonalAutoshiftStatusAsString))
            .setter(setter(Builder::zonalAutoshiftStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalAutoshiftStatus").build())
            .build();

    private static final SdkField<PracticeRunConfiguration> PRACTICE_RUN_CONFIGURATION_FIELD = SdkField
            .<PracticeRunConfiguration> builder(MarshallingType.SDK_POJO).memberName("practiceRunConfiguration")
            .getter(getter(UpdatePracticeRunConfigurationResponse::practiceRunConfiguration))
            .setter(setter(Builder::practiceRunConfiguration)).constructor(PracticeRunConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("practiceRunConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            ZONAL_AUTOSHIFT_STATUS_FIELD, PRACTICE_RUN_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String zonalAutoshiftStatus;

    private final PracticeRunConfiguration practiceRunConfiguration;

    private UpdatePracticeRunConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.zonalAutoshiftStatus = builder.zonalAutoshiftStatus;
        this.practiceRunConfiguration = builder.practiceRunConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource that you updated the practice run for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource that you updated the practice run for.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the resource that you updated the practice run for.
     * </p>
     * 
     * @return The name of the resource that you updated the practice run for.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The zonal autoshift status for the resource that you updated the practice run for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #zonalAutoshiftStatus} will return {@link ZonalAutoshiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #zonalAutoshiftStatusAsString}.
     * </p>
     * 
     * @return The zonal autoshift status for the resource that you updated the practice run for.
     * @see ZonalAutoshiftStatus
     */
    public final ZonalAutoshiftStatus zonalAutoshiftStatus() {
        return ZonalAutoshiftStatus.fromValue(zonalAutoshiftStatus);
    }

    /**
     * <p>
     * The zonal autoshift status for the resource that you updated the practice run for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #zonalAutoshiftStatus} will return {@link ZonalAutoshiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #zonalAutoshiftStatusAsString}.
     * </p>
     * 
     * @return The zonal autoshift status for the resource that you updated the practice run for.
     * @see ZonalAutoshiftStatus
     */
    public final String zonalAutoshiftStatusAsString() {
        return zonalAutoshiftStatus;
    }

    /**
     * <p>
     * The practice run configuration that was updated.
     * </p>
     * 
     * @return The practice run configuration that was updated.
     */
    public final PracticeRunConfiguration practiceRunConfiguration() {
        return practiceRunConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(zonalAutoshiftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(practiceRunConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePracticeRunConfigurationResponse)) {
            return false;
        }
        UpdatePracticeRunConfigurationResponse other = (UpdatePracticeRunConfigurationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(zonalAutoshiftStatusAsString(), other.zonalAutoshiftStatusAsString())
                && Objects.equals(practiceRunConfiguration(), other.practiceRunConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePracticeRunConfigurationResponse").add("Arn", arn()).add("Name", name())
                .add("ZonalAutoshiftStatus", zonalAutoshiftStatusAsString())
                .add("PracticeRunConfiguration", practiceRunConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "zonalAutoshiftStatus":
            return Optional.ofNullable(clazz.cast(zonalAutoshiftStatusAsString()));
        case "practiceRunConfiguration":
            return Optional.ofNullable(clazz.cast(practiceRunConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("zonalAutoshiftStatus", ZONAL_AUTOSHIFT_STATUS_FIELD);
        map.put("practiceRunConfiguration", PRACTICE_RUN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePracticeRunConfigurationResponse, T> g) {
        return obj -> g.apply((UpdatePracticeRunConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcZonalShiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePracticeRunConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource that you updated the practice run for.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource that you updated the practice run for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the resource that you updated the practice run for.
         * </p>
         * 
         * @param name
         *        The name of the resource that you updated the practice run for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The zonal autoshift status for the resource that you updated the practice run for.
         * </p>
         * 
         * @param zonalAutoshiftStatus
         *        The zonal autoshift status for the resource that you updated the practice run for.
         * @see ZonalAutoshiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalAutoshiftStatus
         */
        Builder zonalAutoshiftStatus(String zonalAutoshiftStatus);

        /**
         * <p>
         * The zonal autoshift status for the resource that you updated the practice run for.
         * </p>
         * 
         * @param zonalAutoshiftStatus
         *        The zonal autoshift status for the resource that you updated the practice run for.
         * @see ZonalAutoshiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalAutoshiftStatus
         */
        Builder zonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus);

        /**
         * <p>
         * The practice run configuration that was updated.
         * </p>
         * 
         * @param practiceRunConfiguration
         *        The practice run configuration that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder practiceRunConfiguration(PracticeRunConfiguration practiceRunConfiguration);

        /**
         * <p>
         * The practice run configuration that was updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link PracticeRunConfiguration.Builder}
         * avoiding the need to create one manually via {@link PracticeRunConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PracticeRunConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #practiceRunConfiguration(PracticeRunConfiguration)}.
         * 
         * @param practiceRunConfiguration
         *        a consumer that will call methods on {@link PracticeRunConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #practiceRunConfiguration(PracticeRunConfiguration)
         */
        default Builder practiceRunConfiguration(Consumer<PracticeRunConfiguration.Builder> practiceRunConfiguration) {
            return practiceRunConfiguration(PracticeRunConfiguration.builder().applyMutation(practiceRunConfiguration).build());
        }
    }

    static final class BuilderImpl extends ArcZonalShiftResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String zonalAutoshiftStatus;

        private PracticeRunConfiguration practiceRunConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePracticeRunConfigurationResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            zonalAutoshiftStatus(model.zonalAutoshiftStatus);
            practiceRunConfiguration(model.practiceRunConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getZonalAutoshiftStatus() {
            return zonalAutoshiftStatus;
        }

        public final void setZonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
        }

        @Override
        public final Builder zonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
            return this;
        }

        @Override
        public final Builder zonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus(zonalAutoshiftStatus == null ? null : zonalAutoshiftStatus.toString());
            return this;
        }

        public final PracticeRunConfiguration.Builder getPracticeRunConfiguration() {
            return practiceRunConfiguration != null ? practiceRunConfiguration.toBuilder() : null;
        }

        public final void setPracticeRunConfiguration(PracticeRunConfiguration.BuilderImpl practiceRunConfiguration) {
            this.practiceRunConfiguration = practiceRunConfiguration != null ? practiceRunConfiguration.build() : null;
        }

        @Override
        public final Builder practiceRunConfiguration(PracticeRunConfiguration practiceRunConfiguration) {
            this.practiceRunConfiguration = practiceRunConfiguration;
            return this;
        }

        @Override
        public UpdatePracticeRunConfigurationResponse build() {
            return new UpdatePracticeRunConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
