/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateZonalAutoshiftConfigurationRequest extends ArcZonalShiftRequest implements
        ToCopyableBuilder<UpdateZonalAutoshiftConfigurationRequest.Builder, UpdateZonalAutoshiftConfigurationRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(UpdateZonalAutoshiftConfigurationRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceIdentifier").build()).build();

    private static final SdkField<String> ZONAL_AUTOSHIFT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("zonalAutoshiftStatus")
            .getter(getter(UpdateZonalAutoshiftConfigurationRequest::zonalAutoshiftStatusAsString))
            .setter(setter(Builder::zonalAutoshiftStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalAutoshiftStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD,
            ZONAL_AUTOSHIFT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceIdentifier;

    private final String zonalAutoshiftStatus;

    private UpdateZonalAutoshiftConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.zonalAutoshiftStatus = builder.zonalAutoshiftStatus;
    }

    /**
     * <p>
     * The identifier for the resource that you want to update the zonal autoshift configuration for. The identifier is
     * the Amazon Resource Name (ARN) for the resource.
     * </p>
     * 
     * @return The identifier for the resource that you want to update the zonal autoshift configuration for. The
     *         identifier is the Amazon Resource Name (ARN) for the resource.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The zonal autoshift status for the resource that you want to update the zonal autoshift configuration for. Choose
     * <code>ENABLED</code> to authorize Amazon Web Services to shift away resource traffic for an application from an
     * Availability Zone during events, on your behalf, to help reduce time to recovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #zonalAutoshiftStatus} will return {@link ZonalAutoshiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #zonalAutoshiftStatusAsString}.
     * </p>
     * 
     * @return The zonal autoshift status for the resource that you want to update the zonal autoshift configuration
     *         for. Choose <code>ENABLED</code> to authorize Amazon Web Services to shift away resource traffic for an
     *         application from an Availability Zone during events, on your behalf, to help reduce time to recovery.
     * @see ZonalAutoshiftStatus
     */
    public final ZonalAutoshiftStatus zonalAutoshiftStatus() {
        return ZonalAutoshiftStatus.fromValue(zonalAutoshiftStatus);
    }

    /**
     * <p>
     * The zonal autoshift status for the resource that you want to update the zonal autoshift configuration for. Choose
     * <code>ENABLED</code> to authorize Amazon Web Services to shift away resource traffic for an application from an
     * Availability Zone during events, on your behalf, to help reduce time to recovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #zonalAutoshiftStatus} will return {@link ZonalAutoshiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #zonalAutoshiftStatusAsString}.
     * </p>
     * 
     * @return The zonal autoshift status for the resource that you want to update the zonal autoshift configuration
     *         for. Choose <code>ENABLED</code> to authorize Amazon Web Services to shift away resource traffic for an
     *         application from an Availability Zone during events, on your behalf, to help reduce time to recovery.
     * @see ZonalAutoshiftStatus
     */
    public final String zonalAutoshiftStatusAsString() {
        return zonalAutoshiftStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(zonalAutoshiftStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateZonalAutoshiftConfigurationRequest)) {
            return false;
        }
        UpdateZonalAutoshiftConfigurationRequest other = (UpdateZonalAutoshiftConfigurationRequest) obj;
        return Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(zonalAutoshiftStatusAsString(), other.zonalAutoshiftStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateZonalAutoshiftConfigurationRequest").add("ResourceIdentifier", resourceIdentifier())
                .add("ZonalAutoshiftStatus", zonalAutoshiftStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "zonalAutoshiftStatus":
            return Optional.ofNullable(clazz.cast(zonalAutoshiftStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("zonalAutoshiftStatus", ZONAL_AUTOSHIFT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateZonalAutoshiftConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateZonalAutoshiftConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcZonalShiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateZonalAutoshiftConfigurationRequest> {
        /**
         * <p>
         * The identifier for the resource that you want to update the zonal autoshift configuration for. The identifier
         * is the Amazon Resource Name (ARN) for the resource.
         * </p>
         * 
         * @param resourceIdentifier
         *        The identifier for the resource that you want to update the zonal autoshift configuration for. The
         *        identifier is the Amazon Resource Name (ARN) for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The zonal autoshift status for the resource that you want to update the zonal autoshift configuration for.
         * Choose <code>ENABLED</code> to authorize Amazon Web Services to shift away resource traffic for an
         * application from an Availability Zone during events, on your behalf, to help reduce time to recovery.
         * </p>
         * 
         * @param zonalAutoshiftStatus
         *        The zonal autoshift status for the resource that you want to update the zonal autoshift configuration
         *        for. Choose <code>ENABLED</code> to authorize Amazon Web Services to shift away resource traffic for
         *        an application from an Availability Zone during events, on your behalf, to help reduce time to
         *        recovery.
         * @see ZonalAutoshiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalAutoshiftStatus
         */
        Builder zonalAutoshiftStatus(String zonalAutoshiftStatus);

        /**
         * <p>
         * The zonal autoshift status for the resource that you want to update the zonal autoshift configuration for.
         * Choose <code>ENABLED</code> to authorize Amazon Web Services to shift away resource traffic for an
         * application from an Availability Zone during events, on your behalf, to help reduce time to recovery.
         * </p>
         * 
         * @param zonalAutoshiftStatus
         *        The zonal autoshift status for the resource that you want to update the zonal autoshift configuration
         *        for. Choose <code>ENABLED</code> to authorize Amazon Web Services to shift away resource traffic for
         *        an application from an Availability Zone during events, on your behalf, to help reduce time to
         *        recovery.
         * @see ZonalAutoshiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalAutoshiftStatus
         */
        Builder zonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcZonalShiftRequest.BuilderImpl implements Builder {
        private String resourceIdentifier;

        private String zonalAutoshiftStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateZonalAutoshiftConfigurationRequest model) {
            super(model);
            resourceIdentifier(model.resourceIdentifier);
            zonalAutoshiftStatus(model.zonalAutoshiftStatus);
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getZonalAutoshiftStatus() {
            return zonalAutoshiftStatus;
        }

        public final void setZonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
        }

        @Override
        public final Builder zonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
            return this;
        }

        @Override
        public final Builder zonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus(zonalAutoshiftStatus == null ? null : zonalAutoshiftStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateZonalAutoshiftConfigurationRequest build() {
            return new UpdateZonalAutoshiftConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
