/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateZonalShiftRequest extends ArcZonalShiftRequest implements
        ToCopyableBuilder<UpdateZonalShiftRequest.Builder, UpdateZonalShiftRequest> {
    private static final SdkField<String> ZONAL_SHIFT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("zonalShiftId").getter(getter(UpdateZonalShiftRequest::zonalShiftId))
            .setter(setter(Builder::zonalShiftId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("zonalShiftId").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(UpdateZonalShiftRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<String> EXPIRES_IN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expiresIn").getter(getter(UpdateZonalShiftRequest::expiresIn)).setter(setter(Builder::expiresIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONAL_SHIFT_ID_FIELD,
            COMMENT_FIELD, EXPIRES_IN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String zonalShiftId;

    private final String comment;

    private final String expiresIn;

    private UpdateZonalShiftRequest(BuilderImpl builder) {
        super(builder);
        this.zonalShiftId = builder.zonalShiftId;
        this.comment = builder.comment;
        this.expiresIn = builder.expiresIn;
    }

    /**
     * <p>
     * The identifier of a zonal shift.
     * </p>
     * 
     * @return The identifier of a zonal shift.
     */
    public final String zonalShiftId() {
        return zonalShiftId;
    }

    /**
     * <p>
     * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is
     * maintained. A new comment overwrites any existing comment string.
     * </p>
     * 
     * @return A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history
     *         is maintained. A new comment overwrites any existing comment string.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The length of time that you want a zonal shift to be active, which ARC converts to an expiry time (expiration
     * time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to three days (72
     * hours).
     * </p>
     * <p>
     * If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set a new
     * expiration. You can also cancel a zonal shift, before it expires, for example, if you're ready to restore traffic
     * to the Availability Zone.
     * </p>
     * <p>
     * To set a length of time for a zonal shift to be active, specify a whole number, and then one of the following,
     * with no space:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>A lowercase letter m:</b> To specify that the value is in minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>A lowercase letter h:</b> To specify that the value is in hours.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example: <code>20h</code> means the zonal shift expires in 20 hours. <code>120m</code> means the zonal shift
     * expires in 120 minutes (2 hours).
     * </p>
     * 
     * @return The length of time that you want a zonal shift to be active, which ARC converts to an expiry time
     *         (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to
     *         three days (72 hours).</p>
     *         <p>
     *         If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set
     *         a new expiration. You can also cancel a zonal shift, before it expires, for example, if you're ready to
     *         restore traffic to the Availability Zone.
     *         </p>
     *         <p>
     *         To set a length of time for a zonal shift to be active, specify a whole number, and then one of the
     *         following, with no space:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>A lowercase letter m:</b> To specify that the value is in minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>A lowercase letter h:</b> To specify that the value is in hours.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example: <code>20h</code> means the zonal shift expires in 20 hours. <code>120m</code> means the
     *         zonal shift expires in 120 minutes (2 hours).
     */
    public final String expiresIn() {
        return expiresIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(zonalShiftId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(expiresIn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateZonalShiftRequest)) {
            return false;
        }
        UpdateZonalShiftRequest other = (UpdateZonalShiftRequest) obj;
        return Objects.equals(zonalShiftId(), other.zonalShiftId()) && Objects.equals(comment(), other.comment())
                && Objects.equals(expiresIn(), other.expiresIn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateZonalShiftRequest").add("ZonalShiftId", zonalShiftId()).add("Comment", comment())
                .add("ExpiresIn", expiresIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "zonalShiftId":
            return Optional.ofNullable(clazz.cast(zonalShiftId()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "expiresIn":
            return Optional.ofNullable(clazz.cast(expiresIn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("zonalShiftId", ZONAL_SHIFT_ID_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("expiresIn", EXPIRES_IN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateZonalShiftRequest, T> g) {
        return obj -> g.apply((UpdateZonalShiftRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcZonalShiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateZonalShiftRequest> {
        /**
         * <p>
         * The identifier of a zonal shift.
         * </p>
         * 
         * @param zonalShiftId
         *        The identifier of a zonal shift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalShiftId(String zonalShiftId);

        /**
         * <p>
         * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is
         * maintained. A new comment overwrites any existing comment string.
         * </p>
         * 
         * @param comment
         *        A comment that you enter about the zonal shift. Only the latest comment is retained; no comment
         *        history is maintained. A new comment overwrites any existing comment string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The length of time that you want a zonal shift to be active, which ARC converts to an expiry time (expiration
         * time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to three days (72
         * hours).
         * </p>
         * <p>
         * If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set a
         * new expiration. You can also cancel a zonal shift, before it expires, for example, if you're ready to restore
         * traffic to the Availability Zone.
         * </p>
         * <p>
         * To set a length of time for a zonal shift to be active, specify a whole number, and then one of the
         * following, with no space:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>A lowercase letter m:</b> To specify that the value is in minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>A lowercase letter h:</b> To specify that the value is in hours.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example: <code>20h</code> means the zonal shift expires in 20 hours. <code>120m</code> means the zonal
         * shift expires in 120 minutes (2 hours).
         * </p>
         * 
         * @param expiresIn
         *        The length of time that you want a zonal shift to be active, which ARC converts to an expiry time
         *        (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up
         *        to three days (72 hours).</p>
         *        <p>
         *        If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and
         *        set a new expiration. You can also cancel a zonal shift, before it expires, for example, if you're
         *        ready to restore traffic to the Availability Zone.
         *        </p>
         *        <p>
         *        To set a length of time for a zonal shift to be active, specify a whole number, and then one of the
         *        following, with no space:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>A lowercase letter m:</b> To specify that the value is in minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>A lowercase letter h:</b> To specify that the value is in hours.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example: <code>20h</code> means the zonal shift expires in 20 hours. <code>120m</code> means the
         *        zonal shift expires in 120 minutes (2 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresIn(String expiresIn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcZonalShiftRequest.BuilderImpl implements Builder {
        private String zonalShiftId;

        private String comment;

        private String expiresIn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateZonalShiftRequest model) {
            super(model);
            zonalShiftId(model.zonalShiftId);
            comment(model.comment);
            expiresIn(model.expiresIn);
        }

        public final String getZonalShiftId() {
            return zonalShiftId;
        }

        public final void setZonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
        }

        @Override
        public final Builder zonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getExpiresIn() {
            return expiresIn;
        }

        public final void setExpiresIn(String expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(String expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateZonalShiftRequest build() {
            return new UpdateZonalShiftRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
