/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Welcome to the API Reference Guide for zonal shift and zonal autoshift in Amazon Application Recovery Controller
 * (ARC).
 * </p>
 * <p>
 * You can start a zonal shift to move traffic for a load balancer resource away from an Availability Zone to help your
 * application recover quickly from an impairment in an Availability Zone. For example, you can recover your application
 * from a developer's bad code deployment or from an Amazon Web Services infrastructure failure in a single Availability
 * Zone.
 * </p>
 * <p>
 * You can also configure zonal autoshift for supported load balancer resources. Zonal autoshift is a capability in ARC
 * where you authorize Amazon Web Services to shift away application resource traffic from an Availability Zone during
 * events, on your behalf, to help reduce your time to recovery. Amazon Web Services starts an autoshift when internal
 * telemetry indicates that there is an Availability Zone impairment that could potentially impact customers.
 * </p>
 * <p>
 * For more information about using zonal shift and zonal autoshift, see the <a
 * href="https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route53-recovery.html">Amazon Application Recovery
 * Controller Developer Guide</a>.
 * </p>
 */
package software.amazon.awssdk.services.arczonalshift;