/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartPracticeRunRequest extends ArcZonalShiftRequest implements
        ToCopyableBuilder<StartPracticeRunRequest.Builder, StartPracticeRunRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(StartPracticeRunRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final SdkField<String> AWAY_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awayFrom").getter(getter(StartPracticeRunRequest::awayFrom)).setter(setter(Builder::awayFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awayFrom").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(StartPracticeRunRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD,
            AWAY_FROM_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceIdentifier;

    private final String awayFrom;

    private final String comment;

    private StartPracticeRunRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.awayFrom = builder.awayFrom;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The identifier for the resource that you want to start a practice run zonal shift for. The identifier is the
     * Amazon Resource Name (ARN) for the resource.
     * </p>
     * 
     * @return The identifier for the resource that you want to start a practice run zonal shift for. The identifier is
     *         the Amazon Resource Name (ARN) for the resource.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The Availability Zone (for example, <code>use1-az1</code>) that traffic is shifted away from for the resource
     * that you specify for the practice run.
     * </p>
     * 
     * @return The Availability Zone (for example, <code>use1-az1</code>) that traffic is shifted away from for the
     *         resource that you specify for the practice run.
     */
    public final String awayFrom() {
        return awayFrom;
    }

    /**
     * <p>
     * The initial comment that you enter about the practice run. Be aware that this comment can be overwritten by
     * Amazon Web Services if the automatic check for balanced capacity fails. For more information, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html">
     * Capacity checks for practice runs</a> in the Amazon Application Recovery Controller Developer Guide.
     * </p>
     * 
     * @return The initial comment that you enter about the practice run. Be aware that this comment can be overwritten
     *         by Amazon Web Services if the automatic check for balanced capacity fails. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html">
     *         Capacity checks for practice runs</a> in the Amazon Application Recovery Controller Developer Guide.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(awayFrom());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPracticeRunRequest)) {
            return false;
        }
        StartPracticeRunRequest other = (StartPracticeRunRequest) obj;
        return Objects.equals(resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(awayFrom(), other.awayFrom())
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartPracticeRunRequest").add("ResourceIdentifier", resourceIdentifier())
                .add("AwayFrom", awayFrom()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "awayFrom":
            return Optional.ofNullable(clazz.cast(awayFrom()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("awayFrom", AWAY_FROM_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartPracticeRunRequest, T> g) {
        return obj -> g.apply((StartPracticeRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcZonalShiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartPracticeRunRequest> {
        /**
         * <p>
         * The identifier for the resource that you want to start a practice run zonal shift for. The identifier is the
         * Amazon Resource Name (ARN) for the resource.
         * </p>
         * 
         * @param resourceIdentifier
         *        The identifier for the resource that you want to start a practice run zonal shift for. The identifier
         *        is the Amazon Resource Name (ARN) for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The Availability Zone (for example, <code>use1-az1</code>) that traffic is shifted away from for the resource
         * that you specify for the practice run.
         * </p>
         * 
         * @param awayFrom
         *        The Availability Zone (for example, <code>use1-az1</code>) that traffic is shifted away from for the
         *        resource that you specify for the practice run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awayFrom(String awayFrom);

        /**
         * <p>
         * The initial comment that you enter about the practice run. Be aware that this comment can be overwritten by
         * Amazon Web Services if the automatic check for balanced capacity fails. For more information, see <a href=
         * "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html">
         * Capacity checks for practice runs</a> in the Amazon Application Recovery Controller Developer Guide.
         * </p>
         * 
         * @param comment
         *        The initial comment that you enter about the practice run. Be aware that this comment can be
         *        overwritten by Amazon Web Services if the automatic check for balanced capacity fails. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html"
         *        > Capacity checks for practice runs</a> in the Amazon Application Recovery Controller Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcZonalShiftRequest.BuilderImpl implements Builder {
        private String resourceIdentifier;

        private String awayFrom;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPracticeRunRequest model) {
            super(model);
            resourceIdentifier(model.resourceIdentifier);
            awayFrom(model.awayFrom);
            comment(model.comment);
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getAwayFrom() {
            return awayFrom;
        }

        public final void setAwayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
        }

        @Override
        public final Builder awayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPracticeRunRequest build() {
            return new StartPracticeRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
