/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.artifact;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.artifact.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.artifact.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.artifact.model.GetReportMetadataRequest;
import software.amazon.awssdk.services.artifact.model.GetReportMetadataResponse;
import software.amazon.awssdk.services.artifact.model.GetReportRequest;
import software.amazon.awssdk.services.artifact.model.GetReportResponse;
import software.amazon.awssdk.services.artifact.model.GetTermForReportRequest;
import software.amazon.awssdk.services.artifact.model.GetTermForReportResponse;
import software.amazon.awssdk.services.artifact.model.ListReportsRequest;
import software.amazon.awssdk.services.artifact.model.ListReportsResponse;
import software.amazon.awssdk.services.artifact.model.PutAccountSettingsRequest;
import software.amazon.awssdk.services.artifact.model.PutAccountSettingsResponse;
import software.amazon.awssdk.services.artifact.paginators.ListReportsPublisher;

/**
 * Service client for accessing AWS Artifact asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * This reference provides descriptions of the low-level AWS Artifact Service API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ArtifactAsyncClient extends AwsClient {
    String SERVICE_NAME = "artifact";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "artifact";

    /**
     * <p>
     * Get the account settings for Artifact.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Request to create/modify content would result in a conflict.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the account settings for Artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.artifact.model.GetAccountSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Request to create/modify content would result in a conflict.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(
            Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest) {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Get the content for a single report.
     * </p>
     *
     * @param getReportRequest
     * @return A Java Future containing the result of the GetReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Request to create/modify content would result in a conflict.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.GetReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetReport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReportResponse> getReport(GetReportRequest getReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the content for a single report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReportRequest.Builder} avoiding the need to
     * create one manually via {@link GetReportRequest#builder()}
     * </p>
     *
     * @param getReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.artifact.model.GetReportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Request to create/modify content would result in a conflict.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.GetReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetReport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReportResponse> getReport(Consumer<GetReportRequest.Builder> getReportRequest) {
        return getReport(GetReportRequest.builder().applyMutation(getReportRequest).build());
    }

    /**
     * <p>
     * Get the metadata for a single report.
     * </p>
     *
     * @param getReportMetadataRequest
     * @return A Java Future containing the result of the GetReportMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.GetReportMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetReportMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReportMetadataResponse> getReportMetadata(GetReportMetadataRequest getReportMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the metadata for a single report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReportMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link GetReportMetadataRequest#builder()}
     * </p>
     *
     * @param getReportMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.artifact.model.GetReportMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReportMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.GetReportMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetReportMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReportMetadataResponse> getReportMetadata(
            Consumer<GetReportMetadataRequest.Builder> getReportMetadataRequest) {
        return getReportMetadata(GetReportMetadataRequest.builder().applyMutation(getReportMetadataRequest).build());
    }

    /**
     * <p>
     * Get the Term content associated with a single report.
     * </p>
     *
     * @param getTermForReportRequest
     * @return A Java Future containing the result of the GetTermForReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Request to create/modify content would result in a conflict.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.GetTermForReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetTermForReport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTermForReportResponse> getTermForReport(GetTermForReportRequest getTermForReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the Term content associated with a single report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTermForReportRequest.Builder} avoiding the need
     * to create one manually via {@link GetTermForReportRequest#builder()}
     * </p>
     *
     * @param getTermForReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.artifact.model.GetTermForReportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTermForReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Request to create/modify content would result in a conflict.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.GetTermForReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetTermForReport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTermForReportResponse> getTermForReport(
            Consumer<GetTermForReportRequest.Builder> getTermForReportRequest) {
        return getTermForReport(GetTermForReportRequest.builder().applyMutation(getTermForReportRequest).build());
    }

    /**
     * <p>
     * List available reports.
     * </p>
     *
     * @param listReportsRequest
     * @return A Java Future containing the result of the ListReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.ListReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/ListReports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReportsResponse> listReports(ListReportsRequest listReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List available reports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReportsRequest#builder()}
     * </p>
     *
     * @param listReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.artifact.model.ListReportsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.ListReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/ListReports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReportsResponse> listReports(Consumer<ListReportsRequest.Builder> listReportsRequest) {
        return listReports(ListReportsRequest.builder().applyMutation(listReportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listReports(software.amazon.awssdk.services.artifact.model.ListReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.artifact.paginators.ListReportsPublisher publisher = client.listReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.artifact.paginators.ListReportsPublisher publisher = client.listReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.artifact.model.ListReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.artifact.model.ListReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReports(software.amazon.awssdk.services.artifact.model.ListReportsRequest)} operation.</b>
     * </p>
     *
     * @param listReportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.ListReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/ListReports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportsPublisher listReportsPaginator(ListReportsRequest listReportsRequest) {
        return new ListReportsPublisher(this, listReportsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listReports(software.amazon.awssdk.services.artifact.model.ListReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.artifact.paginators.ListReportsPublisher publisher = client.listReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.artifact.paginators.ListReportsPublisher publisher = client.listReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.artifact.model.ListReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.artifact.model.ListReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReports(software.amazon.awssdk.services.artifact.model.ListReportsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReportsRequest#builder()}
     * </p>
     *
     * @param listReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.artifact.model.ListReportsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.ListReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/ListReports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportsPublisher listReportsPaginator(Consumer<ListReportsRequest.Builder> listReportsRequest) {
        return listReportsPaginator(ListReportsRequest.builder().applyMutation(listReportsRequest).build());
    }

    /**
     * <p>
     * Put the account settings for Artifact.
     * </p>
     *
     * @param putAccountSettingsRequest
     * @return A Java Future containing the result of the PutAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Request to create/modify content would result in a conflict.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.PutAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/PutAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAccountSettingsResponse> putAccountSettings(PutAccountSettingsRequest putAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put the account settings for Artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link PutAccountSettingsRequest#builder()}
     * </p>
     *
     * @param putAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.artifact.model.PutAccountSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Request to create/modify content would result in a conflict.</li>
     *         <li>InternalServerException An unknown server exception has occurred.</li>
     *         <li>ValidationException Request fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ArtifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ArtifactAsyncClient.PutAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/PutAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAccountSettingsResponse> putAccountSettings(
            Consumer<PutAccountSettingsRequest.Builder> putAccountSettingsRequest) {
        return putAccountSettings(PutAccountSettingsRequest.builder().applyMutation(putAccountSettingsRequest).build());
    }

    @Override
    default ArtifactServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ArtifactAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ArtifactAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ArtifactAsyncClient}.
     */
    static ArtifactAsyncClientBuilder builder() {
        return new DefaultArtifactAsyncClientBuilder();
    }
}
