/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.artifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReportMetadataResponse extends ArtifactResponse implements
        ToCopyableBuilder<GetReportMetadataResponse.Builder, GetReportMetadataResponse> {
    private static final SdkField<ReportDetail> REPORT_DETAILS_FIELD = SdkField.<ReportDetail> builder(MarshallingType.SDK_POJO)
            .memberName("reportDetails").getter(getter(GetReportMetadataResponse::reportDetails))
            .setter(setter(Builder::reportDetails)).constructor(ReportDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_DETAILS_FIELD));

    private final ReportDetail reportDetails;

    private GetReportMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.reportDetails = builder.reportDetails;
    }

    /**
     * <p>
     * Report resource detail.
     * </p>
     * 
     * @return Report resource detail.
     */
    public final ReportDetail reportDetails() {
        return reportDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReportMetadataResponse)) {
            return false;
        }
        GetReportMetadataResponse other = (GetReportMetadataResponse) obj;
        return Objects.equals(reportDetails(), other.reportDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReportMetadataResponse").add("ReportDetails", reportDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportDetails":
            return Optional.ofNullable(clazz.cast(reportDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReportMetadataResponse, T> g) {
        return obj -> g.apply((GetReportMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ArtifactResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetReportMetadataResponse> {
        /**
         * <p>
         * Report resource detail.
         * </p>
         * 
         * @param reportDetails
         *        Report resource detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDetails(ReportDetail reportDetails);

        /**
         * <p>
         * Report resource detail.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportDetail.Builder} avoiding the need
         * to create one manually via {@link ReportDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #reportDetails(ReportDetail)}.
         * 
         * @param reportDetails
         *        a consumer that will call methods on {@link ReportDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportDetails(ReportDetail)
         */
        default Builder reportDetails(Consumer<ReportDetail.Builder> reportDetails) {
            return reportDetails(ReportDetail.builder().applyMutation(reportDetails).build());
        }
    }

    static final class BuilderImpl extends ArtifactResponse.BuilderImpl implements Builder {
        private ReportDetail reportDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReportMetadataResponse model) {
            super(model);
            reportDetails(model.reportDetails);
        }

        public final ReportDetail.Builder getReportDetails() {
            return reportDetails != null ? reportDetails.toBuilder() : null;
        }

        public final void setReportDetails(ReportDetail.BuilderImpl reportDetails) {
            this.reportDetails = reportDetails != null ? reportDetails.build() : null;
        }

        @Override
        public final Builder reportDetails(ReportDetail reportDetails) {
            this.reportDetails = reportDetails;
            return this;
        }

        @Override
        public GetReportMetadataResponse build() {
            return new GetReportMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
