/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.artifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary for report resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportSummary implements SdkPojo, Serializable, ToCopyableBuilder<ReportSummary.Builder, ReportSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ReportSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(ReportSummary::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("companyName").getter(getter(ReportSummary::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("companyName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ReportSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ReportSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ReportSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> PERIOD_END_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("periodEnd")
            .getter(getter(ReportSummary::periodEnd))
            .setter(setter(Builder::periodEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodEnd").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> PERIOD_START_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("periodStart")
            .getter(getter(ReportSummary::periodStart))
            .setter(setter(Builder::periodStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodStart").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productName").getter(getter(ReportSummary::productName)).setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productName").build()).build();

    private static final SdkField<String> SERIES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("series")
            .getter(getter(ReportSummary::series)).setter(setter(Builder::series))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("series").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ReportSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ReportSummary::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> UPLOAD_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadState").getter(getter(ReportSummary::uploadStateAsString)).setter(setter(Builder::uploadState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadState").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("version")
            .getter(getter(ReportSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATEGORY_FIELD,
            COMPANY_NAME_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, PERIOD_END_FIELD, PERIOD_START_FIELD,
            PRODUCT_NAME_FIELD, SERIES_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, UPLOAD_STATE_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String category;

    private final String companyName;

    private final String description;

    private final String id;

    private final String name;

    private final Instant periodEnd;

    private final Instant periodStart;

    private final String productName;

    private final String series;

    private final String state;

    private final String statusMessage;

    private final String uploadState;

    private final Long version;

    private ReportSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.category = builder.category;
        this.companyName = builder.companyName;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.periodEnd = builder.periodEnd;
        this.periodStart = builder.periodStart;
        this.productName = builder.productName;
        this.series = builder.series;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.uploadState = builder.uploadState;
        this.version = builder.version;
    }

    /**
     * <p>
     * ARN for the report resource.
     * </p>
     * 
     * @return ARN for the report resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Category for the report resource.
     * </p>
     * 
     * @return Category for the report resource.
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * Associated company name for the report resource.
     * </p>
     * 
     * @return Associated company name for the report resource.
     */
    public final String companyName() {
        return companyName;
    }

    /**
     * <p>
     * Description for the report resource.
     * </p>
     * 
     * @return Description for the report resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Unique resource ID for the report resource.
     * </p>
     * 
     * @return Unique resource ID for the report resource.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Name for the report resource.
     * </p>
     * 
     * @return Name for the report resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Timestamp indicating the report resource effective end.
     * </p>
     * 
     * @return Timestamp indicating the report resource effective end.
     */
    public final Instant periodEnd() {
        return periodEnd;
    }

    /**
     * <p>
     * Timestamp indicating the report resource effective start.
     * </p>
     * 
     * @return Timestamp indicating the report resource effective start.
     */
    public final Instant periodStart() {
        return periodStart;
    }

    /**
     * <p>
     * Associated product name for the report resource.
     * </p>
     * 
     * @return Associated product name for the report resource.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * Series for the report resource.
     * </p>
     * 
     * @return Series for the report resource.
     */
    public final String series() {
        return series;
    }

    /**
     * <p>
     * Current state of the report resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PublishedState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Current state of the report resource.
     * @see PublishedState
     */
    public final PublishedState state() {
        return PublishedState.fromValue(state);
    }

    /**
     * <p>
     * Current state of the report resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PublishedState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Current state of the report resource.
     * @see PublishedState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The message associated with the current upload state.
     * </p>
     * 
     * @return The message associated with the current upload state.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The current state of the document upload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadState} will
     * return {@link UploadState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadStateAsString}.
     * </p>
     * 
     * @return The current state of the document upload.
     * @see UploadState
     */
    public final UploadState uploadState() {
        return UploadState.fromValue(uploadState);
    }

    /**
     * <p>
     * The current state of the document upload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadState} will
     * return {@link UploadState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadStateAsString}.
     * </p>
     * 
     * @return The current state of the document upload.
     * @see UploadState
     */
    public final String uploadStateAsString() {
        return uploadState;
    }

    /**
     * <p>
     * Version for the report resource.
     * </p>
     * 
     * @return Version for the report resource.
     */
    public final Long version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(periodEnd());
        hashCode = 31 * hashCode + Objects.hashCode(periodStart());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(series());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(uploadStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportSummary)) {
            return false;
        }
        ReportSummary other = (ReportSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(category(), other.category())
                && Objects.equals(companyName(), other.companyName()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(periodEnd(), other.periodEnd()) && Objects.equals(periodStart(), other.periodStart())
                && Objects.equals(productName(), other.productName()) && Objects.equals(series(), other.series())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(uploadStateAsString(), other.uploadStateAsString())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportSummary").add("Arn", arn()).add("Category", category()).add("CompanyName", companyName())
                .add("Description", description()).add("Id", id()).add("Name", name()).add("PeriodEnd", periodEnd())
                .add("PeriodStart", periodStart()).add("ProductName", productName()).add("Series", series())
                .add("State", stateAsString()).add("StatusMessage", statusMessage()).add("UploadState", uploadStateAsString())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "category":
            return Optional.ofNullable(clazz.cast(category()));
        case "companyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "periodEnd":
            return Optional.ofNullable(clazz.cast(periodEnd()));
        case "periodStart":
            return Optional.ofNullable(clazz.cast(periodStart()));
        case "productName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "series":
            return Optional.ofNullable(clazz.cast(series()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "uploadState":
            return Optional.ofNullable(clazz.cast(uploadStateAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportSummary, T> g) {
        return obj -> g.apply((ReportSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportSummary> {
        /**
         * <p>
         * ARN for the report resource.
         * </p>
         * 
         * @param arn
         *        ARN for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Category for the report resource.
         * </p>
         * 
         * @param category
         *        Category for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * Associated company name for the report resource.
         * </p>
         * 
         * @param companyName
         *        Associated company name for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * Description for the report resource.
         * </p>
         * 
         * @param description
         *        Description for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Unique resource ID for the report resource.
         * </p>
         * 
         * @param id
         *        Unique resource ID for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Name for the report resource.
         * </p>
         * 
         * @param name
         *        Name for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Timestamp indicating the report resource effective end.
         * </p>
         * 
         * @param periodEnd
         *        Timestamp indicating the report resource effective end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodEnd(Instant periodEnd);

        /**
         * <p>
         * Timestamp indicating the report resource effective start.
         * </p>
         * 
         * @param periodStart
         *        Timestamp indicating the report resource effective start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodStart(Instant periodStart);

        /**
         * <p>
         * Associated product name for the report resource.
         * </p>
         * 
         * @param productName
         *        Associated product name for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * Series for the report resource.
         * </p>
         * 
         * @param series
         *        Series for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder series(String series);

        /**
         * <p>
         * Current state of the report resource.
         * </p>
         * 
         * @param state
         *        Current state of the report resource.
         * @see PublishedState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishedState
         */
        Builder state(String state);

        /**
         * <p>
         * Current state of the report resource.
         * </p>
         * 
         * @param state
         *        Current state of the report resource.
         * @see PublishedState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishedState
         */
        Builder state(PublishedState state);

        /**
         * <p>
         * The message associated with the current upload state.
         * </p>
         * 
         * @param statusMessage
         *        The message associated with the current upload state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The current state of the document upload.
         * </p>
         * 
         * @param uploadState
         *        The current state of the document upload.
         * @see UploadState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadState
         */
        Builder uploadState(String uploadState);

        /**
         * <p>
         * The current state of the document upload.
         * </p>
         * 
         * @param uploadState
         *        The current state of the document upload.
         * @see UploadState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadState
         */
        Builder uploadState(UploadState uploadState);

        /**
         * <p>
         * Version for the report resource.
         * </p>
         * 
         * @param version
         *        Version for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String category;

        private String companyName;

        private String description;

        private String id;

        private String name;

        private Instant periodEnd;

        private Instant periodStart;

        private String productName;

        private String series;

        private String state;

        private String statusMessage;

        private String uploadState;

        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportSummary model) {
            arn(model.arn);
            category(model.category);
            companyName(model.companyName);
            description(model.description);
            id(model.id);
            name(model.name);
            periodEnd(model.periodEnd);
            periodStart(model.periodStart);
            productName(model.productName);
            series(model.series);
            state(model.state);
            statusMessage(model.statusMessage);
            uploadState(model.uploadState);
            version(model.version);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getCompanyName() {
            return companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getPeriodEnd() {
            return periodEnd;
        }

        public final void setPeriodEnd(Instant periodEnd) {
            this.periodEnd = periodEnd;
        }

        @Override
        public final Builder periodEnd(Instant periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        public final Instant getPeriodStart() {
            return periodStart;
        }

        public final void setPeriodStart(Instant periodStart) {
            this.periodStart = periodStart;
        }

        @Override
        public final Builder periodStart(Instant periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        public final String getProductName() {
            return productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getSeries() {
            return series;
        }

        public final void setSeries(String series) {
            this.series = series;
        }

        @Override
        public final Builder series(String series) {
            this.series = series;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PublishedState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getUploadState() {
            return uploadState;
        }

        public final void setUploadState(String uploadState) {
            this.uploadState = uploadState;
        }

        @Override
        public final Builder uploadState(String uploadState) {
            this.uploadState = uploadState;
            return this;
        }

        @Override
        public final Builder uploadState(UploadState uploadState) {
            this.uploadState(uploadState == null ? null : uploadState.toString());
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        @Override
        public ReportSummary build() {
            return new ReportSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
