/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.artifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReportsResponse extends ArtifactResponse implements
        ToCopyableBuilder<ListReportsResponse.Builder, ListReportsResponse> {
    private static final SdkField<List<ReportSummary>> REPORTS_FIELD = SdkField
            .<List<ReportSummary>> builder(MarshallingType.LIST)
            .memberName("reports")
            .getter(getter(ListReportsResponse::reports))
            .setter(setter(Builder::reports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReportSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReportSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ReportSummary> reports;

    private final String nextToken;

    private ListReportsResponse(BuilderImpl builder) {
        super(builder);
        this.reports = builder.reports;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Reports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReports() {
        return reports != null && !(reports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of report resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReports} method.
     * </p>
     * 
     * @return List of report resources.
     */
    public final List<ReportSummary> reports() {
        return reports;
    }

    /**
     * <p>
     * Pagination token to request the next page of resources.
     * </p>
     * 
     * @return Pagination token to request the next page of resources.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReports() ? reports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportsResponse)) {
            return false;
        }
        ListReportsResponse other = (ListReportsResponse) obj;
        return hasReports() == other.hasReports() && Objects.equals(reports(), other.reports())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReportsResponse").add("Reports", hasReports() ? reports() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reports":
            return Optional.ofNullable(clazz.cast(reports()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReportsResponse, T> g) {
        return obj -> g.apply((ListReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ArtifactResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReportsResponse> {
        /**
         * <p>
         * List of report resources.
         * </p>
         * 
         * @param reports
         *        List of report resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(Collection<ReportSummary> reports);

        /**
         * <p>
         * List of report resources.
         * </p>
         * 
         * @param reports
         *        List of report resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(ReportSummary... reports);

        /**
         * <p>
         * List of report resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.artifact.model.ReportSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.artifact.model.ReportSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.artifact.model.ReportSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #reports(List<ReportSummary>)}.
         * 
         * @param reports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.artifact.model.ReportSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reports(java.util.Collection<ReportSummary>)
         */
        Builder reports(Consumer<ReportSummary.Builder>... reports);

        /**
         * <p>
         * Pagination token to request the next page of resources.
         * </p>
         * 
         * @param nextToken
         *        Pagination token to request the next page of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ArtifactResponse.BuilderImpl implements Builder {
        private List<ReportSummary> reports = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportsResponse model) {
            super(model);
            reports(model.reports);
            nextToken(model.nextToken);
        }

        public final List<ReportSummary.Builder> getReports() {
            List<ReportSummary.Builder> result = ReportsListCopier.copyToBuilder(this.reports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReports(Collection<ReportSummary.BuilderImpl> reports) {
            this.reports = ReportsListCopier.copyFromBuilder(reports);
        }

        @Override
        public final Builder reports(Collection<ReportSummary> reports) {
            this.reports = ReportsListCopier.copy(reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(ReportSummary... reports) {
            reports(Arrays.asList(reports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(Consumer<ReportSummary.Builder>... reports) {
            reports(Stream.of(reports).map(c -> ReportSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReportsResponse build() {
            return new ListReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
