/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.artifact.model.ArtifactRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReportRequest
extends ArtifactRequest
implements ToCopyableBuilder<Builder, GetReportRequest> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportId").getter(GetReportRequest.getter(GetReportRequest::reportId)).setter(GetReportRequest.setter(Builder::reportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reportId").build()}).build();
    private static final SdkField<Long> REPORT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("reportVersion").getter(GetReportRequest.getter(GetReportRequest::reportVersion)).setter(GetReportRequest.setter(Builder::reportVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reportVersion").build()}).build();
    private static final SdkField<String> TERM_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("termToken").getter(GetReportRequest.getter(GetReportRequest::termToken)).setter(GetReportRequest.setter(Builder::termToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("termToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD, REPORT_VERSION_FIELD, TERM_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("reportId", REPORT_ID_FIELD);
            this.put("reportVersion", REPORT_VERSION_FIELD);
            this.put("termToken", TERM_TOKEN_FIELD);
        }
    });
    private final String reportId;
    private final Long reportVersion;
    private final String termToken;

    private GetReportRequest(BuilderImpl builder) {
        super(builder);
        this.reportId = builder.reportId;
        this.reportVersion = builder.reportVersion;
        this.termToken = builder.termToken;
    }

    public final String reportId() {
        return this.reportId;
    }

    public final Long reportVersion() {
        return this.reportVersion;
    }

    public final String termToken() {
        return this.termToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.termToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReportRequest)) {
            return false;
        }
        GetReportRequest other = (GetReportRequest)((Object)obj);
        return Objects.equals(this.reportId(), other.reportId()) && Objects.equals(this.reportVersion(), other.reportVersion()) && Objects.equals(this.termToken(), other.termToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetReportRequest").add("ReportId", (Object)this.reportId()).add("ReportVersion", (Object)this.reportVersion()).add("TermToken", (Object)this.termToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportId": {
                return Optional.ofNullable(clazz.cast(this.reportId()));
            }
            case "reportVersion": {
                return Optional.ofNullable(clazz.cast(this.reportVersion()));
            }
            case "termToken": {
                return Optional.ofNullable(clazz.cast(this.termToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetReportRequest, T> g) {
        return obj -> g.apply((GetReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArtifactRequest.BuilderImpl
    implements Builder {
        private String reportId;
        private Long reportVersion;
        private String termToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReportRequest model) {
            super(model);
            this.reportId(model.reportId);
            this.reportVersion(model.reportVersion);
            this.termToken(model.termToken);
        }

        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final Long getReportVersion() {
            return this.reportVersion;
        }

        public final void setReportVersion(Long reportVersion) {
            this.reportVersion = reportVersion;
        }

        @Override
        public final Builder reportVersion(Long reportVersion) {
            this.reportVersion = reportVersion;
            return this;
        }

        public final String getTermToken() {
            return this.termToken;
        }

        public final void setTermToken(String termToken) {
            this.termToken = termToken;
        }

        @Override
        public final Builder termToken(String termToken) {
            this.termToken = termToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReportRequest build() {
            return new GetReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ArtifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReportRequest> {
        public Builder reportId(String var1);

        public Builder reportVersion(Long var1);

        public Builder termToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

