/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AcceptanceType {
    PASSTHROUGH("PASSTHROUGH"),
    EXPLICIT("EXPLICIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AcceptanceType> VALUE_MAP;
    private final String value;

    private AcceptanceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AcceptanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AcceptanceType> knownValues() {
        EnumSet<AcceptanceType> knownValues = EnumSet.allOf(AcceptanceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AcceptanceType.class, AcceptanceType::toString);
    }
}

