/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.artifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReportResponse extends ArtifactResponse implements
        ToCopyableBuilder<GetReportResponse.Builder, GetReportResponse> {
    private static final SdkField<String> DOCUMENT_PRESIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentPresignedUrl").getter(getter(GetReportResponse::documentPresignedUrl))
            .setter(setter(Builder::documentPresignedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentPresignedUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_PRESIGNED_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String documentPresignedUrl;

    private GetReportResponse(BuilderImpl builder) {
        super(builder);
        this.documentPresignedUrl = builder.documentPresignedUrl;
    }

    /**
     * <p>
     * Presigned S3 url to access the report content.
     * </p>
     * 
     * @return Presigned S3 url to access the report content.
     */
    public final String documentPresignedUrl() {
        return documentPresignedUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentPresignedUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReportResponse)) {
            return false;
        }
        GetReportResponse other = (GetReportResponse) obj;
        return Objects.equals(documentPresignedUrl(), other.documentPresignedUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReportResponse").add("DocumentPresignedUrl", documentPresignedUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "documentPresignedUrl":
            return Optional.ofNullable(clazz.cast(documentPresignedUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("documentPresignedUrl", DOCUMENT_PRESIGNED_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReportResponse, T> g) {
        return obj -> g.apply((GetReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ArtifactResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetReportResponse> {
        /**
         * <p>
         * Presigned S3 url to access the report content.
         * </p>
         * 
         * @param documentPresignedUrl
         *        Presigned S3 url to access the report content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentPresignedUrl(String documentPresignedUrl);
    }

    static final class BuilderImpl extends ArtifactResponse.BuilderImpl implements Builder {
        private String documentPresignedUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReportResponse model) {
            super(model);
            documentPresignedUrl(model.documentPresignedUrl);
        }

        public final String getDocumentPresignedUrl() {
            return documentPresignedUrl;
        }

        public final void setDocumentPresignedUrl(String documentPresignedUrl) {
            this.documentPresignedUrl = documentPresignedUrl;
        }

        @Override
        public final Builder documentPresignedUrl(String documentPresignedUrl) {
            this.documentPresignedUrl = documentPresignedUrl;
            return this;
        }

        @Override
        public GetReportResponse build() {
            return new GetReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
