/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.artifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Full detail for report resource metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportDetail implements SdkPojo, Serializable, ToCopyableBuilder<ReportDetail.Builder, ReportDetail> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ReportDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ReportDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ReportDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> PERIOD_START_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("periodStart")
            .getter(getter(ReportDetail::periodStart))
            .setter(setter(Builder::periodStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodStart").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> PERIOD_END_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("periodEnd")
            .getter(getter(ReportDetail::periodEnd))
            .setter(setter(Builder::periodEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodEnd").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ReportDetail::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt")
            .getter(getter(ReportDetail::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("deletedAt")
            .getter(getter(ReportDetail::deletedAt))
            .setter(setter(Builder::deletedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ReportDetail::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ReportDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> SERIES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("series")
            .getter(getter(ReportDetail::series)).setter(setter(Builder::series))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("series").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(ReportDetail::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("companyName").getter(getter(ReportDetail::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("companyName").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productName").getter(getter(ReportDetail::productName)).setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productName").build()).build();

    private static final SdkField<String> TERM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("termArn").getter(getter(ReportDetail::termArn)).setter(setter(Builder::termArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termArn").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("version")
            .getter(getter(ReportDetail::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> ACCEPTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("acceptanceType").getter(getter(ReportDetail::acceptanceTypeAsString))
            .setter(setter(Builder::acceptanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptanceType").build()).build();

    private static final SdkField<Long> SEQUENCE_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("sequenceNumber").getter(getter(ReportDetail::sequenceNumber)).setter(setter(Builder::sequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceNumber").build()).build();

    private static final SdkField<String> UPLOAD_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadState").getter(getter(ReportDetail::uploadStateAsString)).setter(setter(Builder::uploadState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadState").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ReportDetail::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, PERIOD_START_FIELD, PERIOD_END_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_AT_FIELD, DELETED_AT_FIELD,
            STATE_FIELD, ARN_FIELD, SERIES_FIELD, CATEGORY_FIELD, COMPANY_NAME_FIELD, PRODUCT_NAME_FIELD, TERM_ARN_FIELD,
            VERSION_FIELD, ACCEPTANCE_TYPE_FIELD, SEQUENCE_NUMBER_FIELD, UPLOAD_STATE_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final Instant periodStart;

    private final Instant periodEnd;

    private final Instant createdAt;

    private final Instant lastModifiedAt;

    private final Instant deletedAt;

    private final String state;

    private final String arn;

    private final String series;

    private final String category;

    private final String companyName;

    private final String productName;

    private final String termArn;

    private final Long version;

    private final String acceptanceType;

    private final Long sequenceNumber;

    private final String uploadState;

    private final String statusMessage;

    private ReportDetail(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.periodStart = builder.periodStart;
        this.periodEnd = builder.periodEnd;
        this.createdAt = builder.createdAt;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.deletedAt = builder.deletedAt;
        this.state = builder.state;
        this.arn = builder.arn;
        this.series = builder.series;
        this.category = builder.category;
        this.companyName = builder.companyName;
        this.productName = builder.productName;
        this.termArn = builder.termArn;
        this.version = builder.version;
        this.acceptanceType = builder.acceptanceType;
        this.sequenceNumber = builder.sequenceNumber;
        this.uploadState = builder.uploadState;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * Unique resource ID for the report resource.
     * </p>
     * 
     * @return Unique resource ID for the report resource.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Name for the report resource.
     * </p>
     * 
     * @return Name for the report resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Description for the report resource.
     * </p>
     * 
     * @return Description for the report resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Timestamp indicating the report resource effective start.
     * </p>
     * 
     * @return Timestamp indicating the report resource effective start.
     */
    public final Instant periodStart() {
        return periodStart;
    }

    /**
     * <p>
     * Timestamp indicating the report resource effective end.
     * </p>
     * 
     * @return Timestamp indicating the report resource effective end.
     */
    public final Instant periodEnd() {
        return periodEnd;
    }

    /**
     * <p>
     * Timestamp indicating when the report resource was created.
     * </p>
     * 
     * @return Timestamp indicating when the report resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Timestamp indicating when the report resource was last modified.
     * </p>
     * 
     * @return Timestamp indicating when the report resource was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * Timestamp indicating when the report resource was deleted.
     * </p>
     * 
     * @return Timestamp indicating when the report resource was deleted.
     */
    public final Instant deletedAt() {
        return deletedAt;
    }

    /**
     * <p>
     * Current state of the report resource
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PublishedState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Current state of the report resource
     * @see PublishedState
     */
    public final PublishedState state() {
        return PublishedState.fromValue(state);
    }

    /**
     * <p>
     * Current state of the report resource
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PublishedState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Current state of the report resource
     * @see PublishedState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * ARN for the report resource.
     * </p>
     * 
     * @return ARN for the report resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Series for the report resource.
     * </p>
     * 
     * @return Series for the report resource.
     */
    public final String series() {
        return series;
    }

    /**
     * <p>
     * Category for the report resource.
     * </p>
     * 
     * @return Category for the report resource.
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * Associated company name for the report resource.
     * </p>
     * 
     * @return Associated company name for the report resource.
     */
    public final String companyName() {
        return companyName;
    }

    /**
     * <p>
     * Associated product name for the report resource.
     * </p>
     * 
     * @return Associated product name for the report resource.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * Unique resource ARN for term resource.
     * </p>
     * 
     * @return Unique resource ARN for term resource.
     */
    public final String termArn() {
        return termArn;
    }

    /**
     * <p>
     * Version for the report resource.
     * </p>
     * 
     * @return Version for the report resource.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * Acceptance type for report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acceptanceType}
     * will return {@link AcceptanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #acceptanceTypeAsString}.
     * </p>
     * 
     * @return Acceptance type for report.
     * @see AcceptanceType
     */
    public final AcceptanceType acceptanceType() {
        return AcceptanceType.fromValue(acceptanceType);
    }

    /**
     * <p>
     * Acceptance type for report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acceptanceType}
     * will return {@link AcceptanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #acceptanceTypeAsString}.
     * </p>
     * 
     * @return Acceptance type for report.
     * @see AcceptanceType
     */
    public final String acceptanceTypeAsString() {
        return acceptanceType;
    }

    /**
     * <p>
     * Sequence number to enforce optimistic locking.
     * </p>
     * 
     * @return Sequence number to enforce optimistic locking.
     */
    public final Long sequenceNumber() {
        return sequenceNumber;
    }

    /**
     * <p>
     * The current state of the document upload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadState} will
     * return {@link UploadState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadStateAsString}.
     * </p>
     * 
     * @return The current state of the document upload.
     * @see UploadState
     */
    public final UploadState uploadState() {
        return UploadState.fromValue(uploadState);
    }

    /**
     * <p>
     * The current state of the document upload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadState} will
     * return {@link UploadState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadStateAsString}.
     * </p>
     * 
     * @return The current state of the document upload.
     * @see UploadState
     */
    public final String uploadStateAsString() {
        return uploadState;
    }

    /**
     * <p>
     * The message associated with the current upload state.
     * </p>
     * 
     * @return The message associated with the current upload state.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(periodStart());
        hashCode = 31 * hashCode + Objects.hashCode(periodEnd());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(deletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(series());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(termArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(uploadStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDetail)) {
            return false;
        }
        ReportDetail other = (ReportDetail) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(periodStart(), other.periodStart())
                && Objects.equals(periodEnd(), other.periodEnd()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(deletedAt(), other.deletedAt())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(series(), other.series()) && Objects.equals(category(), other.category())
                && Objects.equals(companyName(), other.companyName()) && Objects.equals(productName(), other.productName())
                && Objects.equals(termArn(), other.termArn()) && Objects.equals(version(), other.version())
                && Objects.equals(acceptanceTypeAsString(), other.acceptanceTypeAsString())
                && Objects.equals(sequenceNumber(), other.sequenceNumber())
                && Objects.equals(uploadStateAsString(), other.uploadStateAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportDetail").add("Id", id()).add("Name", name()).add("Description", description())
                .add("PeriodStart", periodStart()).add("PeriodEnd", periodEnd()).add("CreatedAt", createdAt())
                .add("LastModifiedAt", lastModifiedAt()).add("DeletedAt", deletedAt()).add("State", stateAsString())
                .add("Arn", arn()).add("Series", series()).add("Category", category()).add("CompanyName", companyName())
                .add("ProductName", productName()).add("TermArn", termArn()).add("Version", version())
                .add("AcceptanceType", acceptanceTypeAsString()).add("SequenceNumber", sequenceNumber())
                .add("UploadState", uploadStateAsString()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "periodStart":
            return Optional.ofNullable(clazz.cast(periodStart()));
        case "periodEnd":
            return Optional.ofNullable(clazz.cast(periodEnd()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "deletedAt":
            return Optional.ofNullable(clazz.cast(deletedAt()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "series":
            return Optional.ofNullable(clazz.cast(series()));
        case "category":
            return Optional.ofNullable(clazz.cast(category()));
        case "companyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "productName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "termArn":
            return Optional.ofNullable(clazz.cast(termArn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "acceptanceType":
            return Optional.ofNullable(clazz.cast(acceptanceTypeAsString()));
        case "sequenceNumber":
            return Optional.ofNullable(clazz.cast(sequenceNumber()));
        case "uploadState":
            return Optional.ofNullable(clazz.cast(uploadStateAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("periodStart", PERIOD_START_FIELD);
        map.put("periodEnd", PERIOD_END_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("deletedAt", DELETED_AT_FIELD);
        map.put("state", STATE_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("series", SERIES_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("companyName", COMPANY_NAME_FIELD);
        map.put("productName", PRODUCT_NAME_FIELD);
        map.put("termArn", TERM_ARN_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("acceptanceType", ACCEPTANCE_TYPE_FIELD);
        map.put("sequenceNumber", SEQUENCE_NUMBER_FIELD);
        map.put("uploadState", UPLOAD_STATE_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportDetail, T> g) {
        return obj -> g.apply((ReportDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportDetail> {
        /**
         * <p>
         * Unique resource ID for the report resource.
         * </p>
         * 
         * @param id
         *        Unique resource ID for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Name for the report resource.
         * </p>
         * 
         * @param name
         *        Name for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description for the report resource.
         * </p>
         * 
         * @param description
         *        Description for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Timestamp indicating the report resource effective start.
         * </p>
         * 
         * @param periodStart
         *        Timestamp indicating the report resource effective start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodStart(Instant periodStart);

        /**
         * <p>
         * Timestamp indicating the report resource effective end.
         * </p>
         * 
         * @param periodEnd
         *        Timestamp indicating the report resource effective end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodEnd(Instant periodEnd);

        /**
         * <p>
         * Timestamp indicating when the report resource was created.
         * </p>
         * 
         * @param createdAt
         *        Timestamp indicating when the report resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Timestamp indicating when the report resource was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        Timestamp indicating when the report resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * Timestamp indicating when the report resource was deleted.
         * </p>
         * 
         * @param deletedAt
         *        Timestamp indicating when the report resource was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedAt(Instant deletedAt);

        /**
         * <p>
         * Current state of the report resource
         * </p>
         * 
         * @param state
         *        Current state of the report resource
         * @see PublishedState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishedState
         */
        Builder state(String state);

        /**
         * <p>
         * Current state of the report resource
         * </p>
         * 
         * @param state
         *        Current state of the report resource
         * @see PublishedState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishedState
         */
        Builder state(PublishedState state);

        /**
         * <p>
         * ARN for the report resource.
         * </p>
         * 
         * @param arn
         *        ARN for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Series for the report resource.
         * </p>
         * 
         * @param series
         *        Series for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder series(String series);

        /**
         * <p>
         * Category for the report resource.
         * </p>
         * 
         * @param category
         *        Category for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * Associated company name for the report resource.
         * </p>
         * 
         * @param companyName
         *        Associated company name for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * Associated product name for the report resource.
         * </p>
         * 
         * @param productName
         *        Associated product name for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * Unique resource ARN for term resource.
         * </p>
         * 
         * @param termArn
         *        Unique resource ARN for term resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termArn(String termArn);

        /**
         * <p>
         * Version for the report resource.
         * </p>
         * 
         * @param version
         *        Version for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * Acceptance type for report.
         * </p>
         * 
         * @param acceptanceType
         *        Acceptance type for report.
         * @see AcceptanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptanceType
         */
        Builder acceptanceType(String acceptanceType);

        /**
         * <p>
         * Acceptance type for report.
         * </p>
         * 
         * @param acceptanceType
         *        Acceptance type for report.
         * @see AcceptanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptanceType
         */
        Builder acceptanceType(AcceptanceType acceptanceType);

        /**
         * <p>
         * Sequence number to enforce optimistic locking.
         * </p>
         * 
         * @param sequenceNumber
         *        Sequence number to enforce optimistic locking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(Long sequenceNumber);

        /**
         * <p>
         * The current state of the document upload.
         * </p>
         * 
         * @param uploadState
         *        The current state of the document upload.
         * @see UploadState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadState
         */
        Builder uploadState(String uploadState);

        /**
         * <p>
         * The current state of the document upload.
         * </p>
         * 
         * @param uploadState
         *        The current state of the document upload.
         * @see UploadState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadState
         */
        Builder uploadState(UploadState uploadState);

        /**
         * <p>
         * The message associated with the current upload state.
         * </p>
         * 
         * @param statusMessage
         *        The message associated with the current upload state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private Instant periodStart;

        private Instant periodEnd;

        private Instant createdAt;

        private Instant lastModifiedAt;

        private Instant deletedAt;

        private String state;

        private String arn;

        private String series;

        private String category;

        private String companyName;

        private String productName;

        private String termArn;

        private Long version;

        private String acceptanceType;

        private Long sequenceNumber;

        private String uploadState;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDetail model) {
            id(model.id);
            name(model.name);
            description(model.description);
            periodStart(model.periodStart);
            periodEnd(model.periodEnd);
            createdAt(model.createdAt);
            lastModifiedAt(model.lastModifiedAt);
            deletedAt(model.deletedAt);
            state(model.state);
            arn(model.arn);
            series(model.series);
            category(model.category);
            companyName(model.companyName);
            productName(model.productName);
            termArn(model.termArn);
            version(model.version);
            acceptanceType(model.acceptanceType);
            sequenceNumber(model.sequenceNumber);
            uploadState(model.uploadState);
            statusMessage(model.statusMessage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getPeriodStart() {
            return periodStart;
        }

        public final void setPeriodStart(Instant periodStart) {
            this.periodStart = periodStart;
        }

        @Override
        public final Builder periodStart(Instant periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        public final Instant getPeriodEnd() {
            return periodEnd;
        }

        public final void setPeriodEnd(Instant periodEnd) {
            this.periodEnd = periodEnd;
        }

        @Override
        public final Builder periodEnd(Instant periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PublishedState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSeries() {
            return series;
        }

        public final void setSeries(String series) {
            this.series = series;
        }

        @Override
        public final Builder series(String series) {
            this.series = series;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getCompanyName() {
            return companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getProductName() {
            return productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getTermArn() {
            return termArn;
        }

        public final void setTermArn(String termArn) {
            this.termArn = termArn;
        }

        @Override
        public final Builder termArn(String termArn) {
            this.termArn = termArn;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getAcceptanceType() {
            return acceptanceType;
        }

        public final void setAcceptanceType(String acceptanceType) {
            this.acceptanceType = acceptanceType;
        }

        @Override
        public final Builder acceptanceType(String acceptanceType) {
            this.acceptanceType = acceptanceType;
            return this;
        }

        @Override
        public final Builder acceptanceType(AcceptanceType acceptanceType) {
            this.acceptanceType(acceptanceType == null ? null : acceptanceType.toString());
            return this;
        }

        public final Long getSequenceNumber() {
            return sequenceNumber;
        }

        public final void setSequenceNumber(Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final String getUploadState() {
            return uploadState;
        }

        public final void setUploadState(String uploadState) {
            this.uploadState = uploadState;
        }

        @Override
        public final Builder uploadState(String uploadState) {
            this.uploadState = uploadState;
            return this;
        }

        @Override
        public final Builder uploadState(UploadState uploadState) {
            this.uploadState(uploadState == null ? null : uploadState.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public ReportDetail build() {
            return new ReportDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
