/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.artifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Account settings for the customer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSettings implements SdkPojo, Serializable, ToCopyableBuilder<AccountSettings.Builder, AccountSettings> {
    private static final SdkField<String> NOTIFICATION_SUBSCRIPTION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("notificationSubscriptionStatus")
            .getter(getter(AccountSettings::notificationSubscriptionStatusAsString))
            .setter(setter(Builder::notificationSubscriptionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSubscriptionStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NOTIFICATION_SUBSCRIPTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String notificationSubscriptionStatus;

    private AccountSettings(BuilderImpl builder) {
        this.notificationSubscriptionStatus = builder.notificationSubscriptionStatus;
    }

    /**
     * <p>
     * Notification subscription status of the customer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notificationSubscriptionStatus} will return {@link NotificationSubscriptionStatus#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #notificationSubscriptionStatusAsString}.
     * </p>
     * 
     * @return Notification subscription status of the customer.
     * @see NotificationSubscriptionStatus
     */
    public final NotificationSubscriptionStatus notificationSubscriptionStatus() {
        return NotificationSubscriptionStatus.fromValue(notificationSubscriptionStatus);
    }

    /**
     * <p>
     * Notification subscription status of the customer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notificationSubscriptionStatus} will return {@link NotificationSubscriptionStatus#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #notificationSubscriptionStatusAsString}.
     * </p>
     * 
     * @return Notification subscription status of the customer.
     * @see NotificationSubscriptionStatus
     */
    public final String notificationSubscriptionStatusAsString() {
        return notificationSubscriptionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notificationSubscriptionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings) obj;
        return Objects.equals(notificationSubscriptionStatusAsString(), other.notificationSubscriptionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountSettings")
                .add("NotificationSubscriptionStatus", notificationSubscriptionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "notificationSubscriptionStatus":
            return Optional.ofNullable(clazz.cast(notificationSubscriptionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("notificationSubscriptionStatus", NOTIFICATION_SUBSCRIPTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountSettings, T> g) {
        return obj -> g.apply((AccountSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSettings> {
        /**
         * <p>
         * Notification subscription status of the customer.
         * </p>
         * 
         * @param notificationSubscriptionStatus
         *        Notification subscription status of the customer.
         * @see NotificationSubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationSubscriptionStatus
         */
        Builder notificationSubscriptionStatus(String notificationSubscriptionStatus);

        /**
         * <p>
         * Notification subscription status of the customer.
         * </p>
         * 
         * @param notificationSubscriptionStatus
         *        Notification subscription status of the customer.
         * @see NotificationSubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationSubscriptionStatus
         */
        Builder notificationSubscriptionStatus(NotificationSubscriptionStatus notificationSubscriptionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String notificationSubscriptionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            notificationSubscriptionStatus(model.notificationSubscriptionStatus);
        }

        public final String getNotificationSubscriptionStatus() {
            return notificationSubscriptionStatus;
        }

        public final void setNotificationSubscriptionStatus(String notificationSubscriptionStatus) {
            this.notificationSubscriptionStatus = notificationSubscriptionStatus;
        }

        @Override
        public final Builder notificationSubscriptionStatus(String notificationSubscriptionStatus) {
            this.notificationSubscriptionStatus = notificationSubscriptionStatus;
            return this;
        }

        @Override
        public final Builder notificationSubscriptionStatus(NotificationSubscriptionStatus notificationSubscriptionStatus) {
            this.notificationSubscriptionStatus(notificationSubscriptionStatus == null ? null : notificationSubscriptionStatus
                    .toString());
            return this;
        }

        @Override
        public AccountSettings build() {
            return new AccountSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
