/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.artifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTermForReportRequest extends ArtifactRequest implements
        ToCopyableBuilder<GetTermForReportRequest.Builder, GetTermForReportRequest> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportId").getter(getter(GetTermForReportRequest::reportId)).setter(setter(Builder::reportId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reportId").build()).build();

    private static final SdkField<Long> REPORT_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("reportVersion").getter(getter(GetTermForReportRequest::reportVersion))
            .setter(setter(Builder::reportVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reportVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD,
            REPORT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reportId;

    private final Long reportVersion;

    private GetTermForReportRequest(BuilderImpl builder) {
        super(builder);
        this.reportId = builder.reportId;
        this.reportVersion = builder.reportVersion;
    }

    /**
     * <p>
     * Unique resource ID for the report resource.
     * </p>
     * 
     * @return Unique resource ID for the report resource.
     */
    public final String reportId() {
        return reportId;
    }

    /**
     * <p>
     * Version for the report resource.
     * </p>
     * 
     * @return Version for the report resource.
     */
    public final Long reportVersion() {
        return reportVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportId());
        hashCode = 31 * hashCode + Objects.hashCode(reportVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTermForReportRequest)) {
            return false;
        }
        GetTermForReportRequest other = (GetTermForReportRequest) obj;
        return Objects.equals(reportId(), other.reportId()) && Objects.equals(reportVersion(), other.reportVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTermForReportRequest").add("ReportId", reportId()).add("ReportVersion", reportVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportId":
            return Optional.ofNullable(clazz.cast(reportId()));
        case "reportVersion":
            return Optional.ofNullable(clazz.cast(reportVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reportId", REPORT_ID_FIELD);
        map.put("reportVersion", REPORT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTermForReportRequest, T> g) {
        return obj -> g.apply((GetTermForReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArtifactRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTermForReportRequest> {
        /**
         * <p>
         * Unique resource ID for the report resource.
         * </p>
         * 
         * @param reportId
         *        Unique resource ID for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportId(String reportId);

        /**
         * <p>
         * Version for the report resource.
         * </p>
         * 
         * @param reportVersion
         *        Version for the report resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportVersion(Long reportVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArtifactRequest.BuilderImpl implements Builder {
        private String reportId;

        private Long reportVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTermForReportRequest model) {
            super(model);
            reportId(model.reportId);
            reportVersion(model.reportVersion);
        }

        public final String getReportId() {
            return reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final Long getReportVersion() {
            return reportVersion;
        }

        public final void setReportVersion(Long reportVersion) {
            this.reportVersion = reportVersion;
        }

        @Override
        public final Builder reportVersion(Long reportVersion) {
            this.reportVersion = reportVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTermForReportRequest build() {
            return new GetTermForReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
