/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.artifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary for customer-agreement resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerAgreementSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerAgreementSummary.Builder, CustomerAgreementSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CustomerAgreementSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CustomerAgreementSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CustomerAgreementSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> AGREEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agreementArn").getter(getter(CustomerAgreementSummary::agreementArn))
            .setter(setter(Builder::agreementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementArn").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(CustomerAgreementSummary::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> ORGANIZATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationArn").getter(getter(CustomerAgreementSummary::organizationArn))
            .setter(setter(Builder::organizationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationArn").build()).build();

    private static final SdkField<Instant> EFFECTIVE_START_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("effectiveStart")
            .getter(getter(CustomerAgreementSummary::effectiveStart))
            .setter(setter(Builder::effectiveStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveStart").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> EFFECTIVE_END_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("effectiveEnd")
            .getter(getter(CustomerAgreementSummary::effectiveEnd))
            .setter(setter(Builder::effectiveEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveEnd").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(CustomerAgreementSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CustomerAgreementSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> ACCEPTANCE_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("acceptanceTerms")
            .getter(getter(CustomerAgreementSummary::acceptanceTerms))
            .setter(setter(Builder::acceptanceTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptanceTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TERMINATE_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("terminateTerms")
            .getter(getter(CustomerAgreementSummary::terminateTerms))
            .setter(setter(Builder::terminateTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CustomerAgreementSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            ID_FIELD, AGREEMENT_ARN_FIELD, AWS_ACCOUNT_ID_FIELD, ORGANIZATION_ARN_FIELD, EFFECTIVE_START_FIELD,
            EFFECTIVE_END_FIELD, STATE_FIELD, DESCRIPTION_FIELD, ACCEPTANCE_TERMS_FIELD, TERMINATE_TERMS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String id;

    private final String agreementArn;

    private final String awsAccountId;

    private final String organizationArn;

    private final Instant effectiveStart;

    private final Instant effectiveEnd;

    private final String state;

    private final String description;

    private final List<String> acceptanceTerms;

    private final List<String> terminateTerms;

    private final String type;

    private CustomerAgreementSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.id = builder.id;
        this.agreementArn = builder.agreementArn;
        this.awsAccountId = builder.awsAccountId;
        this.organizationArn = builder.organizationArn;
        this.effectiveStart = builder.effectiveStart;
        this.effectiveEnd = builder.effectiveEnd;
        this.state = builder.state;
        this.description = builder.description;
        this.acceptanceTerms = builder.acceptanceTerms;
        this.terminateTerms = builder.terminateTerms;
        this.type = builder.type;
    }

    /**
     * <p>
     * Name of the customer-agreement resource.
     * </p>
     * 
     * @return Name of the customer-agreement resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * ARN of the customer-agreement resource.
     * </p>
     * 
     * @return ARN of the customer-agreement resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Identifier of the customer-agreement resource.
     * </p>
     * 
     * @return Identifier of the customer-agreement resource.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * ARN of the agreement resource the customer-agreement resource represents.
     * </p>
     * 
     * @return ARN of the agreement resource the customer-agreement resource represents.
     */
    public final String agreementArn() {
        return agreementArn;
    }

    /**
     * <p>
     * AWS account Id that owns the resource.
     * </p>
     * 
     * @return AWS account Id that owns the resource.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * ARN of the organization that owns the resource.
     * </p>
     * 
     * @return ARN of the organization that owns the resource.
     */
    public final String organizationArn() {
        return organizationArn;
    }

    /**
     * <p>
     * Timestamp indicating when the agreement became effective.
     * </p>
     * 
     * @return Timestamp indicating when the agreement became effective.
     */
    public final Instant effectiveStart() {
        return effectiveStart;
    }

    /**
     * <p>
     * Timestamp indicating when the agreement was terminated.
     * </p>
     * 
     * @return Timestamp indicating when the agreement was terminated.
     */
    public final Instant effectiveEnd() {
        return effectiveEnd;
    }

    /**
     * <p>
     * State of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CustomerAgreementState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the resource.
     * @see CustomerAgreementState
     */
    public final CustomerAgreementState state() {
        return CustomerAgreementState.fromValue(state);
    }

    /**
     * <p>
     * State of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CustomerAgreementState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the resource.
     * @see CustomerAgreementState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Description of the resource.
     * </p>
     * 
     * @return Description of the resource.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceptanceTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceptanceTerms() {
        return acceptanceTerms != null && !(acceptanceTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Terms required to accept the agreement resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceptanceTerms} method.
     * </p>
     * 
     * @return Terms required to accept the agreement resource.
     */
    public final List<String> acceptanceTerms() {
        return acceptanceTerms;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerminateTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTerminateTerms() {
        return terminateTerms != null && !(terminateTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Terms required to terminate the customer-agreement resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerminateTerms} method.
     * </p>
     * 
     * @return Terms required to terminate the customer-agreement resource.
     */
    public final List<String> terminateTerms() {
        return terminateTerms;
    }

    /**
     * <p>
     * Type of the customer-agreement resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AgreementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the customer-agreement resource.
     * @see AgreementType
     */
    public final AgreementType type() {
        return AgreementType.fromValue(type);
    }

    /**
     * <p>
     * Type of the customer-agreement resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AgreementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the customer-agreement resource.
     * @see AgreementType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(agreementArn());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationArn());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveStart());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveEnd());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceptanceTerms() ? acceptanceTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTerminateTerms() ? terminateTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerAgreementSummary)) {
            return false;
        }
        CustomerAgreementSummary other = (CustomerAgreementSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(agreementArn(), other.agreementArn()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(organizationArn(), other.organizationArn())
                && Objects.equals(effectiveStart(), other.effectiveStart())
                && Objects.equals(effectiveEnd(), other.effectiveEnd()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(description(), other.description()) && hasAcceptanceTerms() == other.hasAcceptanceTerms()
                && Objects.equals(acceptanceTerms(), other.acceptanceTerms()) && hasTerminateTerms() == other.hasTerminateTerms()
                && Objects.equals(terminateTerms(), other.terminateTerms())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerAgreementSummary").add("Name", name()).add("Arn", arn()).add("Id", id())
                .add("AgreementArn", agreementArn()).add("AwsAccountId", awsAccountId())
                .add("OrganizationArn", organizationArn()).add("EffectiveStart", effectiveStart())
                .add("EffectiveEnd", effectiveEnd()).add("State", stateAsString()).add("Description", description())
                .add("AcceptanceTerms", hasAcceptanceTerms() ? acceptanceTerms() : null)
                .add("TerminateTerms", hasTerminateTerms() ? terminateTerms() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "agreementArn":
            return Optional.ofNullable(clazz.cast(agreementArn()));
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "organizationArn":
            return Optional.ofNullable(clazz.cast(organizationArn()));
        case "effectiveStart":
            return Optional.ofNullable(clazz.cast(effectiveStart()));
        case "effectiveEnd":
            return Optional.ofNullable(clazz.cast(effectiveEnd()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "acceptanceTerms":
            return Optional.ofNullable(clazz.cast(acceptanceTerms()));
        case "terminateTerms":
            return Optional.ofNullable(clazz.cast(terminateTerms()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("agreementArn", AGREEMENT_ARN_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("organizationArn", ORGANIZATION_ARN_FIELD);
        map.put("effectiveStart", EFFECTIVE_START_FIELD);
        map.put("effectiveEnd", EFFECTIVE_END_FIELD);
        map.put("state", STATE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("acceptanceTerms", ACCEPTANCE_TERMS_FIELD);
        map.put("terminateTerms", TERMINATE_TERMS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerAgreementSummary, T> g) {
        return obj -> g.apply((CustomerAgreementSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerAgreementSummary> {
        /**
         * <p>
         * Name of the customer-agreement resource.
         * </p>
         * 
         * @param name
         *        Name of the customer-agreement resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * ARN of the customer-agreement resource.
         * </p>
         * 
         * @param arn
         *        ARN of the customer-agreement resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Identifier of the customer-agreement resource.
         * </p>
         * 
         * @param id
         *        Identifier of the customer-agreement resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * ARN of the agreement resource the customer-agreement resource represents.
         * </p>
         * 
         * @param agreementArn
         *        ARN of the agreement resource the customer-agreement resource represents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementArn(String agreementArn);

        /**
         * <p>
         * AWS account Id that owns the resource.
         * </p>
         * 
         * @param awsAccountId
         *        AWS account Id that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * ARN of the organization that owns the resource.
         * </p>
         * 
         * @param organizationArn
         *        ARN of the organization that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationArn(String organizationArn);

        /**
         * <p>
         * Timestamp indicating when the agreement became effective.
         * </p>
         * 
         * @param effectiveStart
         *        Timestamp indicating when the agreement became effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveStart(Instant effectiveStart);

        /**
         * <p>
         * Timestamp indicating when the agreement was terminated.
         * </p>
         * 
         * @param effectiveEnd
         *        Timestamp indicating when the agreement was terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveEnd(Instant effectiveEnd);

        /**
         * <p>
         * State of the resource.
         * </p>
         * 
         * @param state
         *        State of the resource.
         * @see CustomerAgreementState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerAgreementState
         */
        Builder state(String state);

        /**
         * <p>
         * State of the resource.
         * </p>
         * 
         * @param state
         *        State of the resource.
         * @see CustomerAgreementState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerAgreementState
         */
        Builder state(CustomerAgreementState state);

        /**
         * <p>
         * Description of the resource.
         * </p>
         * 
         * @param description
         *        Description of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Terms required to accept the agreement resource.
         * </p>
         * 
         * @param acceptanceTerms
         *        Terms required to accept the agreement resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceTerms(Collection<String> acceptanceTerms);

        /**
         * <p>
         * Terms required to accept the agreement resource.
         * </p>
         * 
         * @param acceptanceTerms
         *        Terms required to accept the agreement resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceTerms(String... acceptanceTerms);

        /**
         * <p>
         * Terms required to terminate the customer-agreement resource.
         * </p>
         * 
         * @param terminateTerms
         *        Terms required to terminate the customer-agreement resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateTerms(Collection<String> terminateTerms);

        /**
         * <p>
         * Terms required to terminate the customer-agreement resource.
         * </p>
         * 
         * @param terminateTerms
         *        Terms required to terminate the customer-agreement resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateTerms(String... terminateTerms);

        /**
         * <p>
         * Type of the customer-agreement resource.
         * </p>
         * 
         * @param type
         *        Type of the customer-agreement resource.
         * @see AgreementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgreementType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the customer-agreement resource.
         * </p>
         * 
         * @param type
         *        Type of the customer-agreement resource.
         * @see AgreementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgreementType
         */
        Builder type(AgreementType type);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String id;

        private String agreementArn;

        private String awsAccountId;

        private String organizationArn;

        private Instant effectiveStart;

        private Instant effectiveEnd;

        private String state;

        private String description;

        private List<String> acceptanceTerms = DefaultSdkAutoConstructList.getInstance();

        private List<String> terminateTerms = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerAgreementSummary model) {
            name(model.name);
            arn(model.arn);
            id(model.id);
            agreementArn(model.agreementArn);
            awsAccountId(model.awsAccountId);
            organizationArn(model.organizationArn);
            effectiveStart(model.effectiveStart);
            effectiveEnd(model.effectiveEnd);
            state(model.state);
            description(model.description);
            acceptanceTerms(model.acceptanceTerms);
            terminateTerms(model.terminateTerms);
            type(model.type);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAgreementArn() {
            return agreementArn;
        }

        public final void setAgreementArn(String agreementArn) {
            this.agreementArn = agreementArn;
        }

        @Override
        public final Builder agreementArn(String agreementArn) {
            this.agreementArn = agreementArn;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getOrganizationArn() {
            return organizationArn;
        }

        public final void setOrganizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
        }

        @Override
        public final Builder organizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
            return this;
        }

        public final Instant getEffectiveStart() {
            return effectiveStart;
        }

        public final void setEffectiveStart(Instant effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        @Override
        public final Builder effectiveStart(Instant effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final Instant getEffectiveEnd() {
            return effectiveEnd;
        }

        public final void setEffectiveEnd(Instant effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
        }

        @Override
        public final Builder effectiveEnd(Instant effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CustomerAgreementState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getAcceptanceTerms() {
            if (acceptanceTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return acceptanceTerms;
        }

        public final void setAcceptanceTerms(Collection<String> acceptanceTerms) {
            this.acceptanceTerms = AgreementTermsCopier.copy(acceptanceTerms);
        }

        @Override
        public final Builder acceptanceTerms(Collection<String> acceptanceTerms) {
            this.acceptanceTerms = AgreementTermsCopier.copy(acceptanceTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptanceTerms(String... acceptanceTerms) {
            acceptanceTerms(Arrays.asList(acceptanceTerms));
            return this;
        }

        public final Collection<String> getTerminateTerms() {
            if (terminateTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return terminateTerms;
        }

        public final void setTerminateTerms(Collection<String> terminateTerms) {
            this.terminateTerms = AgreementTermsCopier.copy(terminateTerms);
        }

        @Override
        public final Builder terminateTerms(Collection<String> terminateTerms) {
            this.terminateTerms = AgreementTermsCopier.copy(terminateTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminateTerms(String... terminateTerms) {
            terminateTerms(Arrays.asList(terminateTerms));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AgreementType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public CustomerAgreementSummary build() {
            return new CustomerAgreementSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
