/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNamedQueryRequest extends AthenaRequest implements
        ToCopyableBuilder<GetNamedQueryRequest.Builder, GetNamedQueryRequest> {
    private static final SdkField<String> NAMED_QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetNamedQueryRequest::namedQueryId)).setter(setter(Builder::namedQueryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERY_ID_FIELD));

    private final String namedQueryId;

    private GetNamedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.namedQueryId = builder.namedQueryId;
    }

    /**
     * <p>
     * The unique ID of the query. Use <a>ListNamedQueries</a> to get query IDs.
     * </p>
     * 
     * @return The unique ID of the query. Use <a>ListNamedQueries</a> to get query IDs.
     */
    public String namedQueryId() {
        return namedQueryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namedQueryId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNamedQueryRequest)) {
            return false;
        }
        GetNamedQueryRequest other = (GetNamedQueryRequest) obj;
        return Objects.equals(namedQueryId(), other.namedQueryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetNamedQueryRequest").add("NamedQueryId", namedQueryId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamedQueryId":
            return Optional.ofNullable(clazz.cast(namedQueryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNamedQueryRequest, T> g) {
        return obj -> g.apply((GetNamedQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetNamedQueryRequest> {
        /**
         * <p>
         * The unique ID of the query. Use <a>ListNamedQueries</a> to get query IDs.
         * </p>
         * 
         * @param namedQueryId
         *        The unique ID of the query. Use <a>ListNamedQueries</a> to get query IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQueryId(String namedQueryId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String namedQueryId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNamedQueryRequest model) {
            super(model);
            namedQueryId(model.namedQueryId);
        }

        public final String getNamedQueryId() {
            return namedQueryId;
        }

        @Override
        public final Builder namedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
            return this;
        }

        public final void setNamedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetNamedQueryRequest build() {
            return new GetNamedQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
