/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.Database;
import software.amazon.awssdk.services.athena.model.DatabaseListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatabasesResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListDatabasesResponse> {
    private static final SdkField<List<Database>> DATABASE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatabaseList").getter(ListDatabasesResponse.getter(ListDatabasesResponse::databaseList)).setter(ListDatabasesResponse.setter(Builder::databaseList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Database::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDatabasesResponse.getter(ListDatabasesResponse::nextToken)).setter(ListDatabasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<Database> databaseList;
    private final String nextToken;

    private ListDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.databaseList = builder.databaseList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDatabaseList() {
        return this.databaseList != null && !(this.databaseList instanceof SdkAutoConstructList);
    }

    public List<Database> databaseList() {
        return this.databaseList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatabasesResponse)) {
            return false;
        }
        ListDatabasesResponse other = (ListDatabasesResponse)((Object)obj);
        return Objects.equals(this.databaseList(), other.databaseList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDatabasesResponse").add("DatabaseList", this.databaseList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseList": {
                return Optional.ofNullable(clazz.cast(this.databaseList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatabasesResponse, T> g) {
        return obj -> g.apply((ListDatabasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private List<Database> databaseList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatabasesResponse model) {
            super(model);
            this.databaseList(model.databaseList);
            this.nextToken(model.nextToken);
        }

        public final Collection<Database.Builder> getDatabaseList() {
            return this.databaseList != null ? (Collection)this.databaseList.stream().map(Database::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder databaseList(Collection<Database> databaseList) {
            this.databaseList = DatabaseListCopier.copy(databaseList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseList(Database ... databaseList) {
            this.databaseList(Arrays.asList(databaseList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseList(Consumer<Database.Builder> ... databaseList) {
            this.databaseList(Stream.of(databaseList).map(c -> (Database)((Database.Builder)Database.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatabaseList(Collection<Database.BuilderImpl> databaseList) {
            this.databaseList = DatabaseListCopier.copyFromBuilder(databaseList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDatabasesResponse build() {
            return new ListDatabasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatabasesResponse> {
        public Builder databaseList(Collection<Database> var1);

        public Builder databaseList(Database ... var1);

        public Builder databaseList(Consumer<Database.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

