/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A piece of data (a field in the table).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Datum implements SdkPojo, Serializable, ToCopyableBuilder<Datum.Builder, Datum> {
    private static final SdkField<String> VAR_CHAR_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VarCharValue").getter(getter(Datum::varCharValue)).setter(setter(Builder::varCharValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VarCharValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VAR_CHAR_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String varCharValue;

    private Datum(BuilderImpl builder) {
        this.varCharValue = builder.varCharValue;
    }

    /**
     * <p>
     * The value of the datum.
     * </p>
     * 
     * @return The value of the datum.
     */
    public final String varCharValue() {
        return varCharValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(varCharValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Datum)) {
            return false;
        }
        Datum other = (Datum) obj;
        return Objects.equals(varCharValue(), other.varCharValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Datum").add("VarCharValue", varCharValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VarCharValue":
            return Optional.ofNullable(clazz.cast(varCharValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Datum, T> g) {
        return obj -> g.apply((Datum) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Datum> {
        /**
         * <p>
         * The value of the datum.
         * </p>
         * 
         * @param varCharValue
         *        The value of the datum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder varCharValue(String varCharValue);
    }

    static final class BuilderImpl implements Builder {
        private String varCharValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Datum model) {
            varCharValue(model.varCharValue);
        }

        public final String getVarCharValue() {
            return varCharValue;
        }

        @Override
        public final Builder varCharValue(String varCharValue) {
            this.varCharValue = varCharValue;
            return this;
        }

        public final void setVarCharValue(String varCharValue) {
            this.varCharValue = varCharValue;
        }

        @Override
        public Datum build() {
            return new Datum(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
