/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTableMetadataResponse extends AthenaResponse implements
        ToCopyableBuilder<ListTableMetadataResponse.Builder, ListTableMetadataResponse> {
    private static final SdkField<List<TableMetadata>> TABLE_METADATA_LIST_FIELD = SdkField
            .<List<TableMetadata>> builder(MarshallingType.LIST)
            .memberName("TableMetadataList")
            .getter(getter(ListTableMetadataResponse::tableMetadataList))
            .setter(setter(Builder::tableMetadataList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMetadataList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTableMetadataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_METADATA_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TableMetadata> tableMetadataList;

    private final String nextToken;

    private ListTableMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.tableMetadataList = builder.tableMetadataList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TableMetadataList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTableMetadataList() {
        return tableMetadataList != null && !(tableMetadataList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of table metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTableMetadataList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of table metadata.
     */
    public final List<TableMetadata> tableMetadataList() {
        return tableMetadataList;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page
     * call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the
     *         previous page call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTableMetadataList() ? tableMetadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableMetadataResponse)) {
            return false;
        }
        ListTableMetadataResponse other = (ListTableMetadataResponse) obj;
        return hasTableMetadataList() == other.hasTableMetadataList()
                && Objects.equals(tableMetadataList(), other.tableMetadataList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTableMetadataResponse")
                .add("TableMetadataList", hasTableMetadataList() ? tableMetadataList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableMetadataList":
            return Optional.ofNullable(clazz.cast(tableMetadataList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTableMetadataResponse, T> g) {
        return obj -> g.apply((ListTableMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTableMetadataResponse> {
        /**
         * <p>
         * A list of table metadata.
         * </p>
         * 
         * @param tableMetadataList
         *        A list of table metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMetadataList(Collection<TableMetadata> tableMetadataList);

        /**
         * <p>
         * A list of table metadata.
         * </p>
         * 
         * @param tableMetadataList
         *        A list of table metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMetadataList(TableMetadata... tableMetadataList);

        /**
         * <p>
         * A list of table metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TableMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<TableMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TableMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #tableMetadataList(List<TableMetadata>)}.
         * 
         * @param tableMetadataList
         *        a consumer that will call methods on {@link List<TableMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableMetadataList(List<TableMetadata>)
         */
        Builder tableMetadataList(Consumer<TableMetadata.Builder>... tableMetadataList);

        /**
         * <p>
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was
         * truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous
         * page call.
         * </p>
         * 
         * @param nextToken
         *        A token generated by the Athena service that specifies where to continue pagination if a previous
         *        request was truncated. To obtain the next set of pages, pass in the NextToken from the response object
         *        of the previous page call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private List<TableMetadata> tableMetadataList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableMetadataResponse model) {
            super(model);
            tableMetadataList(model.tableMetadataList);
            nextToken(model.nextToken);
        }

        public final List<TableMetadata.Builder> getTableMetadataList() {
            List<TableMetadata.Builder> result = TableMetadataListCopier.copyToBuilder(this.tableMetadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tableMetadataList(Collection<TableMetadata> tableMetadataList) {
            this.tableMetadataList = TableMetadataListCopier.copy(tableMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableMetadataList(TableMetadata... tableMetadataList) {
            tableMetadataList(Arrays.asList(tableMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableMetadataList(Consumer<TableMetadata.Builder>... tableMetadataList) {
            tableMetadataList(Stream.of(tableMetadataList).map(c -> TableMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTableMetadataList(Collection<TableMetadata.BuilderImpl> tableMetadataList) {
            this.tableMetadataList = TableMetadataListCopier.copyFromBuilder(tableMetadataList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTableMetadataResponse build() {
            return new ListTableMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
