/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A prepared SQL statement for use with Athena.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PreparedStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<PreparedStatement.Builder, PreparedStatement> {
    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(PreparedStatement::statementName)).setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<String> QUERY_STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryStatement").getter(getter(PreparedStatement::queryStatement))
            .setter(setter(Builder::queryStatement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatement").build()).build();

    private static final SdkField<String> WORK_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroupName").getter(getter(PreparedStatement::workGroupName)).setter(setter(Builder::workGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PreparedStatement::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(PreparedStatement::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_NAME_FIELD,
            QUERY_STATEMENT_FIELD, WORK_GROUP_NAME_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String statementName;

    private final String queryStatement;

    private final String workGroupName;

    private final String description;

    private final Instant lastModifiedTime;

    private PreparedStatement(BuilderImpl builder) {
        this.statementName = builder.statementName;
        this.queryStatement = builder.queryStatement;
        this.workGroupName = builder.workGroupName;
        this.description = builder.description;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The name of the prepared statement.
     * </p>
     * 
     * @return The name of the prepared statement.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * The query string for the prepared statement.
     * </p>
     * 
     * @return The query string for the prepared statement.
     */
    public final String queryStatement() {
        return queryStatement;
    }

    /**
     * <p>
     * The name of the workgroup to which the prepared statement belongs.
     * </p>
     * 
     * @return The name of the workgroup to which the prepared statement belongs.
     */
    public final String workGroupName() {
        return workGroupName;
    }

    /**
     * <p>
     * The description of the prepared statement.
     * </p>
     * 
     * @return The description of the prepared statement.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The last modified time of the prepared statement.
     * </p>
     * 
     * @return The last modified time of the prepared statement.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(queryStatement());
        hashCode = 31 * hashCode + Objects.hashCode(workGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreparedStatement)) {
            return false;
        }
        PreparedStatement other = (PreparedStatement) obj;
        return Objects.equals(statementName(), other.statementName()) && Objects.equals(queryStatement(), other.queryStatement())
                && Objects.equals(workGroupName(), other.workGroupName()) && Objects.equals(description(), other.description())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PreparedStatement").add("StatementName", statementName())
                .add("QueryStatement", queryStatement()).add("WorkGroupName", workGroupName()).add("Description", description())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "QueryStatement":
            return Optional.ofNullable(clazz.cast(queryStatement()));
        case "WorkGroupName":
            return Optional.ofNullable(clazz.cast(workGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PreparedStatement, T> g) {
        return obj -> g.apply((PreparedStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PreparedStatement> {
        /**
         * <p>
         * The name of the prepared statement.
         * </p>
         * 
         * @param statementName
         *        The name of the prepared statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * The query string for the prepared statement.
         * </p>
         * 
         * @param queryStatement
         *        The query string for the prepared statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStatement(String queryStatement);

        /**
         * <p>
         * The name of the workgroup to which the prepared statement belongs.
         * </p>
         * 
         * @param workGroupName
         *        The name of the workgroup to which the prepared statement belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroupName(String workGroupName);

        /**
         * <p>
         * The description of the prepared statement.
         * </p>
         * 
         * @param description
         *        The description of the prepared statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The last modified time of the prepared statement.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time of the prepared statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String statementName;

        private String queryStatement;

        private String workGroupName;

        private String description;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PreparedStatement model) {
            statementName(model.statementName);
            queryStatement(model.queryStatement);
            workGroupName(model.workGroupName);
            description(model.description);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getStatementName() {
            return statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        public final String getQueryStatement() {
            return queryStatement;
        }

        @Override
        public final Builder queryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        public final void setQueryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
        }

        public final String getWorkGroupName() {
            return workGroupName;
        }

        @Override
        public final Builder workGroupName(String workGroupName) {
            this.workGroupName = workGroupName;
            return this;
        }

        public final void setWorkGroupName(String workGroupName) {
            this.workGroupName = workGroupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public PreparedStatement build() {
            return new PreparedStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
