/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableMetadataResponse extends AthenaResponse implements
        ToCopyableBuilder<GetTableMetadataResponse.Builder, GetTableMetadataResponse> {
    private static final SdkField<TableMetadata> TABLE_METADATA_FIELD = SdkField
            .<TableMetadata> builder(MarshallingType.SDK_POJO).memberName("TableMetadata")
            .getter(getter(GetTableMetadataResponse::tableMetadata)).setter(setter(Builder::tableMetadata))
            .constructor(TableMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_METADATA_FIELD));

    private final TableMetadata tableMetadata;

    private GetTableMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.tableMetadata = builder.tableMetadata;
    }

    /**
     * <p>
     * An object that contains table metadata.
     * </p>
     * 
     * @return An object that contains table metadata.
     */
    public final TableMetadata tableMetadata() {
        return tableMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableMetadataResponse)) {
            return false;
        }
        GetTableMetadataResponse other = (GetTableMetadataResponse) obj;
        return Objects.equals(tableMetadata(), other.tableMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableMetadataResponse").add("TableMetadata", tableMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableMetadata":
            return Optional.ofNullable(clazz.cast(tableMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTableMetadataResponse, T> g) {
        return obj -> g.apply((GetTableMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTableMetadataResponse> {
        /**
         * <p>
         * An object that contains table metadata.
         * </p>
         * 
         * @param tableMetadata
         *        An object that contains table metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMetadata(TableMetadata tableMetadata);

        /**
         * <p>
         * An object that contains table metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link TableMetadata.Builder} avoiding the need to
         * create one manually via {@link TableMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #tableMetadata(TableMetadata)}.
         * 
         * @param tableMetadata
         *        a consumer that will call methods on {@link TableMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableMetadata(TableMetadata)
         */
        default Builder tableMetadata(Consumer<TableMetadata.Builder> tableMetadata) {
            return tableMetadata(TableMetadata.builder().applyMutation(tableMetadata).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private TableMetadata tableMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableMetadataResponse model) {
            super(model);
            tableMetadata(model.tableMetadata);
        }

        public final TableMetadata.Builder getTableMetadata() {
            return tableMetadata != null ? tableMetadata.toBuilder() : null;
        }

        public final void setTableMetadata(TableMetadata.BuilderImpl tableMetadata) {
            this.tableMetadata = tableMetadata != null ? tableMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder tableMetadata(TableMetadata tableMetadata) {
            this.tableMetadata = tableMetadata;
            return this;
        }

        @Override
        public GetTableMetadataResponse build() {
            return new GetTableMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
