/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata and rows that make up a query result set. The metadata describes the column structure and data types. To
 * return a <code>ResultSet</code> object, use <a>GetQueryResults</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultSet implements SdkPojo, Serializable, ToCopyableBuilder<ResultSet.Builder, ResultSet> {
    private static final SdkField<List<Row>> ROWS_FIELD = SdkField
            .<List<Row>> builder(MarshallingType.LIST)
            .memberName("Rows")
            .getter(getter(ResultSet::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Row> builder(MarshallingType.SDK_POJO)
                                            .constructor(Row::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResultSetMetadata> RESULT_SET_METADATA_FIELD = SdkField
            .<ResultSetMetadata> builder(MarshallingType.SDK_POJO).memberName("ResultSetMetadata")
            .getter(getter(ResultSet::resultSetMetadata)).setter(setter(Builder::resultSetMetadata))
            .constructor(ResultSetMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSetMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD,
            RESULT_SET_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Row> rows;

    private final ResultSetMetadata resultSetMetadata;

    private ResultSet(BuilderImpl builder) {
        this.rows = builder.rows;
        this.resultSetMetadata = builder.resultSetMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rows in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRows} method.
     * </p>
     * 
     * @return The rows in the table.
     */
    public final List<Row> rows() {
        return rows;
    }

    /**
     * <p>
     * The metadata that describes the column structure and data types of a table of query results.
     * </p>
     * 
     * @return The metadata that describes the column structure and data types of a table of query results.
     */
    public final ResultSetMetadata resultSetMetadata() {
        return resultSetMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRows() ? rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resultSetMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet) obj;
        return hasRows() == other.hasRows() && Objects.equals(rows(), other.rows())
                && Objects.equals(resultSetMetadata(), other.resultSetMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultSet").add("Rows", hasRows() ? rows() : null).add("ResultSetMetadata", resultSetMetadata())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rows":
            return Optional.ofNullable(clazz.cast(rows()));
        case "ResultSetMetadata":
            return Optional.ofNullable(clazz.cast(resultSetMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultSet, T> g) {
        return obj -> g.apply((ResultSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultSet> {
        /**
         * <p>
         * The rows in the table.
         * </p>
         * 
         * @param rows
         *        The rows in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Collection<Row> rows);

        /**
         * <p>
         * The rows in the table.
         * </p>
         * 
         * @param rows
         *        The rows in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Row... rows);

        /**
         * <p>
         * The rows in the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Row>.Builder} avoiding the need to
         * create one manually via {@link List<Row>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Row>.Builder#build()} is called immediately and its result
         * is passed to {@link #rows(List<Row>)}.
         * 
         * @param rows
         *        a consumer that will call methods on {@link List<Row>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(List<Row>)
         */
        Builder rows(Consumer<Row.Builder>... rows);

        /**
         * <p>
         * The metadata that describes the column structure and data types of a table of query results.
         * </p>
         * 
         * @param resultSetMetadata
         *        The metadata that describes the column structure and data types of a table of query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultSetMetadata(ResultSetMetadata resultSetMetadata);

        /**
         * <p>
         * The metadata that describes the column structure and data types of a table of query results.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResultSetMetadata.Builder} avoiding the
         * need to create one manually via {@link ResultSetMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResultSetMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #resultSetMetadata(ResultSetMetadata)}.
         * 
         * @param resultSetMetadata
         *        a consumer that will call methods on {@link ResultSetMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultSetMetadata(ResultSetMetadata)
         */
        default Builder resultSetMetadata(Consumer<ResultSetMetadata.Builder> resultSetMetadata) {
            return resultSetMetadata(ResultSetMetadata.builder().applyMutation(resultSetMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Row> rows = DefaultSdkAutoConstructList.getInstance();

        private ResultSetMetadata resultSetMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSet model) {
            rows(model.rows);
            resultSetMetadata(model.resultSetMetadata);
        }

        public final List<Row.Builder> getRows() {
            List<Row.Builder> result = RowListCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowListCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row... rows) {
            rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<Row.Builder>... rows) {
            rows(Stream.of(rows).map(c -> Row.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResultSetMetadata.Builder getResultSetMetadata() {
            return resultSetMetadata != null ? resultSetMetadata.toBuilder() : null;
        }

        public final void setResultSetMetadata(ResultSetMetadata.BuilderImpl resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata != null ? resultSetMetadata.build() : null;
        }

        @Override
        public final Builder resultSetMetadata(ResultSetMetadata resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata;
            return this;
        }

        @Override
        public ResultSet build() {
            return new ResultSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
