/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The query execution timeline, statistics on input and output rows and bytes, and the different query stages that form
 * the query execution plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryRuntimeStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryRuntimeStatistics.Builder, QueryRuntimeStatistics> {
    private static final SdkField<QueryRuntimeStatisticsTimeline> TIMELINE_FIELD = SdkField
            .<QueryRuntimeStatisticsTimeline> builder(MarshallingType.SDK_POJO).memberName("Timeline")
            .getter(getter(QueryRuntimeStatistics::timeline)).setter(setter(Builder::timeline))
            .constructor(QueryRuntimeStatisticsTimeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()).build();

    private static final SdkField<QueryRuntimeStatisticsRows> ROWS_FIELD = SdkField
            .<QueryRuntimeStatisticsRows> builder(MarshallingType.SDK_POJO).memberName("Rows")
            .getter(getter(QueryRuntimeStatistics::rows)).setter(setter(Builder::rows))
            .constructor(QueryRuntimeStatisticsRows::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build()).build();

    private static final SdkField<QueryStage> OUTPUT_STAGE_FIELD = SdkField.<QueryStage> builder(MarshallingType.SDK_POJO)
            .memberName("OutputStage").getter(getter(QueryRuntimeStatistics::outputStage)).setter(setter(Builder::outputStage))
            .constructor(QueryStage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputStage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMELINE_FIELD, ROWS_FIELD,
            OUTPUT_STAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final QueryRuntimeStatisticsTimeline timeline;

    private final QueryRuntimeStatisticsRows rows;

    private final QueryStage outputStage;

    private QueryRuntimeStatistics(BuilderImpl builder) {
        this.timeline = builder.timeline;
        this.rows = builder.rows;
        this.outputStage = builder.outputStage;
    }

    /**
     * Returns the value of the Timeline property for this object.
     * 
     * @return The value of the Timeline property for this object.
     */
    public final QueryRuntimeStatisticsTimeline timeline() {
        return timeline;
    }

    /**
     * Returns the value of the Rows property for this object.
     * 
     * @return The value of the Rows property for this object.
     */
    public final QueryRuntimeStatisticsRows rows() {
        return rows;
    }

    /**
     * <p>
     * Stage statistics such as input and output rows and bytes, execution time, and stage state. This information also
     * includes substages and the query stage plan.
     * </p>
     * 
     * @return Stage statistics such as input and output rows and bytes, execution time, and stage state. This
     *         information also includes substages and the query stage plan.
     */
    public final QueryStage outputStage() {
        return outputStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeline());
        hashCode = 31 * hashCode + Objects.hashCode(rows());
        hashCode = 31 * hashCode + Objects.hashCode(outputStage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRuntimeStatistics)) {
            return false;
        }
        QueryRuntimeStatistics other = (QueryRuntimeStatistics) obj;
        return Objects.equals(timeline(), other.timeline()) && Objects.equals(rows(), other.rows())
                && Objects.equals(outputStage(), other.outputStage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryRuntimeStatistics").add("Timeline", timeline()).add("Rows", rows())
                .add("OutputStage", outputStage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timeline":
            return Optional.ofNullable(clazz.cast(timeline()));
        case "Rows":
            return Optional.ofNullable(clazz.cast(rows()));
        case "OutputStage":
            return Optional.ofNullable(clazz.cast(outputStage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryRuntimeStatistics, T> g) {
        return obj -> g.apply((QueryRuntimeStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryRuntimeStatistics> {
        /**
         * Sets the value of the Timeline property for this object.
         *
         * @param timeline
         *        The new value for the Timeline property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeline(QueryRuntimeStatisticsTimeline timeline);

        /**
         * Sets the value of the Timeline property for this object.
         *
         * This is a convenience method that creates an instance of the {@link QueryRuntimeStatisticsTimeline.Builder}
         * avoiding the need to create one manually via {@link QueryRuntimeStatisticsTimeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryRuntimeStatisticsTimeline.Builder#build()} is called
         * immediately and its result is passed to {@link #timeline(QueryRuntimeStatisticsTimeline)}.
         * 
         * @param timeline
         *        a consumer that will call methods on {@link QueryRuntimeStatisticsTimeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeline(QueryRuntimeStatisticsTimeline)
         */
        default Builder timeline(Consumer<QueryRuntimeStatisticsTimeline.Builder> timeline) {
            return timeline(QueryRuntimeStatisticsTimeline.builder().applyMutation(timeline).build());
        }

        /**
         * Sets the value of the Rows property for this object.
         *
         * @param rows
         *        The new value for the Rows property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(QueryRuntimeStatisticsRows rows);

        /**
         * Sets the value of the Rows property for this object.
         *
         * This is a convenience method that creates an instance of the {@link QueryRuntimeStatisticsRows.Builder}
         * avoiding the need to create one manually via {@link QueryRuntimeStatisticsRows#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryRuntimeStatisticsRows.Builder#build()} is called immediately
         * and its result is passed to {@link #rows(QueryRuntimeStatisticsRows)}.
         * 
         * @param rows
         *        a consumer that will call methods on {@link QueryRuntimeStatisticsRows.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(QueryRuntimeStatisticsRows)
         */
        default Builder rows(Consumer<QueryRuntimeStatisticsRows.Builder> rows) {
            return rows(QueryRuntimeStatisticsRows.builder().applyMutation(rows).build());
        }

        /**
         * <p>
         * Stage statistics such as input and output rows and bytes, execution time, and stage state. This information
         * also includes substages and the query stage plan.
         * </p>
         * 
         * @param outputStage
         *        Stage statistics such as input and output rows and bytes, execution time, and stage state. This
         *        information also includes substages and the query stage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputStage(QueryStage outputStage);

        /**
         * <p>
         * Stage statistics such as input and output rows and bytes, execution time, and stage state. This information
         * also includes substages and the query stage plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryStage.Builder} avoiding the need to
         * create one manually via {@link QueryStage#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryStage.Builder#build()} is called immediately and its result
         * is passed to {@link #outputStage(QueryStage)}.
         * 
         * @param outputStage
         *        a consumer that will call methods on {@link QueryStage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputStage(QueryStage)
         */
        default Builder outputStage(Consumer<QueryStage.Builder> outputStage) {
            return outputStage(QueryStage.builder().applyMutation(outputStage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QueryRuntimeStatisticsTimeline timeline;

        private QueryRuntimeStatisticsRows rows;

        private QueryStage outputStage;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRuntimeStatistics model) {
            timeline(model.timeline);
            rows(model.rows);
            outputStage(model.outputStage);
        }

        public final QueryRuntimeStatisticsTimeline.Builder getTimeline() {
            return timeline != null ? timeline.toBuilder() : null;
        }

        public final void setTimeline(QueryRuntimeStatisticsTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        public final Builder timeline(QueryRuntimeStatisticsTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final QueryRuntimeStatisticsRows.Builder getRows() {
            return rows != null ? rows.toBuilder() : null;
        }

        public final void setRows(QueryRuntimeStatisticsRows.BuilderImpl rows) {
            this.rows = rows != null ? rows.build() : null;
        }

        @Override
        public final Builder rows(QueryRuntimeStatisticsRows rows) {
            this.rows = rows;
            return this;
        }

        public final QueryStage.Builder getOutputStage() {
            return outputStage != null ? outputStage.toBuilder() : null;
        }

        public final void setOutputStage(QueryStage.BuilderImpl outputStage) {
            this.outputStage = outputStage != null ? outputStage.build() : null;
        }

        @Override
        public final Builder outputStage(QueryStage outputStage) {
            this.outputStage = outputStage;
            return this;
        }

        @Override
        public QueryRuntimeStatistics build() {
            return new QueryRuntimeStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
