/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stage plan information such as name, identifier, sub plans, and remote sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryStagePlanNode implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryStagePlanNode.Builder, QueryStagePlanNode> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(QueryStagePlanNode::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(QueryStagePlanNode::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<List<QueryStagePlanNode>> CHILDREN_FIELD = SdkField
            .<List<QueryStagePlanNode>> builder(MarshallingType.LIST)
            .memberName("Children")
            .getter(getter(QueryStagePlanNode::children))
            .setter(setter(Builder::children))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Children").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryStagePlanNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryStagePlanNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOTE_SOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoteSources")
            .getter(getter(QueryStagePlanNode::remoteSources))
            .setter(setter(Builder::remoteSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IDENTIFIER_FIELD,
            CHILDREN_FIELD, REMOTE_SOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String identifier;

    private final List<QueryStagePlanNode> children;

    private final List<String> remoteSources;

    private QueryStagePlanNode(BuilderImpl builder) {
        this.name = builder.name;
        this.identifier = builder.identifier;
        this.children = builder.children;
        this.remoteSources = builder.remoteSources;
    }

    /**
     * <p>
     * Name of the query stage plan that describes the operation this stage is performing as part of query execution.
     * </p>
     * 
     * @return Name of the query stage plan that describes the operation this stage is performing as part of query
     *         execution.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Information about the operation this query stage plan node is performing.
     * </p>
     * 
     * @return Information about the operation this query stage plan node is performing.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Children property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChildren() {
        return children != null && !(children instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Stage plan information such as name, identifier, sub plans, and remote sources of child plan nodes/
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChildren} method.
     * </p>
     * 
     * @return Stage plan information such as name, identifier, sub plans, and remote sources of child plan nodes/
     */
    public final List<QueryStagePlanNode> children() {
        return children;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoteSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoteSources() {
        return remoteSources != null && !(remoteSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Source plan node IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoteSources} method.
     * </p>
     * 
     * @return Source plan node IDs.
     */
    public final List<String> remoteSources() {
        return remoteSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasChildren() ? children() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoteSources() ? remoteSources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStagePlanNode)) {
            return false;
        }
        QueryStagePlanNode other = (QueryStagePlanNode) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(identifier(), other.identifier())
                && hasChildren() == other.hasChildren() && Objects.equals(children(), other.children())
                && hasRemoteSources() == other.hasRemoteSources() && Objects.equals(remoteSources(), other.remoteSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryStagePlanNode").add("Name", name()).add("Identifier", identifier())
                .add("Children", hasChildren() ? children() : null)
                .add("RemoteSources", hasRemoteSources() ? remoteSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Children":
            return Optional.ofNullable(clazz.cast(children()));
        case "RemoteSources":
            return Optional.ofNullable(clazz.cast(remoteSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryStagePlanNode, T> g) {
        return obj -> g.apply((QueryStagePlanNode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryStagePlanNode> {
        /**
         * <p>
         * Name of the query stage plan that describes the operation this stage is performing as part of query
         * execution.
         * </p>
         * 
         * @param name
         *        Name of the query stage plan that describes the operation this stage is performing as part of query
         *        execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the operation this query stage plan node is performing.
         * </p>
         * 
         * @param identifier
         *        Information about the operation this query stage plan node is performing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Stage plan information such as name, identifier, sub plans, and remote sources of child plan nodes/
         * </p>
         * 
         * @param children
         *        Stage plan information such as name, identifier, sub plans, and remote sources of child plan nodes/
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(Collection<QueryStagePlanNode> children);

        /**
         * <p>
         * Stage plan information such as name, identifier, sub plans, and remote sources of child plan nodes/
         * </p>
         * 
         * @param children
         *        Stage plan information such as name, identifier, sub plans, and remote sources of child plan nodes/
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(QueryStagePlanNode... children);

        /**
         * <p>
         * Stage plan information such as name, identifier, sub plans, and remote sources of child plan nodes/
         * </p>
         * This is a convenience method that creates an instance of the {@link List<QueryStagePlanNode>.Builder}
         * avoiding the need to create one manually via {@link List<QueryStagePlanNode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QueryStagePlanNode>.Builder#build()} is called immediately
         * and its result is passed to {@link #children(List<QueryStagePlanNode>)}.
         * 
         * @param children
         *        a consumer that will call methods on {@link List<QueryStagePlanNode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #children(List<QueryStagePlanNode>)
         */
        Builder children(Consumer<Builder>... children);

        /**
         * <p>
         * Source plan node IDs.
         * </p>
         * 
         * @param remoteSources
         *        Source plan node IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteSources(Collection<String> remoteSources);

        /**
         * <p>
         * Source plan node IDs.
         * </p>
         * 
         * @param remoteSources
         *        Source plan node IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteSources(String... remoteSources);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String identifier;

        private List<QueryStagePlanNode> children = DefaultSdkAutoConstructList.getInstance();

        private List<String> remoteSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStagePlanNode model) {
            name(model.name);
            identifier(model.identifier);
            children(model.children);
            remoteSources(model.remoteSources);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<Builder> getChildren() {
            List<Builder> result = QueryStagePlanNodesCopier.copyToBuilder(this.children);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildren(Collection<BuilderImpl> children) {
            this.children = QueryStagePlanNodesCopier.copyFromBuilder(children);
        }

        @Override
        public final Builder children(Collection<QueryStagePlanNode> children) {
            this.children = QueryStagePlanNodesCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(QueryStagePlanNode... children) {
            children(Arrays.asList(children));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Consumer<Builder>... children) {
            children(Stream.of(children).map(c -> QueryStagePlanNode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemoteSources() {
            if (remoteSources instanceof SdkAutoConstructList) {
                return null;
            }
            return remoteSources;
        }

        public final void setRemoteSources(Collection<String> remoteSources) {
            this.remoteSources = StringListCopier.copy(remoteSources);
        }

        @Override
        public final Builder remoteSources(Collection<String> remoteSources) {
            this.remoteSources = StringListCopier.copy(remoteSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteSources(String... remoteSources) {
            remoteSources(Arrays.asList(remoteSources));
            return this;
        }

        @Override
        public QueryStagePlanNode build() {
            return new QueryStagePlanNode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
