/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkGroupRequest extends AthenaRequest implements
        ToCopyableBuilder<UpdateWorkGroupRequest.Builder, UpdateWorkGroupRequest> {
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(UpdateWorkGroupRequest::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateWorkGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<WorkGroupConfigurationUpdates> CONFIGURATION_UPDATES_FIELD = SdkField
            .<WorkGroupConfigurationUpdates> builder(MarshallingType.SDK_POJO).memberName("ConfigurationUpdates")
            .getter(getter(UpdateWorkGroupRequest::configurationUpdates)).setter(setter(Builder::configurationUpdates))
            .constructor(WorkGroupConfigurationUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationUpdates").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateWorkGroupRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_FIELD,
            DESCRIPTION_FIELD, CONFIGURATION_UPDATES_FIELD, STATE_FIELD));

    private final String workGroup;

    private final String description;

    private final WorkGroupConfigurationUpdates configurationUpdates;

    private final String state;

    private UpdateWorkGroupRequest(BuilderImpl builder) {
        super(builder);
        this.workGroup = builder.workGroup;
        this.description = builder.description;
        this.configurationUpdates = builder.configurationUpdates;
        this.state = builder.state;
    }

    /**
     * <p>
     * The specified workgroup that will be updated.
     * </p>
     * 
     * @return The specified workgroup that will be updated.
     */
    public final String workGroup() {
        return workGroup;
    }

    /**
     * <p>
     * The workgroup description.
     * </p>
     * 
     * @return The workgroup description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The workgroup configuration that will be updated for the given workgroup.
     * </p>
     * 
     * @return The workgroup configuration that will be updated for the given workgroup.
     */
    public final WorkGroupConfigurationUpdates configurationUpdates() {
        return configurationUpdates;
    }

    /**
     * <p>
     * The workgroup state that will be updated for the given workgroup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The workgroup state that will be updated for the given workgroup.
     * @see WorkGroupState
     */
    public final WorkGroupState state() {
        return WorkGroupState.fromValue(state);
    }

    /**
     * <p>
     * The workgroup state that will be updated for the given workgroup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The workgroup state that will be updated for the given workgroup.
     * @see WorkGroupState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(configurationUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkGroupRequest)) {
            return false;
        }
        UpdateWorkGroupRequest other = (UpdateWorkGroupRequest) obj;
        return Objects.equals(workGroup(), other.workGroup()) && Objects.equals(description(), other.description())
                && Objects.equals(configurationUpdates(), other.configurationUpdates())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkGroupRequest").add("WorkGroup", workGroup()).add("Description", description())
                .add("ConfigurationUpdates", configurationUpdates()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ConfigurationUpdates":
            return Optional.ofNullable(clazz.cast(configurationUpdates()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkGroupRequest, T> g) {
        return obj -> g.apply((UpdateWorkGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkGroupRequest> {
        /**
         * <p>
         * The specified workgroup that will be updated.
         * </p>
         * 
         * @param workGroup
         *        The specified workgroup that will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        /**
         * <p>
         * The workgroup description.
         * </p>
         * 
         * @param description
         *        The workgroup description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The workgroup configuration that will be updated for the given workgroup.
         * </p>
         * 
         * @param configurationUpdates
         *        The workgroup configuration that will be updated for the given workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationUpdates(WorkGroupConfigurationUpdates configurationUpdates);

        /**
         * <p>
         * The workgroup configuration that will be updated for the given workgroup.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkGroupConfigurationUpdates.Builder}
         * avoiding the need to create one manually via {@link WorkGroupConfigurationUpdates#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkGroupConfigurationUpdates.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationUpdates(WorkGroupConfigurationUpdates)}.
         * 
         * @param configurationUpdates
         *        a consumer that will call methods on {@link WorkGroupConfigurationUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationUpdates(WorkGroupConfigurationUpdates)
         */
        default Builder configurationUpdates(Consumer<WorkGroupConfigurationUpdates.Builder> configurationUpdates) {
            return configurationUpdates(WorkGroupConfigurationUpdates.builder().applyMutation(configurationUpdates).build());
        }

        /**
         * <p>
         * The workgroup state that will be updated for the given workgroup.
         * </p>
         * 
         * @param state
         *        The workgroup state that will be updated for the given workgroup.
         * @see WorkGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkGroupState
         */
        Builder state(String state);

        /**
         * <p>
         * The workgroup state that will be updated for the given workgroup.
         * </p>
         * 
         * @param state
         *        The workgroup state that will be updated for the given workgroup.
         * @see WorkGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkGroupState
         */
        Builder state(WorkGroupState state);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String workGroup;

        private String description;

        private WorkGroupConfigurationUpdates configurationUpdates;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkGroupRequest model) {
            super(model);
            workGroup(model.workGroup);
            description(model.description);
            configurationUpdates(model.configurationUpdates);
            state(model.state);
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final WorkGroupConfigurationUpdates.Builder getConfigurationUpdates() {
            return configurationUpdates != null ? configurationUpdates.toBuilder() : null;
        }

        public final void setConfigurationUpdates(WorkGroupConfigurationUpdates.BuilderImpl configurationUpdates) {
            this.configurationUpdates = configurationUpdates != null ? configurationUpdates.build() : null;
        }

        @Override
        public final Builder configurationUpdates(WorkGroupConfigurationUpdates configurationUpdates) {
            this.configurationUpdates = configurationUpdates;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkGroupRequest build() {
            return new UpdateWorkGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
