/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse;

public class ListCalculationExecutionsPublisher
implements SdkPublisher<ListCalculationExecutionsResponse> {
    private final AthenaAsyncClient client;
    private final ListCalculationExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCalculationExecutionsPublisher(AthenaAsyncClient client, ListCalculationExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCalculationExecutionsPublisher(AthenaAsyncClient client, ListCalculationExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCalculationExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCalculationExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCalculationExecutionsResponseFetcher
    implements AsyncPageFetcher<ListCalculationExecutionsResponse> {
        private ListCalculationExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCalculationExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCalculationExecutionsResponse> nextPage(ListCalculationExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListCalculationExecutionsPublisher.this.client.listCalculationExecutions(ListCalculationExecutionsPublisher.this.firstRequest);
            }
            return ListCalculationExecutionsPublisher.this.client.listCalculationExecutions((ListCalculationExecutionsRequest)((Object)ListCalculationExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

