/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCalculationExecutionCodeResponse extends AthenaResponse implements
        ToCopyableBuilder<GetCalculationExecutionCodeResponse.Builder, GetCalculationExecutionCodeResponse> {
    private static final SdkField<String> CODE_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeBlock").getter(getter(GetCalculationExecutionCodeResponse::codeBlock))
            .setter(setter(Builder::codeBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_BLOCK_FIELD));

    private final String codeBlock;

    private GetCalculationExecutionCodeResponse(BuilderImpl builder) {
        super(builder);
        this.codeBlock = builder.codeBlock;
    }

    /**
     * <p>
     * A pre-signed URL to the code that executed the calculation.
     * </p>
     * 
     * @return A pre-signed URL to the code that executed the calculation.
     */
    public final String codeBlock() {
        return codeBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCalculationExecutionCodeResponse)) {
            return false;
        }
        GetCalculationExecutionCodeResponse other = (GetCalculationExecutionCodeResponse) obj;
        return Objects.equals(codeBlock(), other.codeBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCalculationExecutionCodeResponse").add("CodeBlock", codeBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeBlock":
            return Optional.ofNullable(clazz.cast(codeBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCalculationExecutionCodeResponse, T> g) {
        return obj -> g.apply((GetCalculationExecutionCodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCalculationExecutionCodeResponse> {
        /**
         * <p>
         * A pre-signed URL to the code that executed the calculation.
         * </p>
         * 
         * @param codeBlock
         *        A pre-signed URL to the code that executed the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeBlock(String codeBlock);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private String codeBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCalculationExecutionCodeResponse model) {
            super(model);
            codeBlock(model.codeBlock);
        }

        public final String getCodeBlock() {
            return codeBlock;
        }

        public final void setCodeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
        }

        @Override
        public final Builder codeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
            return this;
        }

        @Override
        public GetCalculationExecutionCodeResponse build() {
            return new GetCalculationExecutionCodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
