/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a notebook session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionSummary implements SdkPojo, Serializable, ToCopyableBuilder<SessionSummary.Builder, SessionSummary> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(SessionSummary::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SessionSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<EngineVersion> ENGINE_VERSION_FIELD = SdkField
            .<EngineVersion> builder(MarshallingType.SDK_POJO).memberName("EngineVersion")
            .getter(getter(SessionSummary::engineVersion)).setter(setter(Builder::engineVersion))
            .constructor(EngineVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> NOTEBOOK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookVersion").getter(getter(SessionSummary::notebookVersion))
            .setter(setter(Builder::notebookVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookVersion").build()).build();

    private static final SdkField<SessionStatus> STATUS_FIELD = SdkField.<SessionStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(SessionSummary::status)).setter(setter(Builder::status))
            .constructor(SessionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            DESCRIPTION_FIELD, ENGINE_VERSION_FIELD, NOTEBOOK_VERSION_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sessionId;

    private final String description;

    private final EngineVersion engineVersion;

    private final String notebookVersion;

    private final SessionStatus status;

    private SessionSummary(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.description = builder.description;
        this.engineVersion = builder.engineVersion;
        this.notebookVersion = builder.notebookVersion;
        this.status = builder.status;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The session description.
     * </p>
     * 
     * @return The session description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The engine version used by the session (for example, <code>PySpark engine version 3</code>).
     * </p>
     * 
     * @return The engine version used by the session (for example, <code>PySpark engine version 3</code>).
     */
    public final EngineVersion engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The notebook version.
     * </p>
     * 
     * @return The notebook version.
     */
    public final String notebookVersion() {
        return notebookVersion;
    }

    /**
     * <p>
     * Contains information about the session status.
     * </p>
     * 
     * @return Contains information about the session status.
     */
    public final SessionStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(notebookVersion());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionSummary)) {
            return false;
        }
        SessionSummary other = (SessionSummary) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(description(), other.description())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(notebookVersion(), other.notebookVersion()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionSummary").add("SessionId", sessionId()).add("Description", description())
                .add("EngineVersion", engineVersion()).add("NotebookVersion", notebookVersion()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "NotebookVersion":
            return Optional.ofNullable(clazz.cast(notebookVersion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionSummary, T> g) {
        return obj -> g.apply((SessionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionSummary> {
        /**
         * <p>
         * The session ID.
         * </p>
         * 
         * @param sessionId
         *        The session ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The session description.
         * </p>
         * 
         * @param description
         *        The session description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The engine version used by the session (for example, <code>PySpark engine version 3</code>).
         * </p>
         * 
         * @param engineVersion
         *        The engine version used by the session (for example, <code>PySpark engine version 3</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(EngineVersion engineVersion);

        /**
         * <p>
         * The engine version used by the session (for example, <code>PySpark engine version 3</code>).
         * </p>
         * This is a convenience method that creates an instance of the {@link EngineVersion.Builder} avoiding the need
         * to create one manually via {@link EngineVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngineVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #engineVersion(EngineVersion)}.
         * 
         * @param engineVersion
         *        a consumer that will call methods on {@link EngineVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineVersion(EngineVersion)
         */
        default Builder engineVersion(Consumer<EngineVersion.Builder> engineVersion) {
            return engineVersion(EngineVersion.builder().applyMutation(engineVersion).build());
        }

        /**
         * <p>
         * The notebook version.
         * </p>
         * 
         * @param notebookVersion
         *        The notebook version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookVersion(String notebookVersion);

        /**
         * <p>
         * Contains information about the session status.
         * </p>
         * 
         * @param status
         *        Contains information about the session status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(SessionStatus status);

        /**
         * <p>
         * Contains information about the session status.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionStatus.Builder} avoiding the need
         * to create one manually via {@link SessionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(SessionStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link SessionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(SessionStatus)
         */
        default Builder status(Consumer<SessionStatus.Builder> status) {
            return status(SessionStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sessionId;

        private String description;

        private EngineVersion engineVersion;

        private String notebookVersion;

        private SessionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionSummary model) {
            sessionId(model.sessionId);
            description(model.description);
            engineVersion(model.engineVersion);
            notebookVersion(model.notebookVersion);
            status(model.status);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EngineVersion.Builder getEngineVersion() {
            return engineVersion != null ? engineVersion.toBuilder() : null;
        }

        public final void setEngineVersion(EngineVersion.BuilderImpl engineVersion) {
            this.engineVersion = engineVersion != null ? engineVersion.build() : null;
        }

        @Override
        public final Builder engineVersion(EngineVersion engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getNotebookVersion() {
            return notebookVersion;
        }

        public final void setNotebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
        }

        @Override
        public final Builder notebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
            return this;
        }

        public final SessionStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(SessionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public SessionSummary build() {
            return new SessionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
