/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse;

public class ListCapacityReservationsPublisher
implements SdkPublisher<ListCapacityReservationsResponse> {
    private final AthenaAsyncClient client;
    private final ListCapacityReservationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCapacityReservationsPublisher(AthenaAsyncClient client, ListCapacityReservationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCapacityReservationsPublisher(AthenaAsyncClient client, ListCapacityReservationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCapacityReservationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCapacityReservationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCapacityReservationsResponseFetcher
    implements AsyncPageFetcher<ListCapacityReservationsResponse> {
        private ListCapacityReservationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCapacityReservationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCapacityReservationsResponse> nextPage(ListCapacityReservationsResponse previousPage) {
            if (previousPage == null) {
                return ListCapacityReservationsPublisher.this.client.listCapacityReservations(ListCapacityReservationsPublisher.this.firstRequest);
            }
            return ListCapacityReservationsPublisher.this.client.listCapacityReservations((ListCapacityReservationsRequest)((Object)ListCapacityReservationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

