/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSessionRequest extends AthenaRequest implements
        ToCopyableBuilder<StartSessionRequest.Builder, StartSessionRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartSessionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(StartSessionRequest::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final SdkField<EngineConfiguration> ENGINE_CONFIGURATION_FIELD = SdkField
            .<EngineConfiguration> builder(MarshallingType.SDK_POJO).memberName("EngineConfiguration")
            .getter(getter(StartSessionRequest::engineConfiguration)).setter(setter(Builder::engineConfiguration))
            .constructor(EngineConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineConfiguration").build())
            .build();

    private static final SdkField<String> NOTEBOOK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookVersion").getter(getter(StartSessionRequest::notebookVersion))
            .setter(setter(Builder::notebookVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookVersion").build()).build();

    private static final SdkField<Integer> SESSION_IDLE_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionIdleTimeoutInMinutes")
            .getter(getter(StartSessionRequest::sessionIdleTimeoutInMinutes))
            .setter(setter(Builder::sessionIdleTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionIdleTimeoutInMinutes")
                    .build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(StartSessionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            WORK_GROUP_FIELD, ENGINE_CONFIGURATION_FIELD, NOTEBOOK_VERSION_FIELD, SESSION_IDLE_TIMEOUT_IN_MINUTES_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final String description;

    private final String workGroup;

    private final EngineConfiguration engineConfiguration;

    private final String notebookVersion;

    private final Integer sessionIdleTimeoutInMinutes;

    private final String clientRequestToken;

    private StartSessionRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.workGroup = builder.workGroup;
        this.engineConfiguration = builder.engineConfiguration;
        this.notebookVersion = builder.notebookVersion;
        this.sessionIdleTimeoutInMinutes = builder.sessionIdleTimeoutInMinutes;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The session description.
     * </p>
     * 
     * @return The session description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The workgroup to which the session belongs.
     * </p>
     * 
     * @return The workgroup to which the session belongs.
     */
    public final String workGroup() {
        return workGroup;
    }

    /**
     * <p>
     * Contains engine data processing unit (DPU) configuration settings and parameter mappings.
     * </p>
     * 
     * @return Contains engine data processing unit (DPU) configuration settings and parameter mappings.
     */
    public final EngineConfiguration engineConfiguration() {
        return engineConfiguration;
    }

    /**
     * <p>
     * The notebook version. This value is supplied automatically for notebook sessions in the Athena console and is not
     * required for programmatic session access. The only valid notebook version is
     * <code>Athena notebook version 1</code>. If you specify a value for <code>NotebookVersion</code>, you must also
     * specify a value for <code>NotebookId</code>. See <a>EngineConfiguration$AdditionalConfigs</a>.
     * </p>
     * 
     * @return The notebook version. This value is supplied automatically for notebook sessions in the Athena console
     *         and is not required for programmatic session access. The only valid notebook version is
     *         <code>Athena notebook version 1</code>. If you specify a value for <code>NotebookVersion</code>, you must
     *         also specify a value for <code>NotebookId</code>. See <a>EngineConfiguration$AdditionalConfigs</a>.
     */
    public final String notebookVersion() {
        return notebookVersion;
    }

    /**
     * <p>
     * The idle timeout in minutes for the session.
     * </p>
     * 
     * @return The idle timeout in minutes for the session.
     */
    public final Integer sessionIdleTimeoutInMinutes() {
        return sessionIdleTimeoutInMinutes;
    }

    /**
     * <p>
     * A unique case-sensitive string used to ensure the request to create the session is idempotent (executes only
     * once). If another <code>StartSessionRequest</code> is received, the same response is returned and another session
     * is not created. If a parameter has changed, an error is returned.
     * </p>
     * <important>
     * <p>
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK
     * for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web
     * Services CLI, you must provide this token or the action will fail.
     * </p>
     * </important>
     * 
     * @return A unique case-sensitive string used to ensure the request to create the session is idempotent (executes
     *         only once). If another <code>StartSessionRequest</code> is received, the same response is returned and
     *         another session is not created. If a parameter has changed, an error is returned.</p> <important>
     *         <p>
     *         This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web
     *         Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services
     *         SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
     *         </p>
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(engineConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(notebookVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sessionIdleTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSessionRequest)) {
            return false;
        }
        StartSessionRequest other = (StartSessionRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(workGroup(), other.workGroup())
                && Objects.equals(engineConfiguration(), other.engineConfiguration())
                && Objects.equals(notebookVersion(), other.notebookVersion())
                && Objects.equals(sessionIdleTimeoutInMinutes(), other.sessionIdleTimeoutInMinutes())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSessionRequest").add("Description", description()).add("WorkGroup", workGroup())
                .add("EngineConfiguration", engineConfiguration()).add("NotebookVersion", notebookVersion())
                .add("SessionIdleTimeoutInMinutes", sessionIdleTimeoutInMinutes())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        case "EngineConfiguration":
            return Optional.ofNullable(clazz.cast(engineConfiguration()));
        case "NotebookVersion":
            return Optional.ofNullable(clazz.cast(notebookVersion()));
        case "SessionIdleTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(sessionIdleTimeoutInMinutes()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSessionRequest, T> g) {
        return obj -> g.apply((StartSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSessionRequest> {
        /**
         * <p>
         * The session description.
         * </p>
         * 
         * @param description
         *        The session description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The workgroup to which the session belongs.
         * </p>
         * 
         * @param workGroup
         *        The workgroup to which the session belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        /**
         * <p>
         * Contains engine data processing unit (DPU) configuration settings and parameter mappings.
         * </p>
         * 
         * @param engineConfiguration
         *        Contains engine data processing unit (DPU) configuration settings and parameter mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineConfiguration(EngineConfiguration engineConfiguration);

        /**
         * <p>
         * Contains engine data processing unit (DPU) configuration settings and parameter mappings.
         * </p>
         * This is a convenience method that creates an instance of the {@link EngineConfiguration.Builder} avoiding the
         * need to create one manually via {@link EngineConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngineConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #engineConfiguration(EngineConfiguration)}.
         * 
         * @param engineConfiguration
         *        a consumer that will call methods on {@link EngineConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineConfiguration(EngineConfiguration)
         */
        default Builder engineConfiguration(Consumer<EngineConfiguration.Builder> engineConfiguration) {
            return engineConfiguration(EngineConfiguration.builder().applyMutation(engineConfiguration).build());
        }

        /**
         * <p>
         * The notebook version. This value is supplied automatically for notebook sessions in the Athena console and is
         * not required for programmatic session access. The only valid notebook version is
         * <code>Athena notebook version 1</code>. If you specify a value for <code>NotebookVersion</code>, you must
         * also specify a value for <code>NotebookId</code>. See <a>EngineConfiguration$AdditionalConfigs</a>.
         * </p>
         * 
         * @param notebookVersion
         *        The notebook version. This value is supplied automatically for notebook sessions in the Athena console
         *        and is not required for programmatic session access. The only valid notebook version is
         *        <code>Athena notebook version 1</code>. If you specify a value for <code>NotebookVersion</code>, you
         *        must also specify a value for <code>NotebookId</code>. See
         *        <a>EngineConfiguration$AdditionalConfigs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookVersion(String notebookVersion);

        /**
         * <p>
         * The idle timeout in minutes for the session.
         * </p>
         * 
         * @param sessionIdleTimeoutInMinutes
         *        The idle timeout in minutes for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionIdleTimeoutInMinutes(Integer sessionIdleTimeoutInMinutes);

        /**
         * <p>
         * A unique case-sensitive string used to ensure the request to create the session is idempotent (executes only
         * once). If another <code>StartSessionRequest</code> is received, the same response is returned and another
         * session is not created. If a parameter has changed, an error is returned.
         * </p>
         * <important>
         * <p>
         * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services
         * SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the
         * Amazon Web Services CLI, you must provide this token or the action will fail.
         * </p>
         * </important>
         * 
         * @param clientRequestToken
         *        A unique case-sensitive string used to ensure the request to create the session is idempotent
         *        (executes only once). If another <code>StartSessionRequest</code> is received, the same response is
         *        returned and another session is not created. If a parameter has changed, an error is returned.</p>
         *        <important>
         *        <p>
         *        This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web
         *        Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services
         *        SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String description;

        private String workGroup;

        private EngineConfiguration engineConfiguration;

        private String notebookVersion;

        private Integer sessionIdleTimeoutInMinutes;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSessionRequest model) {
            super(model);
            description(model.description);
            workGroup(model.workGroup);
            engineConfiguration(model.engineConfiguration);
            notebookVersion(model.notebookVersion);
            sessionIdleTimeoutInMinutes(model.sessionIdleTimeoutInMinutes);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final EngineConfiguration.Builder getEngineConfiguration() {
            return engineConfiguration != null ? engineConfiguration.toBuilder() : null;
        }

        public final void setEngineConfiguration(EngineConfiguration.BuilderImpl engineConfiguration) {
            this.engineConfiguration = engineConfiguration != null ? engineConfiguration.build() : null;
        }

        @Override
        public final Builder engineConfiguration(EngineConfiguration engineConfiguration) {
            this.engineConfiguration = engineConfiguration;
            return this;
        }

        public final String getNotebookVersion() {
            return notebookVersion;
        }

        public final void setNotebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
        }

        @Override
        public final Builder notebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
            return this;
        }

        public final Integer getSessionIdleTimeoutInMinutes() {
            return sessionIdleTimeoutInMinutes;
        }

        public final void setSessionIdleTimeoutInMinutes(Integer sessionIdleTimeoutInMinutes) {
            this.sessionIdleTimeoutInMinutes = sessionIdleTimeoutInMinutes;
        }

        @Override
        public final Builder sessionIdleTimeoutInMinutes(Integer sessionIdleTimeoutInMinutes) {
            this.sessionIdleTimeoutInMinutes = sessionIdleTimeoutInMinutes;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSessionRequest build() {
            return new StartSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
