/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.athena.internal.AthenaServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.athena.model.AthenaException;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.CancelCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.CreateCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.CreateNotebookRequest;
import software.amazon.awssdk.services.athena.model.CreateNotebookResponse;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.DeleteCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.DeleteNotebookRequest;
import software.amazon.awssdk.services.athena.model.DeleteNotebookResponse;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ExportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ExportNotebookResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest;
import software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationResponse;
import software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.GetCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.GetDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.GetDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.GetDatabaseRequest;
import software.amazon.awssdk.services.athena.model.GetDatabaseResponse;
import software.amazon.awssdk.services.athena.model.GetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.GetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse;
import software.amazon.awssdk.services.athena.model.GetSessionRequest;
import software.amazon.awssdk.services.athena.model.GetSessionResponse;
import software.amazon.awssdk.services.athena.model.GetSessionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetSessionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.GetWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ImportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ImportNotebookResponse;
import software.amazon.awssdk.services.athena.model.InternalServerException;
import software.amazon.awssdk.services.athena.model.InvalidRequestException;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse;
import software.amazon.awssdk.services.athena.model.ListExecutorsRequest;
import software.amazon.awssdk.services.athena.model.ListExecutorsResponse;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse;
import software.amazon.awssdk.services.athena.model.MetadataException;
import software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest;
import software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationResponse;
import software.amazon.awssdk.services.athena.model.ResourceNotFoundException;
import software.amazon.awssdk.services.athena.model.SessionAlreadyExistsException;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartSessionRequest;
import software.amazon.awssdk.services.athena.model.StartSessionResponse;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.TagResourceRequest;
import software.amazon.awssdk.services.athena.model.TagResourceResponse;
import software.amazon.awssdk.services.athena.model.TerminateSessionRequest;
import software.amazon.awssdk.services.athena.model.TerminateSessionResponse;
import software.amazon.awssdk.services.athena.model.TooManyRequestsException;
import software.amazon.awssdk.services.athena.model.UntagResourceRequest;
import software.amazon.awssdk.services.athena.model.UntagResourceResponse;
import software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.UpdateCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookResponse;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupResponse;
import software.amazon.awssdk.services.athena.transform.BatchGetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetPreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CancelCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreatePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreatePresignedNotebookUrlRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeletePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ExportNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionCodeRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCapacityAssignmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDatabaseRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetPreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryRuntimeStatisticsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionStatusRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ImportNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListApplicationDpuSizesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListCalculationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListCapacityReservationsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDataCatalogsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDatabasesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListExecutorsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNamedQueriesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNotebookSessionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListPreparedStatementsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListQueryExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListSessionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListWorkGroupsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.PutCapacityAssignmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TerminateSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdatePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateWorkGroupRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link AthenaAsyncClient}.
 *
 * @see AthenaAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAthenaAsyncClient implements AthenaAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAthenaAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAthenaAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query
     * ID strings. Requires you to have access to the workgroup in which the queries were saved. Use
     * <a>ListNamedQueriesInput</a> to get the list of named query IDs in the specified workgroup. If information could
     * not be retrieved for a submitted query ID, information about the query ID submitted is listed under
     * <a>UnprocessedNamedQueryId</a>. Named queries differ from executed queries. Use
     * <a>BatchGetQueryExecutionInput</a> to get details about each unique query execution, and
     * <a>ListQueryExecutionsInput</a> to get a list of query execution IDs.
     * </p>
     *
     * @param batchGetNamedQueryRequest
     *        Contains an array of named query IDs.
     * @return A Java Future containing the result of the BatchGetNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.BatchGetNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetNamedQueryResponse> batchGetNamedQuery(BatchGetNamedQueryRequest batchGetNamedQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetNamedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetNamedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetNamedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetNamedQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetNamedQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetNamedQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetNamedQueryRequest, BatchGetNamedQueryResponse>()
                            .withOperationName("BatchGetNamedQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetNamedQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetNamedQueryRequest));
            CompletableFuture<BatchGetNamedQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of
     * prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared
     * statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in
     * <code>UnprocessedPreparedStatementNames</code>.
     * </p>
     *
     * @param batchGetPreparedStatementRequest
     * @return A Java Future containing the result of the BatchGetPreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.BatchGetPreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetPreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetPreparedStatementResponse> batchGetPreparedStatement(
            BatchGetPreparedStatementRequest batchGetPreparedStatementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetPreparedStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetPreparedStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetPreparedStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetPreparedStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetPreparedStatementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetPreparedStatementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetPreparedStatementRequest, BatchGetPreparedStatementResponse>()
                            .withOperationName("BatchGetPreparedStatement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetPreparedStatementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetPreparedStatementRequest));
            CompletableFuture<BatchGetPreparedStatementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an
     * array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To
     * get a list of query execution IDs, use <a>ListQueryExecutionsInput&#36WorkGroup</a>. Query executions differ from
     * named (saved) queries. Use <a>BatchGetNamedQueryInput</a> to get details about named queries.
     * </p>
     *
     * @param batchGetQueryExecutionRequest
     *        Contains an array of query execution IDs.
     * @return A Java Future containing the result of the BatchGetQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.BatchGetQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetQueryExecutionResponse> batchGetQueryExecution(
            BatchGetQueryExecutionRequest batchGetQueryExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetQueryExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetQueryExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetQueryExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetQueryExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetQueryExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetQueryExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetQueryExecutionRequest, BatchGetQueryExecutionResponse>()
                            .withOperationName("BatchGetQueryExecution").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetQueryExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetQueryExecutionRequest));
            CompletableFuture<BatchGetQueryExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the capacity reservation with the specified name. Cancelled reservations remain in your account and will
     * be deleted 45 days after cancellation. During the 45 days, you cannot re-purpose or reuse a reservation that has
     * been cancelled, but you can refer to its tags and view it for historical reference.
     * </p>
     *
     * @param cancelCapacityReservationRequest
     * @return A Java Future containing the result of the CancelCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CancelCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CancelCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelCapacityReservationResponse> cancelCapacityReservation(
            CancelCapacityReservationRequest cancelCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCapacityReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelCapacityReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelCapacityReservationRequest, CancelCapacityReservationResponse>()
                            .withOperationName("CancelCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelCapacityReservationRequest));
            CompletableFuture<CancelCapacityReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a capacity reservation with the specified name and number of requested data processing units.
     * </p>
     *
     * @param createCapacityReservationRequest
     * @return A Java Future containing the result of the CreateCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCapacityReservationResponse> createCapacityReservation(
            CreateCapacityReservationRequest createCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCapacityReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCapacityReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCapacityReservationRequest, CreateCapacityReservationResponse>()
                            .withOperationName("CreateCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCapacityReservationRequest));
            CompletableFuture<CreateCapacityReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all
     * users of the same Amazon Web Services account.
     * </p>
     *
     * @param createDataCatalogRequest
     * @return A Java Future containing the result of the CreateDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataCatalogResponse> createDataCatalog(CreateDataCatalogRequest createDataCatalogRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDataCatalogResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDataCatalogResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataCatalogRequest, CreateDataCatalogResponse>()
                            .withOperationName("CreateDataCatalog").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDataCatalogRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDataCatalogRequest));
            CompletableFuture<CreateDataCatalogResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
     * </p>
     *
     * @param createNamedQueryRequest
     * @return A Java Future containing the result of the CreateNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNamedQueryResponse> createNamedQuery(CreateNamedQueryRequest createNamedQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNamedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNamedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNamedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNamedQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNamedQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNamedQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNamedQueryRequest, CreateNamedQueryResponse>()
                            .withOperationName("CreateNamedQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNamedQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNamedQueryRequest));
            CompletableFuture<CreateNamedQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an empty <code>ipynb</code> file in the specified Apache Spark enabled workgroup. Throws an error if a
     * file in the workgroup with the same name already exists.
     * </p>
     *
     * @param createNotebookRequest
     * @return A Java Future containing the result of the CreateNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNotebookResponse> createNotebook(CreateNotebookRequest createNotebookRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNotebookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotebook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNotebookResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNotebookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNotebookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNotebookRequest, CreateNotebookResponse>()
                            .withOperationName("CreateNotebook").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNotebookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNotebookRequest));
            CompletableFuture<CreateNotebookResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a prepared statement for use with SQL queries in Athena.
     * </p>
     *
     * @param createPreparedStatementRequest
     * @return A Java Future containing the result of the CreatePreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreatePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreatePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePreparedStatementResponse> createPreparedStatement(
            CreatePreparedStatementRequest createPreparedStatementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPreparedStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPreparedStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePreparedStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePreparedStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePreparedStatementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePreparedStatementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePreparedStatementRequest, CreatePreparedStatementResponse>()
                            .withOperationName("CreatePreparedStatement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePreparedStatementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPreparedStatementRequest));
            CompletableFuture<CreatePreparedStatementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an authentication token and the URL at which the notebook can be accessed. During programmatic access,
     * <code>CreatePresignedNotebookUrl</code> must be called every 10 minutes to refresh the authentication token. For
     * information about granting programmatic access, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/setting-up.html#setting-up-grant-programmatic-access">Grant
     * programmatic access</a>.
     * </p>
     *
     * @param createPresignedNotebookUrlRequest
     * @return A Java Future containing the result of the CreatePresignedNotebookUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreatePresignedNotebookUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreatePresignedNotebookUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePresignedNotebookUrlResponse> createPresignedNotebookUrl(
            CreatePresignedNotebookUrlRequest createPresignedNotebookUrlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPresignedNotebookUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPresignedNotebookUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedNotebookUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePresignedNotebookUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePresignedNotebookUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePresignedNotebookUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePresignedNotebookUrlRequest, CreatePresignedNotebookUrlResponse>()
                            .withOperationName("CreatePresignedNotebookUrl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePresignedNotebookUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPresignedNotebookUrlRequest));
            CompletableFuture<CreatePresignedNotebookUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a workgroup with the specified name. A workgroup can be an Apache Spark enabled workgroup or an Athena
     * SQL workgroup.
     * </p>
     *
     * @param createWorkGroupRequest
     * @return A Java Future containing the result of the CreateWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkGroupResponse> createWorkGroup(CreateWorkGroupRequest createWorkGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWorkGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkGroupRequest, CreateWorkGroupResponse>()
                            .withOperationName("CreateWorkGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorkGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWorkGroupRequest));
            CompletableFuture<CreateWorkGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a cancelled capacity reservation. A reservation must be cancelled before it can be deleted. A deleted
     * reservation is immediately removed from your account and can no longer be referenced, including by its ARN. A
     * deleted reservation cannot be called by <code>GetCapacityReservation</code>, and deleted reservations do not
     * appear in the output of <code>ListCapacityReservations</code>.
     * </p>
     *
     * @param deleteCapacityReservationRequest
     * @return A Java Future containing the result of the DeleteCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCapacityReservationResponse> deleteCapacityReservation(
            DeleteCapacityReservationRequest deleteCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCapacityReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCapacityReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCapacityReservationRequest, DeleteCapacityReservationResponse>()
                            .withOperationName("DeleteCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCapacityReservationRequest));
            CompletableFuture<DeleteCapacityReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a data catalog.
     * </p>
     *
     * @param deleteDataCatalogRequest
     * @return A Java Future containing the result of the DeleteDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataCatalogResponse> deleteDataCatalog(DeleteDataCatalogRequest deleteDataCatalogRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDataCatalogResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDataCatalogResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataCatalogRequest, DeleteDataCatalogResponse>()
                            .withOperationName("DeleteDataCatalog").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDataCatalogRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDataCatalogRequest));
            CompletableFuture<DeleteDataCatalogResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the named query if you have access to the workgroup in which the query was saved.
     * </p>
     *
     * @param deleteNamedQueryRequest
     * @return A Java Future containing the result of the DeleteNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNamedQueryResponse> deleteNamedQuery(DeleteNamedQueryRequest deleteNamedQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNamedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNamedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNamedQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteNamedQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNamedQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNamedQueryRequest, DeleteNamedQueryResponse>()
                            .withOperationName("DeleteNamedQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNamedQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNamedQueryRequest));
            CompletableFuture<DeleteNamedQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified notebook.
     * </p>
     *
     * @param deleteNotebookRequest
     * @return A Java Future containing the result of the DeleteNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNotebookResponse> deleteNotebook(DeleteNotebookRequest deleteNotebookRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNotebookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotebook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNotebookResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteNotebookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNotebookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNotebookRequest, DeleteNotebookResponse>()
                            .withOperationName("DeleteNotebook").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNotebookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNotebookRequest));
            CompletableFuture<DeleteNotebookResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the prepared statement with the specified name from the specified workgroup.
     * </p>
     *
     * @param deletePreparedStatementRequest
     * @return A Java Future containing the result of the DeletePreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeletePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeletePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePreparedStatementResponse> deletePreparedStatement(
            DeletePreparedStatementRequest deletePreparedStatementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePreparedStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePreparedStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePreparedStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePreparedStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePreparedStatementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePreparedStatementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePreparedStatementRequest, DeletePreparedStatementResponse>()
                            .withOperationName("DeletePreparedStatement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePreparedStatementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePreparedStatementRequest));
            CompletableFuture<DeletePreparedStatementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
     * </p>
     *
     * @param deleteWorkGroupRequest
     * @return A Java Future containing the result of the DeleteWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkGroupResponse> deleteWorkGroup(DeleteWorkGroupRequest deleteWorkGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWorkGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkGroupRequest, DeleteWorkGroupResponse>()
                            .withOperationName("DeleteWorkGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorkGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWorkGroupRequest));
            CompletableFuture<DeleteWorkGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Exports the specified notebook and its metadata.
     * </p>
     *
     * @param exportNotebookRequest
     * @return A Java Future containing the result of the ExportNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ExportNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ExportNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ExportNotebookResponse> exportNotebook(ExportNotebookRequest exportNotebookRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportNotebookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportNotebook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ExportNotebookResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExportNotebookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExportNotebookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExportNotebookRequest, ExportNotebookResponse>()
                            .withOperationName("ExportNotebook").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ExportNotebookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(exportNotebookRequest));
            CompletableFuture<ExportNotebookResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a previously submitted calculation execution.
     * </p>
     *
     * @param getCalculationExecutionRequest
     * @return A Java Future containing the result of the GetCalculationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCalculationExecutionResponse> getCalculationExecution(
            GetCalculationExecutionRequest getCalculationExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCalculationExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCalculationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCalculationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCalculationExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCalculationExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCalculationExecutionRequest, GetCalculationExecutionResponse>()
                            .withOperationName("GetCalculationExecution").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCalculationExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCalculationExecutionRequest));
            CompletableFuture<GetCalculationExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the unencrypted code that was executed for the calculation.
     * </p>
     *
     * @param getCalculationExecutionCodeRequest
     * @return A Java Future containing the result of the GetCalculationExecutionCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCalculationExecutionCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecutionCode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCalculationExecutionCodeResponse> getCalculationExecutionCode(
            GetCalculationExecutionCodeRequest getCalculationExecutionCodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCalculationExecutionCodeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCalculationExecutionCodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecutionCode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCalculationExecutionCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCalculationExecutionCodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCalculationExecutionCodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCalculationExecutionCodeRequest, GetCalculationExecutionCodeResponse>()
                            .withOperationName("GetCalculationExecutionCode").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCalculationExecutionCodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCalculationExecutionCodeRequest));
            CompletableFuture<GetCalculationExecutionCodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status of a current calculation.
     * </p>
     *
     * @param getCalculationExecutionStatusRequest
     * @return A Java Future containing the result of the GetCalculationExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCalculationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCalculationExecutionStatusResponse> getCalculationExecutionStatus(
            GetCalculationExecutionStatusRequest getCalculationExecutionStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCalculationExecutionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCalculationExecutionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecutionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCalculationExecutionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCalculationExecutionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCalculationExecutionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCalculationExecutionStatusRequest, GetCalculationExecutionStatusResponse>()
                            .withOperationName("GetCalculationExecutionStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCalculationExecutionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCalculationExecutionStatusRequest));
            CompletableFuture<GetCalculationExecutionStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the capacity assignment configuration for a capacity reservation, if one exists.
     * </p>
     *
     * @param getCapacityAssignmentConfigurationRequest
     * @return A Java Future containing the result of the GetCapacityAssignmentConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCapacityAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCapacityAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCapacityAssignmentConfigurationResponse> getCapacityAssignmentConfiguration(
            GetCapacityAssignmentConfigurationRequest getCapacityAssignmentConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCapacityAssignmentConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCapacityAssignmentConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCapacityAssignmentConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCapacityAssignmentConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetCapacityAssignmentConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCapacityAssignmentConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCapacityAssignmentConfigurationRequest, GetCapacityAssignmentConfigurationResponse>()
                            .withOperationName("GetCapacityAssignmentConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCapacityAssignmentConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCapacityAssignmentConfigurationRequest));
            CompletableFuture<GetCapacityAssignmentConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the capacity reservation with the specified name.
     * </p>
     *
     * @param getCapacityReservationRequest
     * @return A Java Future containing the result of the GetCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCapacityReservationResponse> getCapacityReservation(
            GetCapacityReservationRequest getCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCapacityReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCapacityReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCapacityReservationRequest, GetCapacityReservationResponse>()
                            .withOperationName("GetCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCapacityReservationRequest));
            CompletableFuture<GetCapacityReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the specified data catalog.
     * </p>
     *
     * @param getDataCatalogRequest
     * @return A Java Future containing the result of the GetDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDataCatalogResponse> getDataCatalog(GetDataCatalogRequest getDataCatalogRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDataCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDataCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDataCatalogResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDataCatalogResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDataCatalogRequest, GetDataCatalogResponse>()
                            .withOperationName("GetDataCatalog").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDataCatalogRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDataCatalogRequest));
            CompletableFuture<GetDataCatalogResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a database object for the specified database and data catalog.
     * </p>
     *
     * @param getDatabaseRequest
     * @return A Java Future containing the result of the GetDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDatabaseResponse> getDatabase(GetDatabaseRequest getDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDatabaseRequest, GetDatabaseResponse>()
                            .withOperationName("GetDatabase").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDatabaseRequest));
            CompletableFuture<GetDatabaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a single query. Requires that you have access to the workgroup in which the query was
     * saved.
     * </p>
     *
     * @param getNamedQueryRequest
     * @return A Java Future containing the result of the GetNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetNamedQueryResponse> getNamedQuery(GetNamedQueryRequest getNamedQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNamedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNamedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetNamedQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetNamedQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetNamedQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetNamedQueryRequest, GetNamedQueryResponse>()
                            .withOperationName("GetNamedQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetNamedQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getNamedQueryRequest));
            CompletableFuture<GetNamedQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves notebook metadata for the specified notebook ID.
     * </p>
     *
     * @param getNotebookMetadataRequest
     * @return A Java Future containing the result of the GetNotebookMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetNotebookMetadataResponse> getNotebookMetadata(
            GetNotebookMetadataRequest getNotebookMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getNotebookMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNotebookMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNotebookMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetNotebookMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetNotebookMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetNotebookMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetNotebookMetadataRequest, GetNotebookMetadataResponse>()
                            .withOperationName("GetNotebookMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetNotebookMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getNotebookMetadataRequest));
            CompletableFuture<GetNotebookMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the prepared statement with the specified name from the specified workgroup.
     * </p>
     *
     * @param getPreparedStatementRequest
     * @return A Java Future containing the result of the GetPreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetPreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetPreparedStatement" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPreparedStatementResponse> getPreparedStatement(
            GetPreparedStatementRequest getPreparedStatementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPreparedStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPreparedStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPreparedStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPreparedStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPreparedStatementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPreparedStatementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPreparedStatementRequest, GetPreparedStatementResponse>()
                            .withOperationName("GetPreparedStatement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPreparedStatementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPreparedStatementRequest));
            CompletableFuture<GetPreparedStatementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a single execution of a query if you have access to the workgroup in which the query
     * ran. Each time a query executes, information about the query execution is saved with a unique ID.
     * </p>
     *
     * @param getQueryExecutionRequest
     * @return A Java Future containing the result of the GetQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecution" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetQueryExecutionResponse> getQueryExecution(GetQueryExecutionRequest getQueryExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueryExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueryExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetQueryExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetQueryExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetQueryExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetQueryExecutionRequest, GetQueryExecutionResponse>()
                            .withOperationName("GetQueryExecution").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetQueryExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getQueryExecutionRequest));
            CompletableFuture<GetQueryExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Streams the results of a single query execution specified by <code>QueryExecutionId</code> from the Athena query
     * results location in Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with query results, recent queries, and
     * output files</a> in the <i>Amazon Athena User Guide</i>. This request does not execute the query but returns
     * results. Use <a>StartQueryExecution</a> to run a query.
     * </p>
     * <p>
     * To stream query results successfully, the IAM principal with permission to call <code>GetQueryResults</code> also
     * must have permissions to the Amazon S3 <code>GetObject</code> action for the Athena query results location.
     * </p>
     * <important>
     * <p>
     * IAM principals with permission to the Amazon S3 <code>GetObject</code> action for the query results location are
     * able to retrieve query results from Amazon S3 even if permission to the <code>GetQueryResults</code> action is
     * denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are
     * denied.
     * </p>
     * </important>
     *
     * @param getQueryResultsRequest
     * @return A Java Future containing the result of the GetQueryResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueryResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueryResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetQueryResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetQueryResultsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetQueryResultsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetQueryResultsRequest, GetQueryResultsResponse>()
                            .withOperationName("GetQueryResults").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetQueryResultsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getQueryResultsRequest));
            CompletableFuture<GetQueryResultsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns query execution runtime statistics related to a single execution of a query if you have access to the
     * workgroup in which the query ran. Query execution runtime statistics are returned only when
     * <a>QueryExecutionStatus&#36State</a> is in a SUCCEEDED or FAILED state. Stage-level input and output row count
     * and data size statistics are not shown when a query has row-level filters defined in Lake Formation.
     * </p>
     *
     * @param getQueryRuntimeStatisticsRequest
     * @return A Java Future containing the result of the GetQueryRuntimeStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryRuntimeStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryRuntimeStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetQueryRuntimeStatisticsResponse> getQueryRuntimeStatistics(
            GetQueryRuntimeStatisticsRequest getQueryRuntimeStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueryRuntimeStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueryRuntimeStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryRuntimeStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetQueryRuntimeStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetQueryRuntimeStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetQueryRuntimeStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetQueryRuntimeStatisticsRequest, GetQueryRuntimeStatisticsResponse>()
                            .withOperationName("GetQueryRuntimeStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetQueryRuntimeStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getQueryRuntimeStatisticsRequest));
            CompletableFuture<GetQueryRuntimeStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the full details of a previously created session, including the session status and configuration.
     * </p>
     *
     * @param getSessionRequest
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSessionRequest, GetSessionResponse>().withOperationName("GetSession")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSessionRequest));
            CompletableFuture<GetSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the current status of a session.
     * </p>
     *
     * @param getSessionStatusRequest
     * @return A Java Future containing the result of the GetSessionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetSessionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetSessionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSessionStatusResponse> getSessionStatus(GetSessionStatusRequest getSessionStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSessionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSessionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSessionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSessionStatusRequest, GetSessionStatusResponse>()
                            .withOperationName("GetSessionStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSessionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSessionStatusRequest));
            CompletableFuture<GetSessionStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns table metadata for the specified catalog, database, and table.
     * </p>
     *
     * @param getTableMetadataRequest
     * @return A Java Future containing the result of the GetTableMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetTableMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetTableMetadataResponse> getTableMetadata(GetTableMetadataRequest getTableMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTableMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTableMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTableMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTableMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTableMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTableMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTableMetadataRequest, GetTableMetadataResponse>()
                            .withOperationName("GetTableMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTableMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTableMetadataRequest));
            CompletableFuture<GetTableMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the workgroup with the specified name.
     * </p>
     *
     * @param getWorkGroupRequest
     * @return A Java Future containing the result of the GetWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorkGroupResponse> getWorkGroup(GetWorkGroupRequest getWorkGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorkGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetWorkGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWorkGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorkGroupRequest, GetWorkGroupResponse>()
                            .withOperationName("GetWorkGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetWorkGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWorkGroupRequest));
            CompletableFuture<GetWorkGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports a single <code>ipynb</code> file to a Spark enabled workgroup. To import the notebook, the request must
     * specify a value for either <code>Payload</code> or <code>NoteBookS3LocationUri</code>. If neither is specified or
     * both are specified, an <code>InvalidRequestException</code> occurs. The maximum file size that can be imported is
     * 10 megabytes. If an <code>ipynb</code> file with the same name already exists in the workgroup, throws an error.
     * </p>
     *
     * @param importNotebookRequest
     * @return A Java Future containing the result of the ImportNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ImportNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ImportNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportNotebookResponse> importNotebook(ImportNotebookRequest importNotebookRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importNotebookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportNotebook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportNotebookResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ImportNotebookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportNotebookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportNotebookRequest, ImportNotebookResponse>()
                            .withOperationName("ImportNotebook").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ImportNotebookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(importNotebookRequest));
            CompletableFuture<ImportNotebookResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the supported DPU sizes for the supported application runtimes (for example,
     * <code>Athena notebook version 1</code>).
     * </p>
     *
     * @param listApplicationDpuSizesRequest
     * @return A Java Future containing the result of the ListApplicationDPUSizes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListApplicationDPUSizes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListApplicationDPUSizes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListApplicationDpuSizesResponse> listApplicationDPUSizes(
            ListApplicationDpuSizesRequest listApplicationDpuSizesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApplicationDpuSizesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApplicationDpuSizesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationDPUSizes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListApplicationDpuSizesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListApplicationDpuSizesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListApplicationDpuSizesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListApplicationDpuSizesRequest, ListApplicationDpuSizesResponse>()
                            .withOperationName("ListApplicationDPUSizes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListApplicationDpuSizesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listApplicationDpuSizesRequest));
            CompletableFuture<ListApplicationDpuSizesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the calculations that have been submitted to a session in descending order. Newer calculations are listed
     * first; older calculations are listed later.
     * </p>
     *
     * @param listCalculationExecutionsRequest
     * @return A Java Future containing the result of the ListCalculationExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListCalculationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCalculationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCalculationExecutionsResponse> listCalculationExecutions(
            ListCalculationExecutionsRequest listCalculationExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCalculationExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCalculationExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCalculationExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCalculationExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCalculationExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCalculationExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCalculationExecutionsRequest, ListCalculationExecutionsResponse>()
                            .withOperationName("ListCalculationExecutions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCalculationExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCalculationExecutionsRequest));
            CompletableFuture<ListCalculationExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the capacity reservations for the current account.
     * </p>
     *
     * @param listCapacityReservationsRequest
     * @return A Java Future containing the result of the ListCapacityReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCapacityReservationsResponse> listCapacityReservations(
            ListCapacityReservationsRequest listCapacityReservationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCapacityReservationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCapacityReservationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCapacityReservations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCapacityReservationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCapacityReservationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCapacityReservationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCapacityReservationsRequest, ListCapacityReservationsResponse>()
                            .withOperationName("ListCapacityReservations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCapacityReservationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCapacityReservationsRequest));
            CompletableFuture<ListCapacityReservationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the data catalogs in the current Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * In the Athena console, data catalogs are listed as "data sources" on the <b>Data sources</b> page under the
     * <b>Data source name</b> column.
     * </p>
     * </note>
     *
     * @param listDataCatalogsRequest
     * @return A Java Future containing the result of the ListDataCatalogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListDataCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDataCatalogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDataCatalogsResponse> listDataCatalogs(ListDataCatalogsRequest listDataCatalogsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDataCatalogsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataCatalogsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataCatalogs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDataCatalogsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDataCatalogsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDataCatalogsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDataCatalogsRequest, ListDataCatalogsResponse>()
                            .withOperationName("ListDataCatalogs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDataCatalogsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDataCatalogsRequest));
            CompletableFuture<ListDataCatalogsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the databases in the specified data catalog.
     * </p>
     *
     * @param listDatabasesRequest
     * @return A Java Future containing the result of the ListDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDatabasesResponse> listDatabases(ListDatabasesRequest listDatabasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDatabasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDatabasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatabases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDatabasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDatabasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDatabasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDatabasesRequest, ListDatabasesResponse>()
                            .withOperationName("ListDatabases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDatabasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDatabasesRequest));
            CompletableFuture<ListDatabasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of engine versions that are available to choose from, including the Auto option.
     * </p>
     *
     * @param listEngineVersionsRequest
     * @return A Java Future containing the result of the ListEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListEngineVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListEngineVersionsResponse> listEngineVersions(ListEngineVersionsRequest listEngineVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngineVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEngineVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngineVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEngineVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEngineVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEngineVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEngineVersionsRequest, ListEngineVersionsResponse>()
                            .withOperationName("ListEngineVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEngineVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEngineVersionsRequest));
            CompletableFuture<ListEngineVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists, in descending order, the executors that joined a session. Newer executors are listed first; older
     * executors are listed later. The result can be optionally filtered by state.
     * </p>
     *
     * @param listExecutorsRequest
     * @return A Java Future containing the result of the ListExecutors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListExecutors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListExecutors" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListExecutorsResponse> listExecutors(ListExecutorsRequest listExecutorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listExecutorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExecutorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExecutors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListExecutorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListExecutorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListExecutorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListExecutorsRequest, ListExecutorsResponse>()
                            .withOperationName("ListExecutors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListExecutorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listExecutorsRequest));
            CompletableFuture<ListExecutorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have
     * access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary
     * workgroup.
     * </p>
     *
     * @param listNamedQueriesRequest
     * @return A Java Future containing the result of the ListNamedQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNamedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListNamedQueriesResponse> listNamedQueries(ListNamedQueriesRequest listNamedQueriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNamedQueriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNamedQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNamedQueries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNamedQueriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListNamedQueriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNamedQueriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNamedQueriesRequest, ListNamedQueriesResponse>()
                            .withOperationName("ListNamedQueries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListNamedQueriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listNamedQueriesRequest));
            CompletableFuture<ListNamedQueriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays the notebook files for the specified workgroup in paginated format.
     * </p>
     *
     * @param listNotebookMetadataRequest
     * @return A Java Future containing the result of the ListNotebookMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListNotebookMetadataResponse> listNotebookMetadata(
            ListNotebookMetadataRequest listNotebookMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNotebookMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNotebookMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNotebookMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListNotebookMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNotebookMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNotebookMetadataRequest, ListNotebookMetadataResponse>()
                            .withOperationName("ListNotebookMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListNotebookMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listNotebookMetadataRequest));
            CompletableFuture<ListNotebookMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists, in descending order, the sessions that have been created in a notebook that are in an active state like
     * <code>CREATING</code>, <code>CREATED</code>, <code>IDLE</code> or <code>BUSY</code>. Newer sessions are listed
     * first; older sessions are listed later.
     * </p>
     *
     * @param listNotebookSessionsRequest
     * @return A Java Future containing the result of the ListNotebookSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNotebookSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookSessions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListNotebookSessionsResponse> listNotebookSessions(
            ListNotebookSessionsRequest listNotebookSessionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNotebookSessionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNotebookSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNotebookSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListNotebookSessionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNotebookSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNotebookSessionsRequest, ListNotebookSessionsResponse>()
                            .withOperationName("ListNotebookSessions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListNotebookSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listNotebookSessionsRequest));
            CompletableFuture<ListNotebookSessionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the prepared statements in the specified workgroup.
     * </p>
     *
     * @param listPreparedStatementsRequest
     * @return A Java Future containing the result of the ListPreparedStatements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListPreparedStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListPreparedStatements" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPreparedStatementsResponse> listPreparedStatements(
            ListPreparedStatementsRequest listPreparedStatementsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPreparedStatementsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPreparedStatementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPreparedStatements");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPreparedStatementsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPreparedStatementsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPreparedStatementsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPreparedStatementsRequest, ListPreparedStatementsResponse>()
                            .withOperationName("ListPreparedStatements").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPreparedStatementsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPreparedStatementsRequest));
            CompletableFuture<ListPreparedStatementsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of available query execution IDs for the queries in the specified workgroup. Athena keeps a query
     * history for 45 days. If a workgroup is not specified, returns a list of query execution IDs for the primary
     * workgroup. Requires you to have access to the workgroup in which the queries ran.
     * </p>
     *
     * @param listQueryExecutionsRequest
     * @return A Java Future containing the result of the ListQueryExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListQueryExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListQueryExecutionsResponse> listQueryExecutions(
            ListQueryExecutionsRequest listQueryExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueryExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueryExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueryExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListQueryExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListQueryExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListQueryExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListQueryExecutionsRequest, ListQueryExecutionsResponse>()
                            .withOperationName("ListQueryExecutions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListQueryExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listQueryExecutionsRequest));
            CompletableFuture<ListQueryExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the sessions in a workgroup that are in an active state like <code>CREATING</code>, <code>CREATED</code>,
     * <code>IDLE</code>, or <code>BUSY</code>. Newer sessions are listed first; older sessions are listed later.
     * </p>
     *
     * @param listSessionsRequest
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSessionsResponse> listSessions(ListSessionsRequest listSessionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSessionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSessionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSessionsRequest, ListSessionsResponse>()
                            .withOperationName("ListSessions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSessionsRequest));
            CompletableFuture<ListSessionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the metadata for the tables in the specified data catalog database.
     * </p>
     *
     * @param listTableMetadataRequest
     * @return A Java Future containing the result of the ListTableMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTableMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTableMetadataResponse> listTableMetadata(ListTableMetadataRequest listTableMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTableMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTableMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTableMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTableMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTableMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTableMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTableMetadataRequest, ListTableMetadataResponse>()
                            .withOperationName("ListTableMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTableMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTableMetadataRequest));
            CompletableFuture<ListTableMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags associated with an Athena resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists available workgroups for the account.
     * </p>
     *
     * @param listWorkGroupsRequest
     * @return A Java Future containing the result of the ListWorkGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListWorkGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListWorkGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkGroupsResponse> listWorkGroups(ListWorkGroupsRequest listWorkGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorkGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWorkGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkGroupsRequest, ListWorkGroupsResponse>()
                            .withOperationName("ListWorkGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorkGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorkGroupsRequest));
            CompletableFuture<ListWorkGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Puts a new capacity assignment configuration for a specified capacity reservation. If a capacity assignment
     * configuration already exists for the capacity reservation, replaces the existing capacity assignment
     * configuration.
     * </p>
     *
     * @param putCapacityAssignmentConfigurationRequest
     * @return A Java Future containing the result of the PutCapacityAssignmentConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.PutCapacityAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/PutCapacityAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutCapacityAssignmentConfigurationResponse> putCapacityAssignmentConfiguration(
            PutCapacityAssignmentConfigurationRequest putCapacityAssignmentConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putCapacityAssignmentConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putCapacityAssignmentConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutCapacityAssignmentConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutCapacityAssignmentConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutCapacityAssignmentConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutCapacityAssignmentConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutCapacityAssignmentConfigurationRequest, PutCapacityAssignmentConfigurationResponse>()
                            .withOperationName("PutCapacityAssignmentConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutCapacityAssignmentConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putCapacityAssignmentConfigurationRequest));
            CompletableFuture<PutCapacityAssignmentConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Submits calculations for execution within a session. You can supply the code to run as an inline code block
     * within the request.
     * </p>
     * <note>
     * <p>
     * The request syntax requires the <a>StartCalculationExecutionRequest&#36CodeBlock</a> parameter or the
     * <a>CalculationConfiguration&#36CodeBlock</a> parameter, but not both. Because
     * <a>CalculationConfiguration&#36CodeBlock</a> is deprecated, use the
     * <a>StartCalculationExecutionRequest&#36CodeBlock</a> parameter instead.
     * </p>
     * </note>
     *
     * @param startCalculationExecutionRequest
     * @return A Java Future containing the result of the StartCalculationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StartCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartCalculationExecutionResponse> startCalculationExecution(
            StartCalculationExecutionRequest startCalculationExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startCalculationExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startCalculationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCalculationExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartCalculationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartCalculationExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartCalculationExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartCalculationExecutionRequest, StartCalculationExecutionResponse>()
                            .withOperationName("StartCalculationExecution").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartCalculationExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startCalculationExecutionRequest));
            CompletableFuture<StartCalculationExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Runs the SQL query statements contained in the <code>Query</code>. Requires you to have access to the workgroup
     * in which the query ran. Running queries against an external catalog requires <a>GetDataCatalog</a> permission to
     * the catalog. For code samples using the Amazon Web Services SDK for Java, see <a
     * href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the
     * <i>Amazon Athena User Guide</i>.
     * </p>
     *
     * @param startQueryExecutionRequest
     * @return A Java Future containing the result of the StartQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StartQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartQueryExecutionResponse> startQueryExecution(
            StartQueryExecutionRequest startQueryExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startQueryExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startQueryExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartQueryExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartQueryExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartQueryExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartQueryExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartQueryExecutionRequest, StartQueryExecutionResponse>()
                            .withOperationName("StartQueryExecution").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartQueryExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startQueryExecutionRequest));
            CompletableFuture<StartQueryExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a session for running calculations within a workgroup. The session is ready when it reaches an
     * <code>IDLE</code> state.
     * </p>
     *
     * @param startSessionRequest
     * @return A Java Future containing the result of the StartSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SessionAlreadyExistsException The specified session already exists.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StartSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartSessionResponse> startSession(StartSessionRequest startSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSessionRequest, StartSessionResponse>()
                            .withOperationName("StartSession").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startSessionRequest));
            CompletableFuture<StartSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests the cancellation of a calculation. A <code>StopCalculationExecution</code> call on a calculation that is
     * already in a terminal state (for example, <code>STOPPED</code>, <code>FAILED</code>, or <code>COMPLETED</code>)
     * succeeds but has no effect.
     * </p>
     * <note>
     * <p>
     * Cancelling a calculation is done on a best effort basis. If a calculation cannot be cancelled, you can be charged
     * for its completion. If you are concerned about being charged for a calculation that cannot be cancelled, consider
     * terminating the session in which the calculation is running.
     * </p>
     * </note>
     *
     * @param stopCalculationExecutionRequest
     * @return A Java Future containing the result of the StopCalculationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StopCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopCalculationExecutionResponse> stopCalculationExecution(
            StopCalculationExecutionRequest stopCalculationExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopCalculationExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopCalculationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopCalculationExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopCalculationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopCalculationExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopCalculationExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopCalculationExecutionRequest, StopCalculationExecutionResponse>()
                            .withOperationName("StopCalculationExecution").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopCalculationExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopCalculationExecutionRequest));
            CompletableFuture<StopCalculationExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a query execution. Requires you to have access to the workgroup in which the query ran.
     * </p>
     *
     * @param stopQueryExecutionRequest
     * @return A Java Future containing the result of the StopQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StopQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecution" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopQueryExecutionResponse> stopQueryExecution(StopQueryExecutionRequest stopQueryExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopQueryExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopQueryExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopQueryExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopQueryExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopQueryExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopQueryExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopQueryExecutionRequest, StopQueryExecutionResponse>()
                            .withOperationName("StopQueryExecution").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopQueryExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopQueryExecutionRequest));
            CompletableFuture<StopQueryExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. Each tag consists of
     * a key and an optional value, both of which you define. For example, you can use tags to categorize Athena
     * workgroups, data catalogs, or capacity reservations by purpose, owner, or environment. Use a consistent set of
     * tag keys to make it easier to search and filter the resources in your account. For best practices, see <a
     * href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html">Tagging
     * Best Practices</a>. Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256
     * UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters:
     * + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify
     * more than one tag, separate them by commas.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Terminates an active session. A <code>TerminateSession</code> call on a session that is already inactive (for
     * example, in a <code>FAILED</code>, <code>TERMINATED</code> or <code>TERMINATING</code> state) succeeds but has no
     * effect. Calculations running in the session when <code>TerminateSession</code> is called are forcefully stopped,
     * but may display as <code>FAILED</code> instead of <code>STOPPED</code>.
     * </p>
     *
     * @param terminateSessionRequest
     * @return A Java Future containing the result of the TerminateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.TerminateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TerminateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TerminateSessionResponse> terminateSession(TerminateSessionRequest terminateSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(terminateSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, terminateSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TerminateSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TerminateSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TerminateSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TerminateSessionRequest, TerminateSessionResponse>()
                            .withOperationName("TerminateSession").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TerminateSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(terminateSessionRequest));
            CompletableFuture<TerminateSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from an Athena resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the number of requested data processing units for the capacity reservation with the specified name.
     * </p>
     *
     * @param updateCapacityReservationRequest
     * @return A Java Future containing the result of the UpdateCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCapacityReservationResponse> updateCapacityReservation(
            UpdateCapacityReservationRequest updateCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCapacityReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCapacityReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCapacityReservationRequest, UpdateCapacityReservationResponse>()
                            .withOperationName("UpdateCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCapacityReservationRequest));
            CompletableFuture<UpdateCapacityReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the data catalog that has the specified name.
     * </p>
     *
     * @param updateDataCatalogRequest
     * @return A Java Future containing the result of the UpdateDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDataCatalogResponse> updateDataCatalog(UpdateDataCatalogRequest updateDataCatalogRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDataCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDataCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDataCatalogResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDataCatalogResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDataCatalogRequest, UpdateDataCatalogResponse>()
                            .withOperationName("UpdateDataCatalog").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDataCatalogRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDataCatalogRequest));
            CompletableFuture<UpdateDataCatalogResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a <a>NamedQuery</a> object. The database or workgroup cannot be updated.
     * </p>
     *
     * @param updateNamedQueryRequest
     * @return A Java Future containing the result of the UpdateNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNamedQueryResponse> updateNamedQuery(UpdateNamedQueryRequest updateNamedQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNamedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNamedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNamedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNamedQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateNamedQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNamedQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNamedQueryRequest, UpdateNamedQueryResponse>()
                            .withOperationName("UpdateNamedQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateNamedQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateNamedQueryRequest));
            CompletableFuture<UpdateNamedQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the contents of a Spark notebook.
     * </p>
     *
     * @param updateNotebookRequest
     * @return A Java Future containing the result of the UpdateNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNotebookResponse> updateNotebook(UpdateNotebookRequest updateNotebookRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNotebookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNotebook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNotebookResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateNotebookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNotebookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNotebookRequest, UpdateNotebookResponse>()
                            .withOperationName("UpdateNotebook").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateNotebookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateNotebookRequest));
            CompletableFuture<UpdateNotebookResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the metadata for a notebook.
     * </p>
     *
     * @param updateNotebookMetadataRequest
     * @return A Java Future containing the result of the UpdateNotebookMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNotebookMetadataResponse> updateNotebookMetadata(
            UpdateNotebookMetadataRequest updateNotebookMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNotebookMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNotebookMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNotebookMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNotebookMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateNotebookMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNotebookMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNotebookMetadataRequest, UpdateNotebookMetadataResponse>()
                            .withOperationName("UpdateNotebookMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateNotebookMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateNotebookMetadataRequest));
            CompletableFuture<UpdateNotebookMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a prepared statement.
     * </p>
     *
     * @param updatePreparedStatementRequest
     * @return A Java Future containing the result of the UpdatePreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdatePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdatePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePreparedStatementResponse> updatePreparedStatement(
            UpdatePreparedStatementRequest updatePreparedStatementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePreparedStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePreparedStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePreparedStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePreparedStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePreparedStatementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePreparedStatementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePreparedStatementRequest, UpdatePreparedStatementResponse>()
                            .withOperationName("UpdatePreparedStatement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePreparedStatementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePreparedStatementRequest));
            CompletableFuture<UpdatePreparedStatementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the workgroup with the specified name. The workgroup's name cannot be changed. Only
     * <code>ConfigurationUpdates</code> can be specified.
     * </p>
     *
     * @param updateWorkGroupRequest
     * @return A Java Future containing the result of the UpdateWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWorkGroupResponse> updateWorkGroup(UpdateWorkGroupRequest updateWorkGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWorkGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWorkGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateWorkGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkGroupRequest, UpdateWorkGroupResponse>()
                            .withOperationName("UpdateWorkGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWorkGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateWorkGroupRequest));
            CompletableFuture<UpdateWorkGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final AthenaServiceClientConfiguration serviceClientConfiguration() {
        return new AthenaServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(AthenaException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MetadataException")
                                .exceptionBuilderSupplier(MetadataException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException")
                                .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        AthenaServiceClientConfigurationBuilder serviceConfigBuilder = new AthenaServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
