/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetPreparedStatementResponse extends AthenaResponse implements
        ToCopyableBuilder<BatchGetPreparedStatementResponse.Builder, BatchGetPreparedStatementResponse> {
    private static final SdkField<List<PreparedStatement>> PREPARED_STATEMENTS_FIELD = SdkField
            .<List<PreparedStatement>> builder(MarshallingType.LIST)
            .memberName("PreparedStatements")
            .getter(getter(BatchGetPreparedStatementResponse::preparedStatements))
            .setter(setter(Builder::preparedStatements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreparedStatements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PreparedStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(PreparedStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedPreparedStatementName>> UNPROCESSED_PREPARED_STATEMENT_NAMES_FIELD = SdkField
            .<List<UnprocessedPreparedStatementName>> builder(MarshallingType.LIST)
            .memberName("UnprocessedPreparedStatementNames")
            .getter(getter(BatchGetPreparedStatementResponse::unprocessedPreparedStatementNames))
            .setter(setter(Builder::unprocessedPreparedStatementNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedPreparedStatementNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedPreparedStatementName> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedPreparedStatementName::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREPARED_STATEMENTS_FIELD,
            UNPROCESSED_PREPARED_STATEMENT_NAMES_FIELD));

    private final List<PreparedStatement> preparedStatements;

    private final List<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames;

    private BatchGetPreparedStatementResponse(BuilderImpl builder) {
        super(builder);
        this.preparedStatements = builder.preparedStatements;
        this.unprocessedPreparedStatementNames = builder.unprocessedPreparedStatementNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the PreparedStatements property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPreparedStatements() {
        return preparedStatements != null && !(preparedStatements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of prepared statements returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPreparedStatements} method.
     * </p>
     * 
     * @return The list of prepared statements returned.
     */
    public final List<PreparedStatement> preparedStatements() {
        return preparedStatements;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedPreparedStatementNames
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasUnprocessedPreparedStatementNames() {
        return unprocessedPreparedStatementNames != null && !(unprocessedPreparedStatementNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more prepared statements that were requested but could not be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedPreparedStatementNames}
     * method.
     * </p>
     * 
     * @return A list of one or more prepared statements that were requested but could not be returned.
     */
    public final List<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames() {
        return unprocessedPreparedStatementNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPreparedStatements() ? preparedStatements() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasUnprocessedPreparedStatementNames() ? unprocessedPreparedStatementNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPreparedStatementResponse)) {
            return false;
        }
        BatchGetPreparedStatementResponse other = (BatchGetPreparedStatementResponse) obj;
        return hasPreparedStatements() == other.hasPreparedStatements()
                && Objects.equals(preparedStatements(), other.preparedStatements())
                && hasUnprocessedPreparedStatementNames() == other.hasUnprocessedPreparedStatementNames()
                && Objects.equals(unprocessedPreparedStatementNames(), other.unprocessedPreparedStatementNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchGetPreparedStatementResponse")
                .add("PreparedStatements", hasPreparedStatements() ? preparedStatements() : null)
                .add("UnprocessedPreparedStatementNames",
                        hasUnprocessedPreparedStatementNames() ? unprocessedPreparedStatementNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreparedStatements":
            return Optional.ofNullable(clazz.cast(preparedStatements()));
        case "UnprocessedPreparedStatementNames":
            return Optional.ofNullable(clazz.cast(unprocessedPreparedStatementNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPreparedStatementResponse, T> g) {
        return obj -> g.apply((BatchGetPreparedStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetPreparedStatementResponse> {
        /**
         * <p>
         * The list of prepared statements returned.
         * </p>
         * 
         * @param preparedStatements
         *        The list of prepared statements returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preparedStatements(Collection<PreparedStatement> preparedStatements);

        /**
         * <p>
         * The list of prepared statements returned.
         * </p>
         * 
         * @param preparedStatements
         *        The list of prepared statements returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preparedStatements(PreparedStatement... preparedStatements);

        /**
         * <p>
         * The list of prepared statements returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.athena.model.PreparedStatement.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.athena.model.PreparedStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.athena.model.PreparedStatement.Builder#build()} is called immediately
         * and its result is passed to {@link #preparedStatements(List<PreparedStatement>)}.
         * 
         * @param preparedStatements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.athena.model.PreparedStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preparedStatements(java.util.Collection<PreparedStatement>)
         */
        Builder preparedStatements(Consumer<PreparedStatement.Builder>... preparedStatements);

        /**
         * <p>
         * A list of one or more prepared statements that were requested but could not be returned.
         * </p>
         * 
         * @param unprocessedPreparedStatementNames
         *        A list of one or more prepared statements that were requested but could not be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedPreparedStatementNames(Collection<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames);

        /**
         * <p>
         * A list of one or more prepared statements that were requested but could not be returned.
         * </p>
         * 
         * @param unprocessedPreparedStatementNames
         *        A list of one or more prepared statements that were requested but could not be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedPreparedStatementNames(UnprocessedPreparedStatementName... unprocessedPreparedStatementNames);

        /**
         * <p>
         * A list of one or more prepared statements that were requested but could not be returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementName.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementName#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementName.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #unprocessedPreparedStatementNames(List<UnprocessedPreparedStatementName>)}.
         * 
         * @param unprocessedPreparedStatementNames
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedPreparedStatementNames(java.util.Collection<UnprocessedPreparedStatementName>)
         */
        Builder unprocessedPreparedStatementNames(
                Consumer<UnprocessedPreparedStatementName.Builder>... unprocessedPreparedStatementNames);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private List<PreparedStatement> preparedStatements = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPreparedStatementResponse model) {
            super(model);
            preparedStatements(model.preparedStatements);
            unprocessedPreparedStatementNames(model.unprocessedPreparedStatementNames);
        }

        public final List<PreparedStatement.Builder> getPreparedStatements() {
            List<PreparedStatement.Builder> result = PreparedStatementDetailsListCopier.copyToBuilder(this.preparedStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreparedStatements(Collection<PreparedStatement.BuilderImpl> preparedStatements) {
            this.preparedStatements = PreparedStatementDetailsListCopier.copyFromBuilder(preparedStatements);
        }

        @Override
        public final Builder preparedStatements(Collection<PreparedStatement> preparedStatements) {
            this.preparedStatements = PreparedStatementDetailsListCopier.copy(preparedStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preparedStatements(PreparedStatement... preparedStatements) {
            preparedStatements(Arrays.asList(preparedStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preparedStatements(Consumer<PreparedStatement.Builder>... preparedStatements) {
            preparedStatements(Stream.of(preparedStatements).map(c -> PreparedStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedPreparedStatementName.Builder> getUnprocessedPreparedStatementNames() {
            List<UnprocessedPreparedStatementName.Builder> result = UnprocessedPreparedStatementNameListCopier
                    .copyToBuilder(this.unprocessedPreparedStatementNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedPreparedStatementNames(
                Collection<UnprocessedPreparedStatementName.BuilderImpl> unprocessedPreparedStatementNames) {
            this.unprocessedPreparedStatementNames = UnprocessedPreparedStatementNameListCopier
                    .copyFromBuilder(unprocessedPreparedStatementNames);
        }

        @Override
        public final Builder unprocessedPreparedStatementNames(
                Collection<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames) {
            this.unprocessedPreparedStatementNames = UnprocessedPreparedStatementNameListCopier
                    .copy(unprocessedPreparedStatementNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedPreparedStatementNames(
                UnprocessedPreparedStatementName... unprocessedPreparedStatementNames) {
            unprocessedPreparedStatementNames(Arrays.asList(unprocessedPreparedStatementNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedPreparedStatementNames(
                Consumer<UnprocessedPreparedStatementName.Builder>... unprocessedPreparedStatementNames) {
            unprocessedPreparedStatementNames(Stream.of(unprocessedPreparedStatementNames)
                    .map(c -> UnprocessedPreparedStatementName.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetPreparedStatementResponse build() {
            return new BatchGetPreparedStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
