/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDataCatalogResponse extends AthenaResponse implements
        ToCopyableBuilder<DeleteDataCatalogResponse.Builder, DeleteDataCatalogResponse> {
    private static final SdkField<DataCatalog> DATA_CATALOG_FIELD = SdkField.<DataCatalog> builder(MarshallingType.SDK_POJO)
            .memberName("DataCatalog").getter(getter(DeleteDataCatalogResponse::dataCatalog))
            .setter(setter(Builder::dataCatalog)).constructor(DataCatalog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalog").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_CATALOG_FIELD));

    private final DataCatalog dataCatalog;

    private DeleteDataCatalogResponse(BuilderImpl builder) {
        super(builder);
        this.dataCatalog = builder.dataCatalog;
    }

    /**
     * Returns the value of the DataCatalog property for this object.
     * 
     * @return The value of the DataCatalog property for this object.
     */
    public final DataCatalog dataCatalog() {
        return dataCatalog;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataCatalog());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataCatalogResponse)) {
            return false;
        }
        DeleteDataCatalogResponse other = (DeleteDataCatalogResponse) obj;
        return Objects.equals(dataCatalog(), other.dataCatalog());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDataCatalogResponse").add("DataCatalog", dataCatalog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataCatalog":
            return Optional.ofNullable(clazz.cast(dataCatalog()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataCatalogResponse, T> g) {
        return obj -> g.apply((DeleteDataCatalogResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDataCatalogResponse> {
        /**
         * Sets the value of the DataCatalog property for this object.
         *
         * @param dataCatalog
         *        The new value for the DataCatalog property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCatalog(DataCatalog dataCatalog);

        /**
         * Sets the value of the DataCatalog property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataCatalog.Builder} avoiding the need to
         * create one manually via {@link DataCatalog#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataCatalog.Builder#build()} is called immediately and its result
         * is passed to {@link #dataCatalog(DataCatalog)}.
         * 
         * @param dataCatalog
         *        a consumer that will call methods on {@link DataCatalog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCatalog(DataCatalog)
         */
        default Builder dataCatalog(Consumer<DataCatalog.Builder> dataCatalog) {
            return dataCatalog(DataCatalog.builder().applyMutation(dataCatalog).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private DataCatalog dataCatalog;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataCatalogResponse model) {
            super(model);
            dataCatalog(model.dataCatalog);
        }

        public final DataCatalog.Builder getDataCatalog() {
            return dataCatalog != null ? dataCatalog.toBuilder() : null;
        }

        public final void setDataCatalog(DataCatalog.BuilderImpl dataCatalog) {
            this.dataCatalog = dataCatalog != null ? dataCatalog.build() : null;
        }

        @Override
        public final Builder dataCatalog(DataCatalog dataCatalog) {
            this.dataCatalog = dataCatalog;
            return this;
        }

        @Override
        public DeleteDataCatalogResponse build() {
            return new DeleteDataCatalogResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
