/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryRuntimeStatisticsResponse extends AthenaResponse implements
        ToCopyableBuilder<GetQueryRuntimeStatisticsResponse.Builder, GetQueryRuntimeStatisticsResponse> {
    private static final SdkField<QueryRuntimeStatistics> QUERY_RUNTIME_STATISTICS_FIELD = SdkField
            .<QueryRuntimeStatistics> builder(MarshallingType.SDK_POJO).memberName("QueryRuntimeStatistics")
            .getter(getter(GetQueryRuntimeStatisticsResponse::queryRuntimeStatistics))
            .setter(setter(Builder::queryRuntimeStatistics)).constructor(QueryRuntimeStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryRuntimeStatistics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(QUERY_RUNTIME_STATISTICS_FIELD));

    private final QueryRuntimeStatistics queryRuntimeStatistics;

    private GetQueryRuntimeStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.queryRuntimeStatistics = builder.queryRuntimeStatistics;
    }

    /**
     * <p>
     * Runtime statistics about the query execution.
     * </p>
     * 
     * @return Runtime statistics about the query execution.
     */
    public final QueryRuntimeStatistics queryRuntimeStatistics() {
        return queryRuntimeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryRuntimeStatistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryRuntimeStatisticsResponse)) {
            return false;
        }
        GetQueryRuntimeStatisticsResponse other = (GetQueryRuntimeStatisticsResponse) obj;
        return Objects.equals(queryRuntimeStatistics(), other.queryRuntimeStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueryRuntimeStatisticsResponse").add("QueryRuntimeStatistics", queryRuntimeStatistics())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryRuntimeStatistics":
            return Optional.ofNullable(clazz.cast(queryRuntimeStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryRuntimeStatisticsResponse, T> g) {
        return obj -> g.apply((GetQueryRuntimeStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQueryRuntimeStatisticsResponse> {
        /**
         * <p>
         * Runtime statistics about the query execution.
         * </p>
         * 
         * @param queryRuntimeStatistics
         *        Runtime statistics about the query execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryRuntimeStatistics(QueryRuntimeStatistics queryRuntimeStatistics);

        /**
         * <p>
         * Runtime statistics about the query execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryRuntimeStatistics.Builder} avoiding
         * the need to create one manually via {@link QueryRuntimeStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryRuntimeStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #queryRuntimeStatistics(QueryRuntimeStatistics)}.
         * 
         * @param queryRuntimeStatistics
         *        a consumer that will call methods on {@link QueryRuntimeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryRuntimeStatistics(QueryRuntimeStatistics)
         */
        default Builder queryRuntimeStatistics(Consumer<QueryRuntimeStatistics.Builder> queryRuntimeStatistics) {
            return queryRuntimeStatistics(QueryRuntimeStatistics.builder().applyMutation(queryRuntimeStatistics).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private QueryRuntimeStatistics queryRuntimeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryRuntimeStatisticsResponse model) {
            super(model);
            queryRuntimeStatistics(model.queryRuntimeStatistics);
        }

        public final QueryRuntimeStatistics.Builder getQueryRuntimeStatistics() {
            return queryRuntimeStatistics != null ? queryRuntimeStatistics.toBuilder() : null;
        }

        public final void setQueryRuntimeStatistics(QueryRuntimeStatistics.BuilderImpl queryRuntimeStatistics) {
            this.queryRuntimeStatistics = queryRuntimeStatistics != null ? queryRuntimeStatistics.build() : null;
        }

        @Override
        public final Builder queryRuntimeStatistics(QueryRuntimeStatistics queryRuntimeStatistics) {
            this.queryRuntimeStatistics = queryRuntimeStatistics;
            return this;
        }

        @Override
        public GetQueryRuntimeStatisticsResponse build() {
            return new GetQueryRuntimeStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
