/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PreparedStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PreparedStatement> {
    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementName").getter(PreparedStatement.getter(PreparedStatement::statementName)).setter(PreparedStatement.setter(Builder::statementName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()}).build();
    private static final SdkField<String> QUERY_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryStatement").getter(PreparedStatement.getter(PreparedStatement::queryStatement)).setter(PreparedStatement.setter(Builder::queryStatement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatement").build()}).build();
    private static final SdkField<String> WORK_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroupName").getter(PreparedStatement.getter(PreparedStatement::workGroupName)).setter(PreparedStatement.setter(Builder::workGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroupName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PreparedStatement.getter(PreparedStatement::description)).setter(PreparedStatement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(PreparedStatement.getter(PreparedStatement::lastModifiedTime)).setter(PreparedStatement.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_NAME_FIELD, QUERY_STATEMENT_FIELD, WORK_GROUP_NAME_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StatementName", STATEMENT_NAME_FIELD);
            this.put("QueryStatement", QUERY_STATEMENT_FIELD);
            this.put("WorkGroupName", WORK_GROUP_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String statementName;
    private final String queryStatement;
    private final String workGroupName;
    private final String description;
    private final Instant lastModifiedTime;

    private PreparedStatement(BuilderImpl builder) {
        this.statementName = builder.statementName;
        this.queryStatement = builder.queryStatement;
        this.workGroupName = builder.workGroupName;
        this.description = builder.description;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String statementName() {
        return this.statementName;
    }

    public final String queryStatement() {
        return this.queryStatement;
    }

    public final String workGroupName() {
        return this.workGroupName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreparedStatement)) {
            return false;
        }
        PreparedStatement other = (PreparedStatement)obj;
        return Objects.equals(this.statementName(), other.statementName()) && Objects.equals(this.queryStatement(), other.queryStatement()) && Objects.equals(this.workGroupName(), other.workGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"PreparedStatement").add("StatementName", (Object)this.statementName()).add("QueryStatement", (Object)this.queryStatement()).add("WorkGroupName", (Object)this.workGroupName()).add("Description", (Object)this.description()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatementName": {
                return Optional.ofNullable(clazz.cast(this.statementName()));
            }
            case "QueryStatement": {
                return Optional.ofNullable(clazz.cast(this.queryStatement()));
            }
            case "WorkGroupName": {
                return Optional.ofNullable(clazz.cast(this.workGroupName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PreparedStatement, T> g) {
        return obj -> g.apply((PreparedStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String statementName;
        private String queryStatement;
        private String workGroupName;
        private String description;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PreparedStatement model) {
            this.statementName(model.statementName);
            this.queryStatement(model.queryStatement);
            this.workGroupName(model.workGroupName);
            this.description(model.description);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getStatementName() {
            return this.statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final String getQueryStatement() {
            return this.queryStatement;
        }

        public final void setQueryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
        }

        @Override
        public final Builder queryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        public final String getWorkGroupName() {
            return this.workGroupName;
        }

        public final void setWorkGroupName(String workGroupName) {
            this.workGroupName = workGroupName;
        }

        @Override
        public final Builder workGroupName(String workGroupName) {
            this.workGroupName = workGroupName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public PreparedStatement build() {
            return new PreparedStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PreparedStatement> {
        public Builder statementName(String var1);

        public Builder queryStatement(String var1);

        public Builder workGroupName(String var1);

        public Builder description(String var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

